/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.ud.intermediate;

import com.mapinfo.mapmarker.CAN.dp.CAN_MMJRangeRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJSegmentRecord;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;

public class CAN_UDIntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    private static final int RANGE_LDU = 33;

    public CAN_UDIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected MMJStreetRecord getStreetRecordType() {
        return new CAN_MMJStreetRecord();
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new CAN_MMJSegmentRecord();
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new CAN_MMJRangeRecord();
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        CAN_MMJRangeRecord canRecord = (CAN_MMJRangeRecord)record;
        if (canRecord.getLDU() != null) {
            try {
                item.putString(33, canRecord.getLDU());
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                throw new DataSourceException(14, (Throwable)MMJETASEEx);
            }
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        if (item.hasString(33)) {
            CAN_MMJRangeRecord canRecord = (CAN_MMJRangeRecord)record;
            try {
                canRecord.setLDU(item.getString(33));
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                throw new DataSourceException(14, (Throwable)MMJETASEEx);
            }
        }
    }
}

