/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class BetterStreetTypeRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        if (inputAddresses == null || inputAddresses.length < 1) {
            return false;
        }
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (best.getMainAddressScore() != other.getMainAddressScore() || best.getPreDirectionalScore() != other.getPreDirectionalScore() || best.getPostDirectionalScore() != other.getPostDirectionalScore() || best.getAddressNumberScore() != other.getAddressNumberScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore()) {
            return false;
        }
        String inputPreType = inputAddresses[0].getPreThoroughfareType();
        String inputPostType = inputAddresses[0].getPostThoroughfareType();
        if (inputPreType == null && inputPostType == null) {
            return best.getPreThoroughfareType() == null && best.getPostThoroughfareType() == null && (other.getPreThoroughfareType() != null || other.getPostThoroughfareType() != null);
        }
        if (inputPreType == null) {
            if (best.getPostThoroughfareTypeScore() == 1.0 && other.getPostThoroughfareTypeScore() != 1.0) {
                return true;
            }
            if (best.getPostThoroughfareTypeScore() != 1.0 && other.getPostThoroughfareTypeScore() == 1.0) {
                return false;
            }
        } else {
            if (best.getPreThoroughfareTypeScore() == 1.0 && other.getPreThoroughfareTypeScore() != 1.0) {
                return true;
            }
            if (best.getPreThoroughfareTypeScore() != 1.0 && other.getPreThoroughfareTypeScore() == 1.0) {
                return false;
            }
        }
        return false;
    }
}

