/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class DemoteProbableAliasRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        if (inputAddresses == null || inputAddresses.length < 1) {
            return false;
        }
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (!StringUtilities.equalStrings((String)best.getSegment().getSegmentId(), (String)other.getSegment().getSegmentId())) {
            return false;
        }
        if (best.getMainAddressScore() != other.getMainAddressScore() || best.getPreDirectionalScore() != other.getPreDirectionalScore() || best.getPostDirectionalScore() != other.getPostDirectionalScore() || best.getAddressNumberScore() != other.getAddressNumberScore() || best.getCombinedAddressScore() != other.getCombinedAddressScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore()) {
            return false;
        }
        String inputPreType = inputAddresses[0].getPreThoroughfareType();
        String inputPostType = inputAddresses[0].getPostThoroughfareType();
        if (StringUtilities.isEmpty((String)inputPostType) && StringUtilities.isEmpty((String)inputPreType)) {
            return false;
        }
        String bestPreType = best.getPreThoroughfareType();
        String bestPostType = best.getPostThoroughfareType();
        String otherPreType = other.getPreThoroughfareType();
        String otherPostType = other.getPostThoroughfareType();
        if (StringUtilities.equalStrings((String)bestPreType, (String)otherPreType) && StringUtilities.equalStrings((String)bestPostType, (String)otherPostType)) {
            return false;
        }
        return StringUtilities.equalStrings((String)inputPreType, (String)bestPreType) && StringUtilities.equalStrings((String)inputPostType, (String)bestPostType) && !StringUtilities.equalStrings((String)inputPreType, (String)otherPreType) && !StringUtilities.equalStrings((String)inputPostType, (String)otherPostType);
    }
}

