/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.CAN.CAN_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class DuplicatesRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        CAN_InternalCandidateAddress best = (CAN_InternalCandidateAddress)bestCandidate;
        CAN_InternalCandidateAddress other = (CAN_InternalCandidateAddress)otherCandidate;
        if (best.getCombinedAddressScore() != other.getCombinedAddressScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore() || best.getAdditionalParserFieldsScore() != other.getAdditionalParserFieldsScore()) {
            return false;
        }
        if (!best.getFormattedLocationAddress().equals(other.getFormattedLocationAddress())) {
            return false;
        }
        if (best.getFormattedStreetAddress().equals(other.getFormattedStreetAddress())) {
            ParsedNumber inputNumber = inputAddresses[0].getParsedAddressNumber();
            return inputNumber != null && !inputNumber.isEmpty() || best.getAddressNumber() != null && (best.getAddressNumber() == null || !best.getAddressNumber().isEmpty()) || other.getAddressNumber() != null && (other.getAddressNumber() == null || !other.getAddressNumber().isEmpty()) || other.getSegment().getSegmentPointCount() <= 0 || best.getSegment().getSegmentPointCount() > 0;
        }
        if (best.getOriginalName() != null || other.getOriginalName() != null) {
            String bestNoOriginalFormattedStreet = best.getFormattedStreetIgnoreOriginalName();
            String otherNoOriginalFormattedStreet = other.getFormattedStreetIgnoreOriginalName();
            return bestNoOriginalFormattedStreet.equals(otherNoOriginalFormattedStreet);
        }
        return false;
    }
}

