/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import com.mapinfo.mapmarker.CAN.dp.ICAN_IDDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.IMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeInputRecordBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.MultiSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.StreetNameGenerator;
import com.mapinfo.mapmarker.CAN.dp.merge.text.OutputSegmentBuilder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetNameReplacementProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.CloseMatchInputSource;
import com.mapinfo.mapmarker.CAN.dp.tab.CAN_TabWithIDStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.IOException;

public class DataSourceHandler {
    private String m_dataSourceSpec;
    private String m_province;
    private boolean m_bUseCloseSource;
    private IDataSource m_source;
    private CloseMatchInputSource m_closeSource;
    private SingleSACMergeInputRecord m_leftOver;
    private MergeInputRecordBuilder m_recordBuilder;

    public DataSourceHandler(String dataSourceSpec, String province) {
        this.m_dataSourceSpec = dataSourceSpec;
        this.m_province = province;
    }

    public void init() throws DataSourceException {
        System.out.println(this.m_dataSourceSpec);
        if (this.m_dataSourceSpec != null) {
            String testString = this.m_dataSourceSpec.substring(this.m_dataSourceSpec.length() - 4);
            System.out.println(testString);
            if (".TAB".equalsIgnoreCase(testString)) {
                try {
                    this.m_source = new TabFileDataSource(FileUtilities.loadProperties((String)"com.mapinfo.mapmarker.CAN.gui.StandardTabSourceProps.properties"));
                    String[] args = new String[]{this.m_dataSourceSpec};
                    System.out.println("Opening tab data source: " + this.m_dataSourceSpec);
                    this.m_source.open(args);
                    this.m_recordBuilder = new MergeInputRecordBuilder(new StreetNameGenerator(new StreetNameReplacementProvider(null), true), new OutputSegmentBuilder(this.m_province));
                }
                catch (IOException IOEx) {
                    throw new DataSourceException("Unable to load StandardTabSourceProps.properties");
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            } else {
                System.out.println("close source");
                this.m_closeSource = new CloseMatchInputSource();
                this.m_closeSource.open(this.m_dataSourceSpec);
                this.m_bUseCloseSource = true;
            }
        }
    }

    public SingleSACMergeInputRecord getNextRecord() throws DataSourceException {
        if (this.m_bUseCloseSource) {
            return this.getNextCloseRecord();
        }
        return this.getNextTabRecord();
    }

    private SingleSACMergeInputRecord getNextCloseRecord() throws DataSourceException {
        return this.m_closeSource.getNextCloseMatchRecord();
    }

    private SingleSACMergeInputRecord getNextTabRecord() throws DataSourceException {
        IMergeInputRecord record;
        if (this.m_leftOver != null) {
            SingleSACMergeInputRecord record2 = this.m_leftOver;
            this.m_leftOver = null;
            return record2;
        }
        TabDataSourceRecordObjects objects = (TabDataSourceRecordObjects)this.m_source.getNextDataSourceRecordObjects();
        if (objects == null) {
            return null;
        }
        CAN_TabWithIDStreetDataSourceRecord street = new CAN_TabWithIDStreetDataSourceRecord(objects);
        if (((ICAN_IDDataSourceRecord)street).hasID()) {
            SourceRecordDataIDProvider.getProvider().setCurrentID(((ICAN_IDDataSourceRecord)street).getID());
        }
        if ((record = this.m_recordBuilder.makeRecord(street)) instanceof SingleSACMergeInputRecord) {
            return (SingleSACMergeInputRecord)record;
        }
        this.m_leftOver = ((MultiSACMergeInputRecord)record).getRightRecord();
        return ((MultiSACMergeInputRecord)record).getLeftRecord();
    }
}

