/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.dp.CANPost.AccentsLookup;
import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeUtilities;
import com.mapinfo.mapmarker.CAN.dp.merge.SingleSACMergeInputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.SourceRecordDataIDProvider;
import com.mapinfo.mapmarker.CAN.dp.merge.close.UnsupportedCloseMatchModeException;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergeRecorder;
import com.mapinfo.mapmarker.CAN.dp.merge.text.close.CloseMatchMergeSource;
import com.mapinfo.mapmarker.CAN.dp.text.CANPost.TextAccentsLoader;
import com.mapinfo.mapmarker.CAN.gui.CANPostRecordTableModel;
import com.mapinfo.mapmarker.CAN.gui.CANPostRecordsPanel;
import com.mapinfo.mapmarker.CAN.gui.DataSourceHandler;
import com.mapinfo.mapmarker.CAN.gui.OptionPanel;
import com.mapinfo.mapmarker.CAN.gui.ParsePanel;
import com.mapinfo.mapmarker.CAN.gui.SourceRecordPanel;
import com.mapinfo.mapmarker.CAN.gui.StatusDialog;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;

public class MainForm {
    private static final String[] PROVINCES = new String[]{"AB", "BC", "MB", "NB", "NL", "NS", "NT", "ON", "PE", "QC", "SK", "YT"};
    private JFrame m_frame;
    private JPanel m_mainPanel;
    private SourceRecordPanel m_sourceRecordPanel;
    private ParsePanel m_parsePanel;
    private CANPostRecordsPanel m_CANPostPanel;
    private OptionPanel m_optionPanel;
    private JButton m_nextRecordButton;
    private String m_province;
    private String m_sourceFileSpec;
    private String m_CANPostPathSpec;
    private String m_CANPostCombinedPathSpec;
    private String m_usedRecordsIndexSpec;
    private DataSourceHandler m_dataSourceHandler;
    private SingleSACMergeInputRecord m_record;
    private Iterator m_streetNamesIterator;
    private Iterator m_segmentsIterator;
    private AccentsLookup m_accents;
    private CloseMatchMergeSource m_closeSource;
    private ArrayList m_CANPostRecords;
    private MergeRecorder m_mergeRecorder;
    private ArrayList m_leftOverCANPostRecords;
    private JCheckBox m_showLeftOversCheckBox;
    private CANPostRecordTableModel m_CANPostModel;
    private boolean m_bShowRuralSource = false;
    private boolean m_bAutoParse = true;
    private boolean m_bAutoSearch = true;
    private int m_autoSearchMode = 4;

    private void fillMainPanel() {
        GridBagLayout mainLayout = new GridBagLayout();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(mainLayout);
        this.m_nextRecordButton = new JButton("Next -->");
        this.m_nextRecordButton.setEnabled(false);
        this.m_nextRecordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.displayNextSourceRecord();
            }
        });
        this.m_sourceRecordPanel = new SourceRecordPanel();
        this.m_sourceRecordPanel.init(this.m_nextRecordButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 5;
        constraints.gridheight = 10;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        mainLayout.setConstraints(this.m_sourceRecordPanel, constraints);
        this.m_mainPanel.add(this.m_sourceRecordPanel);
        this.m_parsePanel = new ParsePanel(false);
        this.m_parsePanel.init();
        constraints.gridy += 10;
        constraints.gridheight = 1;
        constraints.fill = 0;
        mainLayout.setConstraints(this.m_parsePanel, constraints);
        this.m_mainPanel.add(this.m_parsePanel);
        JPanel actionPanel = this.makeActionPanel();
        constraints.gridy += 5;
        constraints.fill = 1;
        constraints.fill = 2;
        mainLayout.setConstraints(actionPanel, constraints);
        this.m_mainPanel.add(actionPanel);
        this.m_showLeftOversCheckBox = new JCheckBox();
        this.m_showLeftOversCheckBox.setText("Show leftovers only");
        this.m_showLeftOversCheckBox.setEnabled(false);
        this.m_showLeftOversCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainForm.this.m_showLeftOversCheckBox.isSelected()) {
                    MainForm.this.selectLeftOvers();
                } else {
                    MainForm.this.selectAllRecords();
                }
            }
        });
        this.m_optionPanel = new OptionPanel();
        this.m_optionPanel.init(this.m_showLeftOversCheckBox);
        constraints.gridy += 2;
        constraints.gridheight = 2;
        mainLayout.setConstraints(this.m_optionPanel, constraints);
        this.m_mainPanel.add(this.m_optionPanel);
        this.m_CANPostModel = new CANPostRecordTableModel();
        this.m_CANPostPanel = new CANPostRecordsPanel();
        this.m_CANPostPanel.init(this.m_CANPostModel);
        constraints.gridy += 2;
        constraints.fill = 1;
        constraints.gridheight = 15;
        constraints.anchor = 10;
        mainLayout.setConstraints(this.m_CANPostPanel, constraints);
        this.m_mainPanel.add(this.m_CANPostPanel);
    }

    private JMenuBar makeMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenu province = this.makeProvinceMenu();
        fileMenu.add(province);
        fileMenu.addSeparator();
        JMenuItem loadSource = new JMenuItem("Open source...");
        loadSource.setMnemonic(79);
        fileMenu.add(loadSource);
        JMenuItem usedRecords = new JMenuItem("Open used record index...");
        usedRecords.setMnemonic(85);
        fileMenu.add(usedRecords);
        fileMenu.addSeparator();
        JMenuItem setCANPostCombinedPath = new JMenuItem("Set CANPost combined path...");
        setCANPostCombinedPath.setMnemonic(67);
        fileMenu.add(setCANPostCombinedPath);
        JMenuItem setCANPostPath = new JMenuItem("Set CANPost path...");
        setCANPostPath.setMnemonic(83);
        fileMenu.add(setCANPostPath);
        fileMenu.addSeparator();
        JMenuItem setup = new JMenuItem("View current setup...");
        setup.setMnemonic(86);
        fileMenu.add(setup);
        fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic(88);
        fileMenu.add(exit);
        loadSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.loadSourceData();
            }
        });
        usedRecords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.loadUsedRecords();
            }
        });
        setCANPostPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.setCANPostPath();
            }
        });
        setCANPostCombinedPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.setCANPostCombinedPath();
            }
        });
        setup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.displayStatus();
            }
        });
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.m_frame.removeAll();
                MainForm.this.m_frame.dispose();
                System.exit(0);
            }
        });
        menuBar.add(this.makeOptionsMenu());
        return menuBar;
    }

    private JMenu makeProvinceMenu() {
        JMenu menu = new JMenu("Choose province");
        menu.setMnemonic(80);
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < PROVINCES.length; ++i) {
            JRadioButtonMenuItem subItem = new JRadioButtonMenuItem(PROVINCES[i]);
            subItem.addActionListener(new ProvinceListener(this, PROVINCES[i]));
            group.add(subItem);
            menu.add(subItem);
        }
        return menu;
    }

    private JMenu makeOptionsMenu() {
        JMenu menu = new JMenu("Options");
        menu.setMnemonic(79);
        JCheckBoxMenuItem showRuralItem = new JCheckBoxMenuItem("Show rural source");
        showRuralItem.setMnemonic(82);
        showRuralItem.setSelected(true);
        this.m_bShowRuralSource = true;
        showRuralItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                MainForm.this.m_bShowRuralSource = item.isSelected();
            }
        });
        menu.add(showRuralItem);
        menu.addSeparator();
        JCheckBoxMenuItem autoParseItem = new JCheckBoxMenuItem("Auto parse");
        autoParseItem.setMnemonic(80);
        autoParseItem.setSelected(true);
        this.m_bAutoParse = true;
        autoParseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                MainForm.this.m_bAutoParse = item.isSelected();
            }
        });
        menu.add(autoParseItem);
        menu.addSeparator();
        JMenu searchMenu = new JMenu("Auto search...");
        searchMenu.setMnemonic(83);
        ButtonGroup searches = new ButtonGroup();
        JRadioButtonMenuItem searchNone = new JRadioButtonMenuItem("None");
        searchNone.setMnemonic(78);
        searchNone.addActionListener(new AutoSearchListener(this, false, -1));
        searches.add(searchNone);
        searchMenu.add(searchNone);
        JRadioButtonMenuItem searchStandard = new JRadioButtonMenuItem("Standard");
        searchStandard.setMnemonic(83);
        searchStandard.addActionListener(new AutoSearchListener(this, true, 0));
        searches.add(searchStandard);
        searchMenu.add(searchStandard);
        JRadioButtonMenuItem searchSoundex = new JRadioButtonMenuItem("Soundex");
        searchSoundex.setMnemonic(88);
        searchSoundex.addActionListener(new AutoSearchListener(this, true, 2));
        searches.add(searchSoundex);
        searchMenu.add(searchSoundex);
        JRadioButtonMenuItem searchNoArticles = new JRadioButtonMenuItem("No articles");
        searchNoArticles.setMnemonic(65);
        searchNoArticles.addActionListener(new AutoSearchListener(this, true, 1));
        searches.add(searchNoArticles);
        searchMenu.add(searchNoArticles);
        JRadioButtonMenuItem searchNoDirs = new JRadioButtonMenuItem("No dirs");
        searchNoDirs.setMnemonic(68);
        searchNoDirs.addActionListener(new AutoSearchListener(this, true, 3));
        searches.add(searchNoDirs);
        searchMenu.add(searchNoDirs);
        JRadioButtonMenuItem searchIgnoreTypes = new JRadioButtonMenuItem("Ignore types");
        searchIgnoreTypes.setMnemonic(84);
        searchIgnoreTypes.addActionListener(new AutoSearchListener(this, true, 5));
        searches.add(searchIgnoreTypes);
        searchMenu.add(searchIgnoreTypes);
        JRadioButtonMenuItem searchSoundexRaw = new JRadioButtonMenuItem("Raw soundex");
        searchSoundexRaw.setMnemonic(82);
        searchSoundex.addActionListener(new AutoSearchListener(this, true, 4));
        searches.add(searchSoundexRaw);
        searchMenu.add(searchSoundexRaw);
        menu.add(searchMenu);
        return menu;
    }

    private JPanel makeActionPanel() {
        JPanel actionPanel = new JPanel();
        actionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 35, 5, 35), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Actions"), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        GridBagLayout layout = new GridBagLayout();
        actionPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 10;
        JButton searchButton = new JButton("Search");
        searchButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5), searchButton.getBorder()));
        constraints.gridy = 0;
        constraints.gridx = 1;
        layout.setConstraints(searchButton, constraints);
        actionPanel.add(searchButton);
        searchButton.addActionListener(new SearchListener(0));
        JButton soundexSearchButton = new JButton("Soundex search");
        soundexSearchButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), soundexSearchButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(soundexSearchButton, constraints);
        actionPanel.add(soundexSearchButton);
        soundexSearchButton.addActionListener(new SearchListener(2));
        JButton searchNoArticlesButton = new JButton("Search no articles");
        searchNoArticlesButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), searchNoArticlesButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(searchNoArticlesButton, constraints);
        actionPanel.add(searchNoArticlesButton);
        searchNoArticlesButton.addActionListener(new SearchListener(1));
        JButton searchNoDirsButton = new JButton("Search no dirs");
        searchNoDirsButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), searchNoDirsButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(searchNoDirsButton, constraints);
        actionPanel.add(searchNoDirsButton);
        searchNoDirsButton.addActionListener(new SearchListener(3));
        JButton ignoreTypesButton = new JButton("Search ignore types");
        ignoreTypesButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), ignoreTypesButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(ignoreTypesButton, constraints);
        actionPanel.add(ignoreTypesButton);
        ignoreTypesButton.addActionListener(new SearchListener(5));
        JButton soundexRawButton = new JButton("Search soundex raw");
        soundexRawButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), soundexRawButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(soundexRawButton, constraints);
        actionPanel.add(soundexRawButton);
        soundexRawButton.addActionListener(new SearchListener(4));
        JButton parseButton = new JButton("Parse");
        parseButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), parseButton.getBorder()));
        ++constraints.gridx;
        layout.setConstraints(parseButton, constraints);
        actionPanel.add(parseButton);
        parseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.parse();
            }
        });
        return actionPanel;
    }

    private void setCurrentProvince(String province) {
        this.m_province = province;
    }

    private void loadSourceData() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Load source data...");
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        SourceFileFilter mainFilter = new SourceFileFilter();
        chooser.addChoosableFileFilter(mainFilter);
        chooser.addChoosableFileFilter(new PreCloseSourceFileFilter());
        chooser.addChoosableFileFilter(new CloseOneSourceFileFilter());
        chooser.addChoosableFileFilter(new CloseTwoSourceFileFilter());
        chooser.setFileFilter(mainFilter);
        int returnVal = chooser.showOpenDialog(this.m_frame);
        if (returnVal != 0) {
            return;
        }
        this.m_sourceFileSpec = chooser.getSelectedFile().getAbsolutePath();
        this.m_nextRecordButton.setEnabled(true);
        this.m_dataSourceHandler = new DataSourceHandler(this.m_sourceFileSpec, this.m_province);
        try {
            this.m_dataSourceHandler.init();
        }
        catch (DataSourceException DSEx) {
            DSEx.printStackTrace(System.err);
        }
    }

    private void loadUsedRecords() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Load used records index");
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".idx");
            }

            @Override
            public String getDescription() {
                return "used records index(.idx)";
            }
        });
        int returnVal = chooser.showOpenDialog(this.m_frame);
        if (returnVal != 0) {
            return;
        }
        this.m_usedRecordsIndexSpec = chooser.getSelectedFile().getAbsolutePath();
        this.m_mergeRecorder = new MergeRecorder();
        try {
            this.m_mergeRecorder.open(this.m_usedRecordsIndexSpec);
            this.m_showLeftOversCheckBox.setEnabled(true);
        }
        catch (IOException IOEx) {
            JOptionPane.showMessageDialog(this.m_frame, IOEx.getMessage(), "IOException", 0);
            this.m_mergeRecorder = null;
        }
        catch (IndexAccessException IAEx) {
            JOptionPane.showMessageDialog(this.m_frame, IAEx.getMessage(), "IndexAccessException", 0);
            this.m_mergeRecorder = null;
        }
    }

    private void setCANPostPath() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Locate CAN Post data...");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this.m_frame);
        if (returnVal != 0) {
            return;
        }
        this.m_CANPostPathSpec = chooser.getSelectedFile().getAbsolutePath();
        try {
            this.m_accents = TextAccentsLoader.loadLookup(this.m_CANPostPathSpec);
        }
        catch (DataSourceException DSEx) {
            JOptionPane.showMessageDialog(this.m_frame, DSEx.getMessage(), "Unable to load accents", 0);
        }
    }

    private void setCANPostCombinedPath() {
        if (this.m_accents == null) {
            JOptionPane.showMessageDialog(this.m_frame, "must set CANPost path first", "info", 1);
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Locate CAN Post combined data...");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this.m_frame);
        if (returnVal != 0) {
            return;
        }
        this.m_CANPostCombinedPathSpec = chooser.getSelectedFile().getAbsolutePath();
        this.m_closeSource = new CloseMatchMergeSource(this.m_accents, null, true);
        try {
            this.m_closeSource.open(this.m_CANPostCombinedPathSpec, this.m_province);
        }
        catch (DataSourceException DSEx) {
            JOptionPane.showMessageDialog(this.m_frame, DSEx.getMessage(), "Unable to combined data", 0);
            this.m_closeSource = null;
        }
    }

    private void displayStatus() {
        StatusDialog dialog = new StatusDialog(this.m_frame);
        dialog.display(this.m_province, this.m_sourceFileSpec, this.m_usedRecordsIndexSpec, this.m_CANPostCombinedPathSpec, this.m_CANPostPathSpec);
    }

    private void parse() {
        CAN_ParsedAddress address;
        this.m_parsePanel.clear();
        String street = this.m_sourceRecordPanel.getStreetName();
        if (street != null && (address = MergeUtilities.parse(street)) != null) {
            this.m_parsePanel.update(address);
        }
    }

    private void displayNextSourceRecord() {
        this.clearCANPost();
        boolean bCont = true;
        while (bCont) {
            if (this.m_streetNamesIterator == null || !this.m_streetNamesIterator.hasNext()) {
                try {
                    this.m_record = this.m_dataSourceHandler.getNextRecord();
                    if (this.m_record == null) {
                        JOptionPane.showMessageDialog(this.m_frame, "out of records", "info", 1);
                        this.m_nextRecordButton.setEnabled(false);
                        return;
                    }
                    this.m_streetNamesIterator = this.m_record.getStreetNames().iterator();
                    this.m_segmentsIterator = this.m_record.getSegments().iterator();
                }
                catch (DataSourceException DSEx) {
                    DSEx.printStackTrace();
                }
            }
            if (!this.m_bShowRuralSource && this.m_record.getFSA().charAt(1) == '0') {
                this.m_streetNamesIterator = null;
                continue;
            }
            bCont = false;
            if (!this.m_segmentsIterator.hasNext()) {
                this.m_segmentsIterator = this.m_record.getSegments().iterator();
            }
            this.m_sourceRecordPanel.update(SourceRecordDataIDProvider.getProvider().getCurrentID(), (String)this.m_streetNamesIterator.next(), this.m_record.getFSA(), (ISegmentDataSourceRecord)this.m_segmentsIterator.next());
        }
        if (this.m_bAutoParse) {
            this.parse();
        }
        if (this.m_bAutoSearch) {
            this.searchCANPost(this.m_autoSearchMode);
        }
    }

    private void clearCANPost() {
        this.m_CANPostRecords = null;
        this.m_leftOverCANPostRecords = null;
        this.m_CANPostModel.updataContents(null, null);
    }

    private void searchCANPost(int mode) {
        this.clearCANPost();
        if (this.m_closeSource != null) {
            try {
                this.m_closeSource.setMode(mode, this.m_optionPanel.getModValue());
            }
            catch (UnsupportedCloseMatchModeException UCMMEx) {
                JOptionPane.showMessageDialog(this.m_frame, "unsupported search mode", "error", 0);
                return;
            }
            try {
                Collection records = this.m_closeSource.getMergeData(this.m_province, this.m_sourceRecordPanel.getFSA(), this.m_sourceRecordPanel.getStreetName(), null);
                if (records != null && !records.isEmpty()) {
                    this.m_CANPostRecords = new ArrayList(records);
                    this.m_leftOverCANPostRecords = this.getLeftOvers(records);
                }
                this.m_CANPostModel.updataContents(this.m_CANPostRecords, this.m_leftOverCANPostRecords);
                if (this.m_mergeRecorder != null) {
                    if (this.m_showLeftOversCheckBox.isSelected()) {
                        this.selectLeftOvers();
                    } else {
                        this.selectAllRecords();
                    }
                } else {
                    this.selectAllRecords();
                }
            }
            catch (DataSourceException DSEx) {
                JOptionPane.showMessageDialog(this.m_frame, DSEx.getMessage(), "error", 0);
            }
        }
    }

    private void selectAllRecords() {
        this.m_CANPostPanel.setAllRecords();
        this.m_CANPostModel.selectAllRecords();
    }

    private void selectLeftOvers() {
        this.m_CANPostPanel.setLeftOvers();
        this.m_CANPostModel.selectLeftOvers();
    }

    private ArrayList getLeftOvers(Collection allRecords) {
        if (allRecords == null || allRecords.isEmpty()) {
            return null;
        }
        if (this.m_mergeRecorder == null) {
            return null;
        }
        ArrayList<ICombinedRecord> leftOvers = new ArrayList<ICombinedRecord>();
        Iterator iterator = allRecords.iterator();
        while (iterator.hasNext()) {
            Collection<ICombinedRecord> subSet = this.m_mergeRecorder.getAvailable((ICombinedRecord)iterator.next());
            if (subSet == null || subSet.isEmpty()) continue;
            leftOvers.addAll(subSet);
        }
        if (leftOvers.isEmpty()) {
            return null;
        }
        return leftOvers;
    }

    private void init() {
        this.fillMainPanel();
        this.m_frame = new JFrame("MapMarker Plus CAN analysis tool");
        this.m_frame.setContentPane(this.m_mainPanel);
        this.m_frame.setJMenuBar(this.makeMenu());
        this.m_frame.pack();
        this.m_frame.setResizable(false);
        this.m_frame.setLocationRelativeTo(null);
        this.m_frame.setDefaultCloseOperation(2);
        this.m_frame.setVisible(true);
    }

    private static void displayGUI() {
        MainForm form = new MainForm();
        form.init();
    }

    public static void main(String[] args) {
        MainForm.displayGUI();
    }

    private class AutoSearchListener
    implements ActionListener {
        private MainForm m_form;
        private boolean m_bAutoSearch;
        private int m_autoSearchMode;

        public AutoSearchListener(MainForm form, boolean bAutoSearch, int autoSearchMode) {
            this.m_form = form;
            this.m_bAutoSearch = bAutoSearch;
            this.m_autoSearchMode = autoSearchMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_form.m_bAutoSearch = this.m_bAutoSearch;
            this.m_form.m_autoSearchMode = this.m_autoSearchMode;
        }
    }

    private class SearchListener
    implements ActionListener {
        private int m_mode;

        public SearchListener(int mode) {
            this.m_mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainForm.this.searchCANPost(this.m_mode);
        }
    }

    private static class ProvinceListener
    implements ActionListener {
        private MainForm m_form;
        private String m_province;

        public ProvinceListener(MainForm form, String province) {
            this.m_form = form;
            this.m_province = province;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_form.setCurrentProvince(this.m_province);
        }
    }

    private static class CloseTwoSourceFileFilter
    extends FileFilter {
        private CloseTwoSourceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".uc2");
        }

        @Override
        public String getDescription() {
            return "closematch2 records(.uc2)";
        }
    }

    private static class CloseOneSourceFileFilter
    extends FileFilter {
        private CloseOneSourceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".uc1");
        }

        @Override
        public String getDescription() {
            return "closematch1 records(.uc1)";
        }
    }

    private static class PreCloseSourceFileFilter
    extends FileFilter {
        private PreCloseSourceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".umr");
        }

        @Override
        public String getDescription() {
            return "un-merged records(.umr)";
        }
    }

    private static class SourceFileFilter
    extends FileFilter {
        private SourceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".tab") || f.getName().endsWith(".TAB");
        }

        @Override
        public String getDescription() {
            return "source records(.tab)";
        }
    }
}

