/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OptionPanel
extends JPanel {
    private final String[] m_titles = new String[]{"Add S", "French types", "Remove french ords", "Score no articles", "Parse no articles", "English types", "Add french ords", "Remove english ords", "Post type to pre", "Strip apostrophes", "Swap dirs", "Drop S", "Drop post type", "Expand english numbers", "Expand french numbers", "Drop dirs"};
    private final int[] m_modValues = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
    private final JCheckBox[] m_boxes = new JCheckBox[this.m_titles.length];
    private final int MAX_COLUMNS = 4;

    public void init(JCheckBox leftOversCheckBox) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 35, 5, 35), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Options"), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        JPanel hiddenPanel = this.makeHiddenPanel();
        layout.setConstraints(hiddenPanel, constraints);
        this.add(hiddenPanel);
        JButton clearButton = new JButton("Clear All");
        this.addBorder(clearButton);
        constraints.gridy = 4;
        constraints.gridx = 2;
        layout.setConstraints(clearButton, constraints);
        this.add(clearButton);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionPanel.this.clearAll();
            }
        });
        constraints.gridy = 4;
        constraints.gridx = 1;
        layout.setConstraints(leftOversCheckBox, constraints);
        this.add(leftOversCheckBox);
    }

    private void addBorder(JComponent component) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), component.getBorder()));
    }

    private JPanel makeHiddenPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        for (int i = 0; i < this.m_boxes.length; ++i) {
            this.m_boxes[i] = new JCheckBox(this.m_titles[i]);
            this.addBorder(this.m_boxes[i]);
            this.setLocation(constraints, i);
            layout.setConstraints(this.m_boxes[i], constraints);
            panel.add(this.m_boxes[i]);
        }
        return panel;
    }

    private void setLocation(GridBagConstraints constraints, int i) {
        constraints.gridx = i % 4;
        constraints.gridy = i / 4;
    }

    private void clearAll() {
        for (int i = 0; i < this.m_boxes.length; ++i) {
            this.m_boxes[i].setSelected(false);
        }
    }

    public int getModValue() {
        int mod = 0;
        for (int i = 0; i < this.m_boxes.length; ++i) {
            if (!this.m_boxes[i].isSelected()) continue;
            mod |= this.m_modValues[i];
        }
        return mod;
    }
}

