/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SourceRecordPanel
extends JPanel {
    private static final int ID_COLUMNS = 15;
    private static final int STREET_COLUMNS = 30;
    private static final int FSA_COLUMNS = 3;
    private static final int CITY_COLUMNS = 30;
    private static final int HOUSE_COLUMNS = 10;
    private JTextField m_IDField;
    private JTextField m_streetField;
    private JTextField m_FSAField;
    private JTextField m_leftCityField;
    private JTextField m_rightCityField;
    private JTextField m_leftCSDNameField;
    private JTextField m_rightCSDNameField;
    private JTextField m_fromLeftField;
    private JTextField m_toLeftField;
    private JTextField m_fromRightField;
    private JTextField m_toRightField;

    public void init(JButton nextButton) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 35, 5, 35), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Source data record"), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridheight = 2;
        constraints.anchor = 10;
        constraints.fill = 0;
        layout.setConstraints(nextButton, constraints);
        this.add(nextButton);
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JLabel IDLabel = new JLabel();
        IDLabel.setText("ID:");
        layout.setConstraints(IDLabel, constraints);
        this.add(IDLabel);
        this.m_IDField = new JTextField();
        this.m_IDField.setColumns(15);
        ++constraints.gridx;
        layout.setConstraints(this.m_IDField, constraints);
        this.add(this.m_IDField);
        JLabel streetLabel = new JLabel();
        streetLabel.setText("Street:");
        constraints.gridx = 0;
        ++constraints.gridy;
        layout.setConstraints(streetLabel, constraints);
        this.add(streetLabel);
        this.m_streetField = new JTextField();
        this.m_streetField.setColumns(30);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        layout.setConstraints(this.m_streetField, constraints);
        this.add(this.m_streetField);
        JLabel FSALabel = new JLabel();
        FSALabel.setText("FSA:");
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        layout.setConstraints(FSALabel, constraints);
        this.add(FSALabel);
        this.m_FSAField = new JTextField();
        this.m_FSAField.setColumns(3);
        ++constraints.gridx;
        layout.setConstraints(this.m_FSAField, constraints);
        this.add(this.m_FSAField);
        JLabel leftCityLabel = new JLabel();
        leftCityLabel.setText("left city:");
        constraints.gridx = 0;
        ++constraints.gridy;
        layout.setConstraints(leftCityLabel, constraints);
        this.add(leftCityLabel);
        this.m_leftCityField = new JTextField();
        this.m_leftCityField.setColumns(30);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        layout.setConstraints(this.m_leftCityField, constraints);
        this.add(this.m_leftCityField);
        JLabel rightCityLabel = new JLabel();
        rightCityLabel.setText("right city:");
        constraints.gridx += 2;
        constraints.gridwidth = 1;
        layout.setConstraints(rightCityLabel, constraints);
        this.add(rightCityLabel);
        this.m_rightCityField = new JTextField();
        this.m_rightCityField.setColumns(30);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        layout.setConstraints(this.m_rightCityField, constraints);
        this.add(this.m_rightCityField);
        JLabel leftCSDNameLabel = new JLabel();
        leftCSDNameLabel.setText("left CSD: ");
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        layout.setConstraints(leftCSDNameLabel, constraints);
        this.add(leftCSDNameLabel);
        this.m_leftCSDNameField = new JTextField();
        this.m_leftCSDNameField.setColumns(30);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        layout.setConstraints(this.m_leftCSDNameField, constraints);
        this.add(this.m_leftCSDNameField);
        JLabel rightCSDNameLabel = new JLabel();
        rightCSDNameLabel.setText("right CSD: ");
        constraints.gridx += 2;
        constraints.gridwidth = 1;
        layout.setConstraints(rightCSDNameLabel, constraints);
        this.add(rightCSDNameLabel);
        this.m_rightCSDNameField = new JTextField();
        this.m_rightCSDNameField.setColumns(30);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        layout.setConstraints(this.m_rightCSDNameField, constraints);
        this.add(this.m_rightCSDNameField);
        JLabel fromLeftLabel = new JLabel();
        fromLeftLabel.setText("from left:");
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        layout.setConstraints(fromLeftLabel, constraints);
        this.add(fromLeftLabel);
        this.m_fromLeftField = new JTextField();
        this.m_fromLeftField.setColumns(10);
        ++constraints.gridx;
        layout.setConstraints(this.m_fromLeftField, constraints);
        this.add(this.m_fromLeftField);
        JLabel toLeftLabel = new JLabel();
        toLeftLabel.setText("to left:");
        constraints.gridx += 2;
        layout.setConstraints(toLeftLabel, constraints);
        this.add(toLeftLabel);
        this.m_toLeftField = new JTextField();
        this.m_toLeftField.setColumns(10);
        ++constraints.gridx;
        layout.setConstraints(this.m_toLeftField, constraints);
        this.add(this.m_toLeftField);
        JLabel fromRightLabel = new JLabel();
        fromRightLabel.setText("from right:");
        constraints.gridx = 0;
        ++constraints.gridy;
        layout.setConstraints(fromRightLabel, constraints);
        this.add(fromRightLabel);
        this.m_fromRightField = new JTextField();
        this.m_fromRightField.setColumns(10);
        ++constraints.gridx;
        layout.setConstraints(this.m_fromRightField, constraints);
        this.add(this.m_fromRightField);
        JLabel toRightLabel = new JLabel();
        toRightLabel.setText("to right:");
        constraints.gridx += 2;
        layout.setConstraints(toRightLabel, constraints);
        this.add(toRightLabel);
        this.m_toRightField = new JTextField();
        this.m_toRightField.setColumns(10);
        ++constraints.gridx;
        layout.setConstraints(this.m_toRightField, constraints);
        this.add(this.m_toRightField);
    }

    public void update(String ID, String streetName, String FSA, ISegmentDataSourceRecord segment) {
        this.m_IDField.setText(ID);
        this.m_FSAField.setText(FSA);
        this.m_streetField.setText(streetName);
        this.m_fromLeftField.setText(null);
        this.m_toLeftField.setText(null);
        this.m_fromRightField.setText(null);
        this.m_toRightField.setText(null);
        try {
            if (segment.hasLeftAreaName3()) {
                this.m_leftCityField.setText(segment.getLeftAreaName3());
            } else {
                this.m_leftCityField.setText(null);
            }
            if (segment.hasRightAreaName3()) {
                this.m_rightCityField.setText(segment.getRightAreaName3());
            } else {
                this.m_rightCityField.setText(null);
            }
            if (segment.hasLeftAreaName2()) {
                this.m_leftCSDNameField.setText(segment.getLeftAreaName2());
            } else {
                this.m_leftCSDNameField.setText(null);
            }
            if (segment.hasRightAreaName2()) {
                this.m_rightCSDNameField.setText(segment.getRightAreaName2());
            } else {
                this.m_rightCSDNameField.setText(null);
            }
            ArrayList ranges = segment.getRanges();
            if (ranges != null) {
                if (ranges.size() > 2) {
                    System.err.println("Too many ranges");
                } else {
                    for (int i = 0; i < ranges.size(); ++i) {
                        IRangeDataSourceRecord range = (IRangeDataSourceRecord)ranges.get(i);
                        if (range.isLeft()) {
                            if (range.hasFrom()) {
                                this.m_fromLeftField.setText(range.getFrom());
                            }
                            if (!range.hasTo()) continue;
                            this.m_toLeftField.setText(range.getTo());
                            continue;
                        }
                        if (range.hasFrom()) {
                            this.m_fromRightField.setText(range.getFrom());
                        }
                        if (!range.hasTo()) continue;
                        this.m_toRightField.setText(range.getTo());
                    }
                }
            }
        }
        catch (DataSourceException DSEx) {
            this.m_leftCityField.setText(null);
            this.m_rightCityField.setText(null);
        }
    }

    public String getStreetName() {
        String street = this.m_streetField.getText();
        return street != null && street.length() > 0 ? street : null;
    }

    public String getFSA() {
        String FSA = this.m_FSAField.getText();
        return FSA != null && FSA.length() > 0 ? FSA : null;
    }
}

