/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.licensing;

import com.mapinfo.mapmarker.CAN.CAN_InternalBrowseAddress;
import com.mapinfo.mapmarker.CAN.CAN_InternalCandidateAddress;
import com.mapinfo.mapmarker.CAN.CAN_InternalGeographicCandidate;
import com.mapinfo.mapmarker.CAN.CAN_InternalPostalCandidate;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataDictionary;
import com.mapinfo.mapmarker.CAN.licensing.MMCANLicenseException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalPBKeyCandidate;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.licensing.MMLicensing;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.MMCustomConfiguration;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseDefinition;
import com.mapinfo.scp.spi.LicenseRequest;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CANLicenseFilter
extends LicenseFilter {
    private static final String FACTORY_CONFIG_FILE = "MMCANLicenseFactory.config";
    private static final String PROVIDER_CONFIG_FILE = "MMCANLicenseProvider.config";
    private static final String BASIC_FEATURE = "mapmarker.data.can.basic";
    private static final String VERSION = "1.0";
    private static final String FEATURE_PREFIX = "mapmarker.data.can.";
    private static final String STREET_SUFFIX = ".street";
    private static final String POSTAL_SUFFIX = ".postal";
    private static final String GEOGRAPHIC_SUFFIX = ".geographic";
    private static final String AP_STREET_SUFFIX = ".ap.street";
    private static final String NAVTEQ_STREET_SUFFIX = ".navteq.street";
    private static final String NAVTEQ_POINTS_SUFFIX = ".navteqpoints.street";
    private static final String TOM_TOM_POINTS_SUFFIX = ".tomtompoints.street";
    private static final String MLD_POINTS_SUFFIX = ".mldpoints.street";
    private MMLicensing m_licenser;
    private Map<String, LicenseRequest> m_streetRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_apStreetRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_navTeqRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_navTeqPointsRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> m_TomTomPointsRequestMap = new HashMap<String, LicenseRequest>();
    private Map<String, LicenseRequest> mldPointsRequestMap = new HashMap<String, LicenseRequest>();
    private Map m_postalRequestMap = new HashMap();
    private Map m_geographicRequestMap = new HashMap();
    private LicenseRequest m_basicRequest;
    private static final String STREET_LIC_HEADER = "CAN street: ";
    private static final String POSTAL_LIC_HEADER = "CAN postal: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CANLicenseFilter() throws MMLicenseException {
        URL providerURL;
        URL factoryURL;
        if (MMCustomConfiguration.getUseCustomProperties()) {
            factoryURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + FACTORY_CONFIG_FILE));
            providerURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + PROVIDER_CONFIG_FILE));
        } else {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            factoryURL = cl.getResource(FACTORY_CONFIG_FILE);
            providerURL = cl.getResource(PROVIDER_CONFIG_FILE);
        }
        this.m_licenser = factoryURL == null || providerURL == null ? new MMLicensing() : new MMLicensing(factoryURL.toExternalForm(), providerURL.toExternalForm());
        this.m_basicRequest = this.m_licenser.createLicenseRequest(BASIC_FEATURE, VERSION);
        License basicLicense = null;
        try {
            basicLicense = this.m_licenser.checkout(this.m_basicRequest);
            if (basicLicense == null) {
                throw new MMCANLicenseException(5200);
            }
        }
        finally {
            if (basicLicense != null) {
                this.m_licenser.checkin(basicLicense);
            }
        }
    }

    protected LicenseRequest buildRequest(ICandidate candidate, int mode) throws MMCANLicenseException {
        switch (mode) {
            case 0: {
                String province = null;
                CAN_DataDictionary.DICTIONARY_TYPE type = null;
                if (candidate instanceof CAN_InternalCandidateAddress) {
                    province = ((CAN_InternalCandidateAddress)candidate).getAreaName1();
                    type = ((CAN_InternalCandidateAddress)candidate).getDictionaryType();
                } else if (candidate instanceof InternalPBKeyCandidate) {
                    CAN_InternalCandidateAddress t = (CAN_InternalCandidateAddress)((InternalPBKeyCandidate)candidate).getAddress();
                    province = t.getAreaName1();
                    type = t.getDictionaryType();
                }
                LicenseRequest request = province == null || province.length() == 0 ? this.m_basicRequest : this.getStreetRequest(province, type);
                return request;
            }
            case 1: {
                String province = this.determineLicenseProvince((CAN_InternalBrowseAddress)candidate);
                LicenseRequest request = province == null || province.length() == 0 ? this.m_basicRequest : this.getStreetRequest(province, ((CAN_InternalBrowseAddress)candidate).getDictionaryType());
                return request;
            }
            case 2: {
                String state = ((CAN_InternalPostalCandidate)candidate).getAreaName1();
                LicenseRequest request = state == null || state.length() == 0 ? this.m_basicRequest : this.getPostalRequest(state);
                return request;
            }
            case 3: {
                String state = ((CAN_InternalGeographicCandidate)candidate).getAreaName1();
                LicenseRequest request = state == null || state.length() == 0 ? this.m_basicRequest : this.getGeographicRequest(state);
                return request;
            }
        }
        throw new MMCANLicenseException(5201);
    }

    protected MMLicensing getLicenser() {
        return this.m_licenser;
    }

    public String[] getLicenseInformation() {
        StringBuffer streetLic = new StringBuffer(STREET_LIC_HEADER);
        StringBuffer postalLic = new StringBuffer(POSTAL_LIC_HEADER);
        LicenseDefinition[] defs = this.m_licenser.getAvailableLicenseDefinitions();
        if (defs.length > 0) {
            Arrays.sort(defs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    LicenseDefinition def1 = (LicenseDefinition)o1;
                    LicenseDefinition def2 = (LicenseDefinition)o2;
                    int result = def1.getLicenseFeature().getName().compareTo(def2.getLicenseFeature().getName());
                    if (result == 0) {
                        result = def1.getLicenseFeature().getVersion().compareTo(def2.getLicenseFeature().getVersion());
                    }
                    return result;
                }
            });
        }
        LicenseDefinition lastDef = null;
        for (int i = 0; i < defs.length; ++i) {
            LicenseDefinition def = defs[i];
            if (lastDef != null && lastDef.getLicenseFeature().getName().equals(def.getLicenseFeature().getName())) continue;
            String featureName = def.getLicenseFeature().getName();
            if (featureName.startsWith(FEATURE_PREFIX)) {
                if (featureName.endsWith(STREET_SUFFIX)) {
                    streetLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length() - STREET_SUFFIX.length()));
                    streetLic.append(", ");
                } else if (featureName.endsWith(POSTAL_SUFFIX)) {
                    postalLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length() - POSTAL_SUFFIX.length()));
                    postalLic.append(", ");
                }
            }
            lastDef = def;
        }
        streetLic.setLength(streetLic.length() - 2);
        postalLic.setLength(postalLic.length() - 2);
        return new String[]{streetLic.toString(), postalLic.toString()};
    }

    private Map<String, LicenseRequest> getStreetRequestMap(CAN_DataDictionary.DICTIONARY_TYPE dictionaryType) {
        switch (dictionaryType) {
            case STANDARD: {
                return this.m_streetRequestMap;
            }
            case USER_DICTIONARY: {
                return this.m_streetRequestMap;
            }
            case PARCEL: {
                return this.m_apStreetRequestMap;
            }
            case NAVTEQ: {
                return this.m_navTeqRequestMap;
            }
            case NAVTEQ_POINTS: {
                return this.m_navTeqPointsRequestMap;
            }
            case TOMTOM_POINTS: {
                return this.m_TomTomPointsRequestMap;
            }
            case MLD_POINTS: {
                return this.mldPointsRequestMap;
            }
        }
        throw new IllegalArgumentException("Unknown dictionary type: " + (Object)((Object)dictionaryType));
    }

    private String getDictionarySuffix(CAN_DataDictionary.DICTIONARY_TYPE dictionaryType) {
        switch (dictionaryType) {
            case STANDARD: {
                return STREET_SUFFIX;
            }
            case USER_DICTIONARY: {
                return STREET_SUFFIX;
            }
            case PARCEL: {
                return AP_STREET_SUFFIX;
            }
            case NAVTEQ: {
                return NAVTEQ_STREET_SUFFIX;
            }
            case NAVTEQ_POINTS: {
                return NAVTEQ_POINTS_SUFFIX;
            }
            case TOMTOM_POINTS: {
                return TOM_TOM_POINTS_SUFFIX;
            }
            case MLD_POINTS: {
                return MLD_POINTS_SUFFIX;
            }
        }
        throw new IllegalArgumentException("Unknown dictionary type: " + (Object)((Object)dictionaryType));
    }

    private LicenseRequest getStreetRequest(String province, CAN_DataDictionary.DICTIONARY_TYPE dictionaryType) {
        Map<String, LicenseRequest> requestMap = this.getStreetRequestMap(dictionaryType);
        LicenseRequest request = requestMap.get(province);
        if (request != null) {
            return request;
        }
        StringBuilder sb = new StringBuilder(FEATURE_PREFIX);
        sb.append(province.toLowerCase());
        sb.append(this.getDictionarySuffix(dictionaryType));
        request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
        requestMap.put(province, request);
        return request;
    }

    private LicenseRequest getPostalRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_postalRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(POSTAL_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_postalRequestMap.put(state, request);
        }
        return request;
    }

    private LicenseRequest getGeographicRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_geographicRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(GEOGRAPHIC_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_geographicRequestMap.put(state, request);
        }
        return request;
    }

    private String determineLicenseProvince(CAN_InternalBrowseAddress browseAddress) {
        String result = null;
        for (int i = 0; i < browseAddress.getSegmentCount(); ++i) {
            String segmentProvince;
            Segment segment = browseAddress.getSegmentAt(i);
            String leftProvince = segment.getLeftAreaName1();
            String rightProvince = segment.getRightAreaName1();
            if (leftProvince != null && (rightProvince == null || leftProvince.equals(rightProvince))) {
                segmentProvince = leftProvince;
            } else if (rightProvince != null && (leftProvince == null || rightProvince.equals(leftProvince))) {
                segmentProvince = rightProvince;
            } else {
                result = null;
                break;
            }
            if (result == null) {
                result = segmentProvince;
                continue;
            }
            if (result.equals(segmentProvince)) continue;
            result = null;
            break;
        }
        return result;
    }
}

