/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.parser;

import com.mapinfo.mapmarker.CAN.parser.CAN_ThoroughfareType;
import com.mapinfo.mapmarker.CAN.parser.CAN_ThoroughfareTypesLoader;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.io.IOException;
import java.util.Map;

public class CAN_NewThoroughfareTypes {
    public static final int SPECIAL_CASE_RR = 1;
    public static final int SPECIAL_CASE_HC = 2;
    public static final int SPECIAL_CASE_POBOX = 3;
    public static final int SPECIAL_CASE_GD = 4;
    public static final int SPECIAL_CASE_HWY = 5;
    public static final int SPECIAL_CASE_CR = 6;
    public static final int SPECIAL_CASE_SS = 7;
    public static final int SPECIAL_CASE_MR = 8;
    public static final int SPECIAL_CASE_TCHWY = 9;
    public static final int SPECIAL_NOT_SPECIAL = -1;
    private static final Map m_preferredToKeyInfoMap;
    private static final Map m_namesToPreferredMap;

    protected CAN_ThoroughfareType findStreetType(StringWithTokens tokens, boolean bSearchFromStart) {
        CAN_ThoroughfareType result = null;
        String testStr = tokens.toString();
        testStr = StringUtilities.stripString((String)testStr, (String)"'");
        StringWithTokens testTokens = new StringWithTokens(testStr, " ,");
        int start = 0;
        while (testTokens.size() != 0) {
            if (!bSearchFromStart && "#".equals(testTokens.getFirstToken()) && testTokens.size() > 1) {
                start += 2;
                testTokens.removeFirst();
                testTokens.removeFirst();
                continue;
            }
            String key = testTokens.toString();
            KeyInfo keyInfo = CAN_NewThoroughfareTypes.lookupByTypeName(key);
            if (keyInfo != null && (bSearchFromStart && keyInfo.canStart() || !bSearchFromStart && keyInfo.canEnd())) {
                result = new CAN_ThoroughfareType(key, testTokens.size(), keyInfo);
                result.setTokenIndex(start);
                if (bSearchFromStart) {
                    result.setTypeFound(1);
                    break;
                }
                result.setTypeFound(2);
                break;
            }
            if (bSearchFromStart) {
                testTokens.removeLast();
                continue;
            }
            ++start;
            testTokens.removeFirst();
        }
        return result;
    }

    public static KeyInfo lookupByTypeName(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        String preferredName = (String)m_namesToPreferredMap.get(key);
        if (preferredName == null && key.charAt(key.length() - 1) == '.') {
            preferredName = (String)m_namesToPreferredMap.get(key.substring(0, key.length() - 1));
        }
        return (KeyInfo)m_preferredToKeyInfoMap.get(preferredName);
    }

    public static KeyInfo lookupByPreferredName(String key) {
        return (KeyInfo)m_preferredToKeyInfoMap.get(key);
    }

    public static int endsWithType(String addrString) {
        if (addrString.length() == 0) {
            return -1;
        }
        if (Character.isDigit(addrString.charAt(addrString.length() - 1))) {
            return -1;
        }
        for (int index = 1; index < addrString.length() - 1; ++index) {
            if (CAN_NewThoroughfareTypes.lookupByTypeName(addrString.substring(index)) == null) continue;
            return index;
        }
        return -1;
    }

    public static String getSpecialQCTypeProperName(String typeProperName) {
        if (typeProperName == null) {
            return null;
        }
        if (typeProperName.equalsIgnoreCase("AVE")) {
            return "AV";
        }
        if (typeProperName.equalsIgnoreCase("BLVD")) {
            return "BOUL";
        }
        if (typeProperName.equalsIgnoreCase("CTR")) {
            return "C";
        }
        if (typeProperName.equalsIgnoreCase("PL")) {
            return "PLACE";
        }
        return null;
    }

    public static String getPreTypeForOutput(String preType) {
        if ("AVE".equals(preType)) {
            return "AV";
        }
        return preType;
    }

    public static boolean isStreetType(String key) {
        return m_namesToPreferredMap.containsKey(key);
    }

    static {
        try {
            m_preferredToKeyInfoMap = CAN_ThoroughfareTypesLoader.loadPreferredToKeyInfoMap();
            m_namesToPreferredMap = CAN_ThoroughfareTypesLoader.loadNamesToPreferredMap();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load required files for CAN_Parser.", e);
        }
    }

    public static class KeyInfo {
        private final String m_preferredName;
        private final String m_properName;
        private final String m_expandedName;
        private final boolean m_canStart;
        private final boolean m_canEnd;
        private final int m_specialCase;

        public KeyInfo(String preferredType, String properName, String expandedName, boolean canStart, boolean canEnd, int specialCase) {
            this.m_preferredName = preferredType;
            this.m_properName = properName;
            this.m_expandedName = expandedName;
            this.m_canStart = canStart;
            this.m_canEnd = canEnd;
            this.m_specialCase = specialCase;
        }

        public String getPreferredTypeName() {
            return this.m_preferredName;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public String getExpandedTypeName() {
            return this.m_expandedName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }

        protected int getSpecialCase() {
            return this.m_specialCase;
        }
    }
}

