/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.parser;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CAN_ParsePostAddressRule
implements IParseRule {
    public static final String TAG_CITY = "CITY";
    public static final String TAG_PROVINCE = "PROVINCE";
    public static final String TAG_POSTCODE = "POSTCODE";
    private static final String FSA_REGEX_STRING = "(([A-Z])|(0))((\\d)|(O))(([A-Z])|(0))";
    private static final Pattern FSA_MATCH_REGEX;
    private static final Pattern FSA_FIXER_REGEX;
    private static final String LDU_REGEX_STRING = "((\\d)|(O))(([A-Z])|(0))((\\d)|(O))";
    private static final Pattern LDU_MATCH_REGEX;
    private static final Pattern LDU_FIXER_REGEX;
    private static final String FSALDU_SEPARATORS_REGEX_STRING = " |-|/";
    private static final String FSALDU_REGEX_STRING = "(([A-Z])|(0))((\\d)|(O))(([A-Z])|(0))( |-|/)?((\\d)|(O))(([A-Z])|(0))((\\d)|(O))";
    private static final Pattern FSALDU_MATCH_REGEX;
    private static final Set m_provAbbrs;
    private static final Set m_provEndings;
    private static final Map m_provNames;
    private static Set badLeadingLLcharSet;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        this.RemoveBadCharsLastLine(pa);
        this.RemoveBadCharsLastLine(ura);
        String postAddress = ura.getPostAddress();
        TaggedTokenList tokens = null;
        if (postAddress != null) {
            pa.setPostAddress(null);
            postAddress = AddressUtils.stripEndQuotes(postAddress);
            StringTokenizer st = new StringTokenizer(postAddress.toUpperCase(), " ,()");
            tokens = new TaggedTokenList(st);
        } else {
            tokens = new TaggedTokenList();
        }
        this.tagPostCode(pa, tokens);
        this.tagProvince(pa, tokens);
        this.tagCity(pa, tokens);
        this.setPostCode(ura, pa, tokens);
        this.setProvince(ura, pa, tokens);
        this.setCity(ura, pa, tokens);
        if (this.isQCAddress((CAN_ParsedAddress)pa)) {
            ((CAN_ParsedAddress)pa).setQC(true);
        }
        this.checkRuralFSA((CAN_ParsedAddress)pa);
    }

    protected void tagPostCode(Address pa, TaggedTokenList tokens) {
        String currentValue;
        TaggedToken currentToken;
        int idx;
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        for (idx = tokens.size() - 1; idx >= 0; --idx) {
            TaggedToken prevToken;
            currentToken = tokens.get(idx);
            if (currentToken.isTagged()) continue;
            currentValue = currentToken.getValue();
            TaggedToken taggedToken = prevToken = idx > 0 ? tokens.get(idx - 1) : null;
            if (prevToken != null && prevToken.isTagged()) {
                prevToken = null;
            }
            if (prevToken != null && CAN_ParsePostAddressRule.isValidLDU(currentValue)) {
                if (!CAN_ParsePostAddressRule.isValidFSA(prevToken.getValue())) continue;
                currentToken.setTag(TAG_POSTCODE);
                prevToken.setTag(TAG_POSTCODE);
                return;
            }
            if (CAN_ParsePostAddressRule.isValidFSA(currentValue)) {
                currentToken.setTag(TAG_POSTCODE);
                return;
            }
            if (!CAN_ParsePostAddressRule.isValidFSALDU(currentValue)) continue;
            currentToken.setTag(TAG_POSTCODE);
            return;
        }
        for (idx = tokens.size() - 1; idx >= 0; --idx) {
            currentToken = tokens.get(idx);
            if (currentToken.isTagged() || '0' != (currentValue = currentToken.getValue()).charAt(0) || !this.tagLeadingZeroFSA((CAN_ParsedAddress)pa, tokens)) continue;
            currentToken.setTag(TAG_POSTCODE);
            return;
        }
    }

    protected void setPostCode(Address ura, Address pa, TaggedTokenList tokens) {
        String FSA = "";
        String LDU = "";
        String tmp = pa.getPostCode1();
        if (!StringUtilities.isEmpty((String)tmp)) {
            int FSALength = tmp.length();
            tmp = tmp.trim().toUpperCase();
            while (FSALength > 0 && '0' == tmp.charAt(0)) {
                tmp = tmp.substring(1);
                --FSALength;
            }
            if (CAN_ParsePostAddressRule.isValidFSALDU(tmp)) {
                FSA = tmp.substring(0, 3);
                LDU = tmp.substring(tmp.length() - 3);
            } else {
                FSA = tmp;
                LDU = pa.getPostCode2();
                LDU = LDU == null ? "" : LDU.trim().toUpperCase();
            }
        } else {
            tmp = tokens.getTaggedTokenString(TAG_POSTCODE).trim().toUpperCase();
            if (!StringUtilities.isEmpty((String)tmp)) {
                while ('0' == tmp.charAt(0)) {
                    tmp = tmp.substring(1);
                }
                FSA = tmp.length() > 3 ? tmp.substring(0, 3) : tmp;
                LDU = tmp.length() > 3 ? tmp.substring(tmp.length() - 3) : "";
            }
        }
        this.assignFSALDU((CAN_ParsedAddress)pa, FSA, LDU);
    }

    protected boolean tagLeadingZeroFSA(CAN_ParsedAddress pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return false;
        }
        int startPosition = tokens.indexOfFirstUntaggedToken();
        if (startPosition >= 0 && startPosition < tokens.size()) {
            for (int i = startPosition; i < tokens.size(); ++i) {
                int length;
                TaggedToken t = tokens.get(i);
                if (t.isTagged()) continue;
                String tmp = t.getValue();
                if ('0' != tmp.charAt(0)) continue;
                StringBuilder sb = new StringBuilder(tmp);
                for (length = tmp.length(); length > 0 && sb.charAt(0) == '0'; --length) {
                    sb.deleteCharAt(0);
                }
                if (length < 3 || !CAN_ParsePostAddressRule.isValidFSA(sb.toString()) && !CAN_ParsePostAddressRule.isValidFSALDU(sb.toString())) continue;
                tokens.setTag(i, TAG_POSTCODE);
                return true;
            }
        }
        return false;
    }

    protected boolean assignFSALDU(CAN_ParsedAddress pa, String FSALDU) {
        String FSA = FSALDU.length() > 3 ? FSALDU.substring(0, 3) : FSALDU;
        String LDU = FSALDU.length() > 3 ? FSALDU.substring(FSALDU.length() - 3) : "";
        return this.assignFSALDU(pa, FSA, LDU);
    }

    protected boolean assignFSALDU(CAN_ParsedAddress pa, String FSA, String LDU) {
        boolean bChanged = false;
        String fixedFSA = CAN_ParsePostAddressRule.fixFSA(FSA);
        pa.setPostCode1(fixedFSA);
        if (!FSA.equalsIgnoreCase(fixedFSA)) {
            pa.setFixedPostCode1(true);
            bChanged = true;
        }
        String fixedLDU = CAN_ParsePostAddressRule.fixLDU(LDU);
        pa.setPostCode2(fixedLDU);
        if (!LDU.equalsIgnoreCase(fixedLDU)) {
            pa.setFixedPostCode2(true);
            bChanged = true;
        }
        return bChanged;
    }

    protected void tagProvince(Address pa, TaggedTokenList tokens) {
        for (int idx = tokens.size() - 1; idx >= 0; --idx) {
            TaggedToken currentToken = tokens.get(idx);
            if (currentToken.isTagged()) continue;
            String testState = currentToken.getValue();
            if (testState.length() == 2 && m_provAbbrs.contains(testState)) {
                currentToken.setTag(TAG_PROVINCE);
                return;
            }
            tokens.setTag(idx, TAG_PROVINCE);
            int tokensConsidered = 1;
            if (idx > 0 && m_provEndings.contains(testState)) {
                int tmpIdx;
                for (int i = 1; i <= 3 && (tmpIdx = idx - i) >= 0 && !tokens.isTagged(tmpIdx); ++i) {
                    tokens.setTag(tmpIdx, TAG_PROVINCE);
                    ++tokensConsidered;
                }
            }
            while (tokensConsidered > 0) {
                String provName = tokens.getTaggedTokenString(TAG_PROVINCE);
                if (!StringUtilities.isEmpty((String)provName) && m_provNames.get(provName) != null) {
                    return;
                }
                tokens.setTag(idx - --tokensConsidered, null);
            }
        }
    }

    protected void setProvince(Address ura, Address pa, TaggedTokenList tokens) {
        String province = pa.getAreaName1();
        if (!StringUtilities.isEmpty((String)province)) {
            if (!StringUtilities.isEmpty((String)(province = this.getProvinceAbbreviation(province)))) {
                pa.setAreaName1(province);
            }
            return;
        }
        province = tokens.getTaggedTokenString(TAG_PROVINCE);
        if (!StringUtilities.isEmpty((String)province)) {
            province = this.getProvinceAbbreviation(province);
        }
        if (!StringUtilities.isEmpty((String)province)) {
            pa.setAreaName1(province);
        }
    }

    protected void tagCity(Address pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        int startPosition = tokens.indexOfFirstUntaggedToken();
        if (startPosition >= 0 && startPosition < tokens.size()) {
            TaggedToken t;
            for (int i = startPosition; i < tokens.size() && !(t = tokens.get(i)).isTagged(); ++i) {
                t.setTag(TAG_CITY);
            }
        }
    }

    protected void setCity(Address ura, Address pa, TaggedTokenList tokens) {
        String city = ura.getAreaName3();
        if (!StringUtilities.isEmpty((String)city)) {
            city = city.trim().toUpperCase();
        }
        if (!StringUtilities.isEmpty((String)city)) {
            pa.setAreaName3(city);
            return;
        }
        city = tokens.getTaggedTokenString(TAG_CITY);
        if (!StringUtilities.isEmpty((String)city)) {
            pa.setAreaName3(city);
        }
    }

    static boolean isValidFSALDU(String text) {
        return text != null && FSALDU_MATCH_REGEX.matcher(text.trim().toUpperCase()).matches();
    }

    static boolean isValidFSA(String text) {
        return text != null && FSA_MATCH_REGEX.matcher(text.trim().toUpperCase()).matches();
    }

    static boolean isValidLDU(String text) {
        return text != null && LDU_MATCH_REGEX.matcher(text.trim().toUpperCase()).matches();
    }

    static String fixFSA(String text) {
        Matcher m = FSA_FIXER_REGEX.matcher(text.trim().toUpperCase());
        if (m.find()) {
            StringBuffer fixed = new StringBuffer();
            String tmp = m.group(2);
            fixed.append(tmp != null ? tmp : "O");
            tmp = m.group(5);
            fixed.append(tmp != null ? tmp : "0");
            tmp = m.group(7);
            fixed.append(tmp != null ? tmp : "O");
            return fixed.toString();
        }
        return text;
    }

    static String fixLDU(String text) {
        Matcher m = LDU_FIXER_REGEX.matcher(text.trim().toUpperCase());
        if (m.find()) {
            StringBuffer fixed = new StringBuffer();
            String tmp = m.group(2);
            fixed.append(tmp != null ? tmp : "0");
            tmp = m.group(5);
            fixed.append(tmp != null ? tmp : "O");
            tmp = m.group(7);
            fixed.append(tmp != null ? tmp : "0");
            return fixed.toString();
        }
        return text;
    }

    protected String getProvinceAbbreviation(String testProvince) {
        if (testProvince != null) {
            if ((testProvince = testProvince.trim().toUpperCase()).length() == 2 && m_provAbbrs.contains(testProvince)) {
                return testProvince;
            }
            String abbr = (String)m_provNames.get(testProvince);
            if (abbr != null) {
                return abbr;
            }
        }
        return "";
    }

    private void RemoveBadCharsLastLine(Address pa) {
        String[] LastLineParts = new String[5];
        StringBuffer[] newAddrs = new StringBuffer[5];
        String LL = pa.getPostAddress();
        if (!StringUtilities.isEmpty((String)LL) && badLeadingLLcharSet.contains(Character.valueOf(LL.trim().charAt(0)))) {
            pa.setPostAddress(LL.substring(1));
        }
        LastLineParts[0] = pa.getPostAddress();
        int start = 0;
        int end = 1;
        if (LastLineParts[0] == null) {
            start = 1;
            end = 5;
            LastLineParts[1] = pa.getAreaName1();
            LastLineParts[2] = pa.getAreaName3();
            LastLineParts[3] = pa.getPostCode1();
            LastLineParts[4] = pa.getPostCode2();
        }
        for (int i = start; i < end; ++i) {
            if (LastLineParts[i] == null) continue;
            block4: for (int j = 0; j < LastLineParts[i].length(); ++j) {
                char thischar = LastLineParts[i].charAt(j);
                int ttype = Character.getType(thischar);
                switch (ttype) {
                    case 0: 
                    case 12: 
                    case 15: 
                    case 26: {
                        if (newAddrs[i] != null) {
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        newAddrs[i] = new StringBuffer();
                        newAddrs[i].append(' ');
                        continue block4;
                    }
                    default: {
                        if (newAddrs[i] == null) {
                            newAddrs[i] = new StringBuffer("");
                            newAddrs[i].append(thischar);
                            continue block4;
                        }
                        newAddrs[i].append(thischar);
                    }
                }
            }
            if (newAddrs[i] == null) continue;
            if (i == 0) {
                pa.setPostAddress(newAddrs[0].toString().trim());
                continue;
            }
            if (i == 1) {
                pa.setAreaName1(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 2) {
                pa.setAreaName3(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 3) {
                pa.setPostCode1(newAddrs[i].toString().trim());
                continue;
            }
            if (i != 4) continue;
            pa.setPostCode2(newAddrs[i].toString().trim());
        }
    }

    protected boolean isQCAddress(CAN_ParsedAddress pa) {
        char c;
        String testQC = pa.getAreaName1();
        if (testQC != null && "QC".equals(testQC)) {
            return true;
        }
        return testQC == null && (testQC = pa.getPostCode1()) != null && ((c = testQC.charAt(0)) == 'G' || c == 'H' || c == 'J');
    }

    private void checkRuralFSA(CAN_ParsedAddress pa) {
        String postCode1 = pa.getPostCode1();
        if (postCode1 != null && postCode1.length() > 1 && postCode1.charAt(1) == '0') {
            pa.setIsRuralFSA(true);
        }
    }

    static void populateProvNames(Map names) {
        names.put("ALBERTA", "AB");
        names.put("BRITISH COLUMBIA", "BC");
        names.put("COLUMBIE BRITANNIQUE", "BC");
        names.put("COLUMBIE-BRITANNIQUE", "BC");
        names.put("MANITOBA", "MB");
        names.put("NEW BRUNSWICK", "NB");
        names.put("NOVEAU-BRUNSWICK", "NB");
        names.put("NOVEAU BRUNSWICK", "NB");
        names.put("NEWFOUNDLAND", "NL");
        names.put("NEW FOUNDLAND", "NL");
        names.put("NF", "NL");
        names.put("LABRADOR", "NL");
        names.put("TERRE-NUEVE-ET-LABRADOR", "NL");
        names.put("TERRE NUEVE ET LABRADOR", "NL");
        names.put("TERRE-NUEVE", "NL");
        names.put("TERRE NUEVE", "NL");
        names.put("NORTHWEST TERRITORIES", "NT");
        names.put("TERRITOIRES DU NORD OUEST", "NT");
        names.put("TERRITOIRES DU NORD-OUEST", "NT");
        names.put("TERRITOIRES-DU-NORD-OUEST", "NT");
        names.put("NOVA SCOTIA", "NS");
        names.put("NOVELLE ECOSSE", "NS");
        names.put("NOVELLE \u00c9COSSE", "NS");
        names.put("NOVELLE-ECOSSE", "NS");
        names.put("NOVELLE-\u00c9COSSE", "NS");
        names.put("NUNAVUT", "NU");
        names.put("ONTARIO", "ON");
        names.put("PRINCE EDWARD ISLAND", "PE");
        names.put("PRINCE EDWARD", "PE");
        names.put("P E I", "PE");
        names.put("PEI", "PE");
        names.put("PRINCE EDWARD ISL", "PE");
        names.put("ILE DU PRINCE EDOUARD", "PE");
        names.put("ILE-DU-PRINCE-EDOUARD", "PE");
        names.put("ILE DU PRINCE \u00c9DOUARD", "PE");
        names.put("ILE-DU-PRINCE-\u00c9DOUARD", "PE");
        names.put("\u00ceLE DU PRINCE EDOUARD", "PE");
        names.put("\u00ceLE-DU-PRINCE-EDOUARD", "PE");
        names.put("\u00ceLE DU PRINCE \u00c9DOUARD", "PE");
        names.put("\u00ceLE-DU-PRINCE-\u00c9DOUARD", "PE");
        names.put("PRINCE EDOUARD", "PE");
        names.put("PRINCE-EDOUARD", "PE");
        names.put("PRINCE \u00c9DOUARD", "PE");
        names.put("PRINCE-\u00c9DOUARD", "PE");
        names.put("PQ", "QC");
        names.put("QU\u00c9BEC", "QC");
        names.put("QUEBEC", "QC");
        names.put("PROV QU\u00c9BEC", "QC");
        names.put("PROVINCE DU QU\u00c9BEC", "QC");
        names.put("SASKATCHEWAN", "SK");
        names.put("YUKON", "YT");
        names.put("YUKON TERRITORY", "YT");
    }

    static {
        Character[] chars;
        FSA_MATCH_REGEX = Pattern.compile("^(([A-Z])|(0))((\\d)|(O))(([A-Z])|(0))$");
        FSA_FIXER_REGEX = Pattern.compile(FSA_REGEX_STRING);
        LDU_MATCH_REGEX = Pattern.compile("^((\\d)|(O))(([A-Z])|(0))((\\d)|(O))$");
        LDU_FIXER_REGEX = Pattern.compile(LDU_REGEX_STRING);
        FSALDU_MATCH_REGEX = Pattern.compile("^(([A-Z])|(0))((\\d)|(O))(([A-Z])|(0))( |-|/)?((\\d)|(O))(([A-Z])|(0))((\\d)|(O))$");
        badLeadingLLcharSet = new HashSet();
        String[] prAbbr = new String[]{"AB", "BC", "MB", "NB", "NL", "NT", "NS", "NU", "ON", "PE", "QC", "SK", "YT"};
        HashSet<String> provAbbrs = new HashSet<String>(prAbbr.length, 1.0f);
        for (int i = 0; i < prAbbr.length; ++i) {
            provAbbrs.add(prAbbr[i]);
        }
        m_provAbbrs = Collections.unmodifiableSet(provAbbrs);
        String[] prEndings = new String[]{TAG_PROVINCE, "TERRITORY", "TERRITORIES", "COLUMBIA", "BRUNSWICK", "SCOTIA", "ISLAND", "ISL", "I", "EDWARD", "BRITANNIQUE", "LABRADOR", "NORD-OUEST", "OUEST", "ECOSSE", "\u00c9COSSE", "\u00c9DOUARD", "EDOUARD", "FOUNDLAND"};
        HashSet<String> provEnds = new HashSet<String>(prEndings.length, 1.0f);
        for (int i = 0; i < prEndings.length; ++i) {
            provEnds.add(prEndings[i]);
        }
        m_provEndings = Collections.unmodifiableSet(provEnds);
        HashMap provNames = new HashMap();
        CAN_ParsePostAddressRule.populateProvNames(provNames);
        m_provNames = Collections.unmodifiableMap(provNames);
        Character[] characterArray = chars = new Character[]{Character.valueOf('.'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('&'), Character.valueOf('$')};
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char ch = characterArray[i].charValue();
            badLeadingLLcharSet.add(Character.valueOf(ch));
        }
        badLeadingLLcharSet = Collections.unmodifiableSet(badLeadingLLcharSet);
    }
}

