/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.retries;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.parser.CAN_Directionals;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitType;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitTypes;
import com.mapinfo.mapmarker.CAN.retries.AbstractRetry;
import com.mapinfo.mapmarker.CAN.retries.RetryResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReParseWithLastTokenAsUnitRetry
extends AbstractRetry {
    private static final Set<String> HWY_TYPES;

    @Override
    public RetryResult apply(IConstraints constraints, CAN_ParsedAddress spa) throws MapMarkerInternalException {
        if (spa.getPostThoroughfareType() == null && spa.getAdditionalFieldForKey("XSECT_POBOX") == null && spa.getPostDirectional() == null && spa.getUnitType() == null && spa.getUnitValue() == null) {
            Address inputAddress = constraints.getHandler().getInputAddress();
            boolean bHadHouseNumber = spa.getAddressNumber() != null;
            StringWithTokens tokens = new StringWithTokens(inputAddress.getMainAddress());
            if (tokens.size() > (bHadHouseNumber ? 3 : 2) && this.hasCoveredPostType(tokens, bHadHouseNumber)) {
                if (!this.modifyLastTokenAsUnitValue(tokens)) {
                    return RetryResult.makeNonApplyResult();
                }
                AddressImpl updatedInputAddress = new AddressImpl(inputAddress);
                updatedInputAddress.setMainAddress(tokens.toString());
                String originalPreType = spa.getPreThoroughfareType();
                constraints.getHandler().getParseHandler().getParsedAddresses((Address)updatedInputAddress, constraints);
                CAN_ParsedAddress updatedParsedAddress = (CAN_ParsedAddress)constraints.getHandler().getParsedAddress();
                if (originalPreType != null && updatedParsedAddress.getPreThoroughfareType() != null) {
                    this.setSearchParsedAddress(constraints.getHandler(), (Address)spa);
                    this.setParsedAddress(constraints.getHandler(), (Address)spa);
                    return RetryResult.makeNonApplyResult();
                }
                this.setSearchParsedAddress(constraints.getHandler(), (Address)updatedParsedAddress);
                this.setParsedAddress(constraints.getHandler(), (Address)updatedParsedAddress);
                return RetryResult.makeApplyResult(spa, true, true);
            }
        }
        return RetryResult.makeNonApplyResult();
    }

    private boolean hasCoveredPostType(StringWithTokens tokens, boolean bHadHouseNumber) {
        CAN_NewThoroughfareTypes.KeyInfo typeInfo;
        String token = tokens.getToken(tokens.size() - 2).toUpperCase();
        if (CAN_Directionals.isDirectional(token) && tokens.size() > (bHadHouseNumber ? 4 : 3)) {
            token = tokens.getToken(tokens.size() - 3).toUpperCase();
        }
        return (typeInfo = CAN_NewThoroughfareTypes.lookupByTypeName(token)) != null && !HWY_TYPES.contains(typeInfo.getPreferredTypeName());
    }

    private boolean modifyLastTokenAsUnitValue(StringWithTokens tokens) {
        String lastToken = tokens.getToken(tokens.size() - 1).toUpperCase();
        if (StringUtilities.isNumeric((String)lastToken)) {
            tokens.insert(tokens.size() - 1, "#");
            return true;
        }
        int length = lastToken.length();
        if (length > 2) {
            for (int i = length - 1; i > 2; --i) {
                String partial = lastToken.substring(0, i);
                CAN_UnitType unit = CAN_UnitTypes.getUnitType(partial);
                if (unit == null) continue;
                tokens.insert(tokens.size() - 1, partial);
                tokens.setToken(tokens.size() - 1, lastToken.substring(i));
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> hwyTypes = new HashSet<String>();
        hwyTypes.add("HWY");
        hwyTypes.add("RTE");
        HWY_TYPES = Collections.unmodifiableSet(hwyTypes);
    }
}

