/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Comparator;

public class AvoidPRTasTypeWhenMainEndsWithPostTypeWordRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        String postType2;
        String postType1;
        String main2;
        CAN_ParsedAddress parsed1 = (CAN_ParsedAddress)o1.getParse()[0];
        CAN_ParsedAddress parsed2 = (CAN_ParsedAddress)o2.getParse()[0];
        String main1 = parsed1.getMainAddress();
        if (!this.doRule(main1, main2 = parsed2.getMainAddress(), postType1 = parsed1.getPostThoroughfareType(), postType2 = parsed2.getPostThoroughfareType())) {
            return 0;
        }
        StringWithTokens toks1 = new StringWithTokens(main1);
        StringWithTokens toks2 = new StringWithTokens(main2);
        if ((toks1.size() == 1 || toks1.size() > 1 && toks2.size() > 1) && parsed1.getPostThoroughfareType() != null && parsed2.getPostThoroughfareType().equals("PRT") && CAN_NewThoroughfareTypes.isStreetType(toks2.getLastToken())) {
            return -1;
        }
        if ((toks2.size() == 1 || toks1.size() > 1 && toks2.size() > 1) && parsed2.getPostThoroughfareType() != null && parsed1.getPostThoroughfareType().equals("PRT") && CAN_NewThoroughfareTypes.isStreetType(toks1.getLastToken())) {
            return 1;
        }
        return 0;
    }

    private boolean doRule(String main1, String main2, String postType1, String postType2) {
        if (StringUtilities.isEmpty((String)main1) || StringUtilities.isEmpty((String)main2) || StringUtilities.isEmpty((String)postType1) || StringUtilities.isEmpty((String)postType2) || main1.equalsIgnoreCase(main2)) {
            return false;
        }
        if (postType1.equals(postType2) || !"PRT".equalsIgnoreCase(postType1) && !"PRT".equalsIgnoreCase(postType2)) {
            return false;
        }
        StringWithTokens toks1 = new StringWithTokens(main1);
        StringWithTokens toks2 = new StringWithTokens(main2);
        return toks1.size() >= 2 || toks2.size() >= 2;
    }
}

