/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.singleline.AvoidEndingWithArticleRule;
import com.mapinfo.mapmarker.CAN.singleline.AvoidEndingWithSaintRule;
import com.mapinfo.mapmarker.CAN.singleline.AvoidExtraWordInMainWithNumericForPreTypeHWYRule;
import com.mapinfo.mapmarker.CAN.singleline.AvoidNumericInPostAddressRule;
import com.mapinfo.mapmarker.CAN.singleline.AvoidPRTasTypeWhenMainEndsWithPostTypeWordRule;
import com.mapinfo.mapmarker.CAN.singleline.CANSpecialCaseHandler;
import com.mapinfo.mapmarker.CAN.singleline.PreferCityNotStartingWithNumberRule;
import com.mapinfo.mapmarker.CAN.singleline.PreferDirectionalInCityOverUnitRule;
import com.mapinfo.mapmarker.CAN.singleline.PreferDirectionalInPostDirOverCityRule;
import com.mapinfo.mapmarker.CAN.singleline.PreferExplicitStationInfoRule;
import com.mapinfo.mapmarker.CAN.singleline.PreferNumericUnitValueRule;
import com.mapinfo.mapmarker.CAN.singleline.PreferTypeRule;
import com.mapinfo.mapmarker.CAN.singleline.Special_ST_HandlingRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;
import com.mapinfo.mapmarker.core.singleline.parser.CoreSingleLineParser;
import com.mapinfo.mapmarker.core.singleline.parser.NoNumericInAN3Rule;
import com.mapinfo.mapmarker.core.singleline.parser.NumberOfFieldsParsedRule;
import com.mapinfo.mapmarker.core.singleline.parser.PreferAN3Rule;
import com.mapinfo.mapmarker.core.singleline.parser.ShorterA3Rule;
import com.mapinfo.mapmarker.utils.AggregateComparator;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class CANSingleLineParser
extends CoreSingleLineParser {
    private static final AggregateComparator<IAddressParsing> NON_SHORT_AN3_COMP;
    private static final AggregateComparator<IAddressParsing> SHORT_AN3_COMP;
    private CANSpecialCaseHandler m_specialCaseHandler = new CANSpecialCaseHandler();
    private static final AggregateComparator<IAddressParsing> MISSPLACED_POSTDIRECTIONAL_COMP;

    public CANSingleLineParser() {
        super(CANSingleLineParser.buildFullSingleLineRules(), 1);
    }

    protected List<IAddressSplit> createSplits(Address input, IConstraints constraints) {
        input.setMainAddress(AddressUtils.stripEndQuotes(input.getMainAddress().replaceAll("(CAN|CANADA)(\\s*)$", "")));
        List result = super.createSplits(input, constraints);
        ListIterator itr = result.listIterator();
        while (itr.hasNext()) {
            IAddressSplit split = (IAddressSplit)itr.next();
            if (!split.isFromReverseSplit()) continue;
            itr.remove();
        }
        return result;
    }

    protected List<IAddressParsing> createFinalList(List<IAddressParsing> parsings) {
        IAddressParsing second;
        IAddressParsing first;
        Collections.sort(parsings, this.getSortComparator());
        ArrayList<IAddressParsing> result = new ArrayList<IAddressParsing>();
        result.add(parsings.get(0));
        result.addAll(this.m_specialCaseHandler.getSpecialCaseParsings(parsings));
        if (result.size() == 1 && parsings.size() > 1 && NON_SHORT_AN3_COMP.compare((Object)(first = parsings.get(0)), (Object)(second = parsings.get(1))) == 0 && SHORT_AN3_COMP.compare((Object)first, (Object)second) != 0) {
            String testStr;
            StringWithTokens swt = new StringWithTokens(first.getSplit().getAddress().getMainAddress().toUpperCase());
            if (swt.size() > 0 && first.getParse()[0].getAreaName3() != null && (testStr = swt.getLastToken() + " " + first.getParse()[0].getAreaName3()).equalsIgnoreCase(second.getParse()[0].getAreaName3())) {
                result.clear();
                result.add(second);
                result.add(first);
            }
            if (result.size() == 1) {
                result.add(second);
            }
        }
        if (result.size() == 1 && parsings.size() > 1 && MISSPLACED_POSTDIRECTIONAL_COMP.compare((Object)(first = parsings.get(0)), (Object)(second = parsings.get(1))) == 1) {
            result.add(second);
        }
        return result;
    }

    private static List<Comparator<IAddressParsing>> buildFullSingleLineRules() {
        List<Comparator<IAddressParsing>> rules = CANSingleLineParser.buildAllButShorterAN3Rule();
        rules.add((Comparator<IAddressParsing>)new ShorterA3Rule());
        return rules;
    }

    private static List<Comparator<IAddressParsing>> buildAllButShorterAN3Rule() {
        ArrayList<Comparator<IAddressParsing>> rules = new ArrayList<Comparator<IAddressParsing>>();
        rules.add((Comparator<IAddressParsing>)new NoNumericInAN3Rule());
        rules.add((Comparator<IAddressParsing>)new PreferAN3Rule());
        rules.add(new PreferNumericUnitValueRule());
        rules.add(new PreferExplicitStationInfoRule());
        rules.add(new AvoidNumericInPostAddressRule());
        rules.add(new PreferDirectionalInCityOverUnitRule());
        rules.add(new PreferTypeRule());
        rules.add((Comparator<IAddressParsing>)new NumberOfFieldsParsedRule());
        rules.add(new Special_ST_HandlingRule());
        rules.add(new AvoidEndingWithArticleRule());
        rules.add(new AvoidEndingWithSaintRule());
        rules.add(new AvoidPRTasTypeWhenMainEndsWithPostTypeWordRule());
        rules.add(new AvoidExtraWordInMainWithNumericForPreTypeHWYRule());
        rules.add(new PreferCityNotStartingWithNumberRule());
        return rules;
    }

    private static List<Comparator<IAddressParsing>> buildAllWithPreferDirectionalInPostDirOverCityRule() {
        ArrayList<Comparator<IAddressParsing>> rules = new ArrayList<Comparator<IAddressParsing>>();
        rules.add((Comparator<IAddressParsing>)new NoNumericInAN3Rule());
        rules.add((Comparator<IAddressParsing>)new PreferAN3Rule());
        rules.add(new PreferDirectionalInPostDirOverCityRule());
        rules.add(new PreferNumericUnitValueRule());
        rules.add(new PreferExplicitStationInfoRule());
        rules.add(new AvoidNumericInPostAddressRule());
        rules.add(new PreferDirectionalInCityOverUnitRule());
        rules.add(new PreferTypeRule());
        rules.add((Comparator<IAddressParsing>)new NumberOfFieldsParsedRule());
        rules.add(new Special_ST_HandlingRule());
        rules.add(new AvoidEndingWithArticleRule());
        rules.add(new AvoidEndingWithSaintRule());
        return rules;
    }

    static {
        List<Comparator<IAddressParsing>> rules = CANSingleLineParser.buildAllButShorterAN3Rule();
        NON_SHORT_AN3_COMP = new AggregateComparator(rules);
        ArrayList<ShorterA3Rule> ruleShorterAN3 = new ArrayList<ShorterA3Rule>(1);
        ruleShorterAN3.add(new ShorterA3Rule());
        SHORT_AN3_COMP = new AggregateComparator(ruleShorterAN3);
        rules = CANSingleLineParser.buildAllWithPreferDirectionalInPostDirOverCityRule();
        MISSPLACED_POSTDIRECTIONAL_COMP = new AggregateComparator(rules);
    }
}

