/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.StringTokenizer;

class PreferExplicitStationInfoRule
implements Comparator<IAddressParsing> {
    PreferExplicitStationInfoRule() {
    }

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        CAN_ParsedAddress parsed1 = (CAN_ParsedAddress)o1.getParse()[0];
        CAN_ParsedAddress parsed2 = (CAN_ParsedAddress)o2.getParse()[0];
        String station1 = parsed1.getStationInformation();
        String station2 = parsed2.getStationInformation();
        boolean bExplicitStation1 = this.startsWithStation(station1);
        boolean bExplicitStation2 = this.startsWithStation(station2);
        if (StringUtilities.isEmpty((String)station1) && StringUtilities.isEmpty((String)station2)) {
            return 0;
        }
        if (station1 == null) {
            if (bExplicitStation2) {
                return 1;
            }
            return -1;
        }
        if (station2 == null) {
            if (bExplicitStation1) {
                return -1;
            }
            return 1;
        }
        if (bExplicitStation1 && bExplicitStation2) {
            StringTokenizer tokenizer1 = new StringTokenizer(station1);
            StringTokenizer tokenizer2 = new StringTokenizer(station2);
            if (tokenizer1.countTokens() > tokenizer2.countTokens()) {
                return -1;
            }
            if (tokenizer1.countTokens() < tokenizer2.countTokens()) {
                return 1;
            }
        } else {
            if (bExplicitStation1) {
                return -1;
            }
            if (bExplicitStation2) {
                return 1;
            }
        }
        return 0;
    }

    private boolean startsWithStation(String str) {
        if (str != null) {
            return str.startsWith("STATION") || str.startsWith("STN") || str.startsWith("RPO");
        }
        return false;
    }
}

