/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.EMEA.EMEA_AddressFilter;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CHE_AddressFilter
extends EMEA_AddressFilter {
    private static String COUNTRY_LIE_INDICATOR = "Liechtenstein";

    private CHE_AddressFilter() {
    }

    public static void filterAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        IHandler handler = constraints.getHandler();
        List candidates = handler.getMatchResults();
        boolean removed = false;
        Address inAddr = handler.getInputAddress();
        if (inAddr != null) {
            String inputCntryCode = inAddr.getCountry();
            removed = CHE_AddressFilter.filterBasedOnCountryCode(inputCntryCode, candidates);
        }
        if (candidates != null && removed) {
            CHE_AddressFilter.countCandidates(candidates, geocodeResult);
            CHE_AddressFilter.countCloseMatches(candidates, geocodeResult);
            ((ArrayList)candidates).trimToSize();
        }
    }

    protected static void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null) {
            geocodeResult.setNumberCandidates(0);
        } else {
            geocodeResult.setNumberCandidates(candidateList.size());
        }
    }

    protected static void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList != null) {
            Iterator candidateIterator = candidateList.iterator();
            boolean done = false;
            while (candidateIterator.hasNext() && !done) {
                ICandidate candidate = (ICandidate)candidateIterator.next();
                if (candidate.isCloseMatch()) {
                    ++closeMatchCount;
                    continue;
                }
                done = true;
            }
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    private static boolean filterBasedOnCountryCode(String country, List candidates) {
        boolean removed = false;
        if (candidates != null) {
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                String an1 = CHE_AddressFilter.getCandidateAreaName1((ICandidate)i.next());
                if (COUNTRY_LIE_INDICATOR.equalsIgnoreCase(an1)) {
                    if ("LIE".equals(country)) continue;
                    i.remove();
                    removed = true;
                    continue;
                }
                if (!"LIE".equals(country)) continue;
                i.remove();
                removed = true;
            }
        }
        return removed;
    }

    private static String getCandidateAreaName1(ICandidate candidate) {
        if (candidate instanceof InternalCandidateAddress) {
            return ((InternalCandidateAddress)candidate).getAreaName1();
        }
        if (candidate instanceof InternalGeographicCandidate) {
            return ((InternalGeographicCandidate)candidate).getAreaName1();
        }
        if (candidate instanceof InternalPostalCandidate) {
            return ((InternalPostalCandidate)candidate).getAreaName1();
        }
        if (candidate instanceof InternalBrowseAddress) {
            return ((InternalBrowseAddress)candidate).getSegmentAt(0).getLeftAreaName1();
        }
        if (candidate instanceof InternalIntersectionCandidateAddress) {
            return ((InternalIntersectionCandidateAddress)candidate).getCandidate1().getAreaName1();
        }
        return null;
    }

    public static void filterBrowseAddresses(IConstraints constraints, GeocodeResult geocodeResult) {
        boolean removed = false;
        IHandler handler = constraints.getHandler();
        Address inAddr = handler.getInputAddress();
        List candidates = handler.getMatchResults();
        if (inAddr != null) {
            String inputCntryCode = inAddr.getCountry();
            removed = CHE_AddressFilter.filterBasedOnCountryCode(inputCntryCode, candidates);
        }
        if (removed) {
            CHE_AddressFilter.countCandidates(candidates, geocodeResult);
            CHE_AddressFilter.countCloseMatches(candidates, geocodeResult);
            ((ArrayList)candidates).trimToSize();
        }
    }
}

