/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.EMEA.EMEA_ConstraintsHelper;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;

public class CHE_ConstraintsHelper
extends EMEA_ConstraintsHelper {
    @Override
    public void addLocalStreetConstraints(IConstraints constraints, IHandler handler) {
        if (constraints.getHandler().getInputAddress() != null) {
            String an2 = constraints.getHandler().getInputAddress().getAreaName2();
            String an1 = constraints.getHandler().getInputAddress().getAreaName1();
            if ((an2 == null || an2.length() == 0) && an1 != null && an1.length() > 0) {
                constraints.setMustMatchArea2(constraints.isMustMatchArea1());
            }
        }
        constraints.setMatcherRemoveMultipleSegments(true);
        constraints.setMustMatchArea4(false);
        constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
        constraints.setCustomString("KEY_GEOBASE_STRING_ONLY", "true");
        constraints.setCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL", "true");
    }

    @Override
    public void addLocalIntersectionConstraints(IConstraints constraints, IHandler handler) {
        constraints.setMatcherRemoveMultipleSegments(false);
        constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
        constraints.setCustomString("KEY_GEOBASE_STRING_ONLY", "true");
        constraints.setCustomString("KEY_GEOBASE_FOR_AREA4", "true");
    }

    @Override
    public void addLocalGeographicConstraints(IConstraints constraints, IHandler handler) {
        this.handleMustMatchFlagForAreaname2(constraints);
        super.addLocalGeographicConstraints(constraints, handler);
    }

    private void handleMustMatchFlagForAreaname2(IConstraints constraints) {
        Address inputAddr = constraints.getHandler().getInputAddress();
        if (inputAddr != null && constraints.isMustMatchArea1() != constraints.isMustMatchArea2() && CHE_AddressUtils.isEmpty(inputAddr.getAreaName2()) && !CHE_AddressUtils.isEmpty(inputAddr.getAreaName1())) {
            constraints.setMustMatchArea2(constraints.isMustMatchArea1());
        }
    }
}

