/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.CHE_StreetMultipleSegmentComparator;
import com.mapinfo.mapmarker.CHE.DEU.DEU_MatcherHandler;
import com.mapinfo.mapmarker.CHE.DEU.DEU_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_PreParseHandler;
import com.mapinfo.mapmarker.CHE.FRA.FRA_MatcherHandler;
import com.mapinfo.mapmarker.CHE.FRA.FRA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_PreParseHandler;
import com.mapinfo.mapmarker.CHE.ITA.ITA_MatcherHandler;
import com.mapinfo.mapmarker.CHE.ITA.ITA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_PreParseHandler;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.parser.IParseRuleHandler;
import com.mapinfo.mapmarker.core.parser.IPreParseHandler;

public class CHE_HandlerImpl
extends CoreHandler
implements CHE_Handler {
    private Address m_preparsedAddress;
    private String m_countryCode;
    private IParseRuleHandler m_parseHandler;
    private IMatcherHandler m_matcherHandler;
    private IPreParseHandler m_preParseHandler;
    private IStreetSingleAddressGeocoder m_streetSingelAddressGeocoder;
    private String m_tempCountryCode = "";
    private int m_geocodeType;

    @Override
    public void setPreParsedAddress(Address unrefinedPreParsedAddress) {
        this.m_preparsedAddress = unrefinedPreParsedAddress;
    }

    @Override
    public Address getPreParsedAddress() {
        return this.m_preparsedAddress;
    }

    public IMatcherHandler getMatcherHandler() {
        String countryCode = this.getCountryCode();
        if (countryCode.equalsIgnoreCase("DEU")) {
            this.m_matcherHandler = new DEU_MatcherHandler();
            ((DEU_MatcherHandler)this.m_matcherHandler).setComparator(new CHE_StreetMultipleSegmentComparator());
        } else if (countryCode.equalsIgnoreCase("FRA")) {
            this.m_matcherHandler = new FRA_MatcherHandler();
            ((FRA_MatcherHandler)this.m_matcherHandler).setComparator(new CHE_StreetMultipleSegmentComparator());
        } else if (countryCode.equalsIgnoreCase("ITA")) {
            this.m_matcherHandler = new ITA_MatcherHandler();
            ((ITA_MatcherHandler)this.m_matcherHandler).setComparator(new CHE_StreetMultipleSegmentComparator());
        }
        return this.m_matcherHandler;
    }

    public IPreParseHandler getPreParseHandler() {
        String countryCode = this.getCountryCode();
        if (countryCode.equalsIgnoreCase("DEU")) {
            this.m_preParseHandler = new DEU_PreParseHandler();
        } else if (countryCode.equalsIgnoreCase("FRA")) {
            this.m_preParseHandler = new FRA_PreParseHandler();
        } else if (countryCode.equalsIgnoreCase("ITA")) {
            this.m_preParseHandler = new ITA_PreParseHandler();
        }
        return this.m_preParseHandler;
    }

    @Override
    public void setCountryCode(String countryCode) {
        this.m_countryCode = countryCode;
    }

    @Override
    public String getCountryCode() {
        return this.m_countryCode;
    }

    @Override
    public IParseRuleHandler getParserHandler() {
        return this.m_parseHandler;
    }

    @Override
    public void setParserHandler(IParseRuleHandler handler) {
        this.m_parseHandler = handler;
    }

    @Override
    public IStreetSingleAddressGeocoder getSingleAddressGeocoder(IHandler handler) {
        String countryCode = this.getCountryCode();
        if (!this.m_tempCountryCode.equalsIgnoreCase(countryCode) && countryCode.equalsIgnoreCase("DEU")) {
            this.m_streetSingelAddressGeocoder = new DEU_StreetSingleAddressGeocoder(handler);
            this.m_tempCountryCode = countryCode;
        } else if (!this.m_tempCountryCode.equalsIgnoreCase(countryCode) && countryCode.equalsIgnoreCase("FRA")) {
            this.m_streetSingelAddressGeocoder = new FRA_StreetSingleAddressGeocoder(handler);
            this.m_tempCountryCode = countryCode;
        } else if (!this.m_tempCountryCode.equalsIgnoreCase(countryCode) && countryCode.equalsIgnoreCase("ITA")) {
            this.m_streetSingelAddressGeocoder = new ITA_StreetSingleAddressGeocoder(handler);
            this.m_tempCountryCode = countryCode;
        }
        return this.m_streetSingelAddressGeocoder;
    }

    @Override
    public void setGeocodeTypeForParsing(int geocodeType) {
        this.m_geocodeType = geocodeType;
    }

    @Override
    public int getGeocodeTypeForParsing() {
        return this.m_geocodeType;
    }
}

