/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import java.util.HashMap;

public class CHE_InternalBrowseAddress
extends InternalBrowseAddress {
    private StreetBasedIdentifier m_identifier = null;

    public CHE_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        candidate.setPreAddress(CHE_InternalBrowseAddress.getFormattedPreAddress((Address)this));
        Segment segment = this.getSegmentAt(0);
        if (!CHE_AddressUtils.isEmpty(parsed.getPlaceName())) {
            String placeName = this.getFirstFoundPlaceNameFromSegment(segment, 0);
            if (CHE_AddressUtils.isEmpty(placeName)) {
                placeName = this.getFirstFoundPlaceNameFromSegment(segment, 1);
            }
            if (!CHE_AddressUtils.isEmpty(placeName)) {
                candidate.setPlaceName(placeName);
            }
        }
        String fullTownName = segment.getLeftAreaName4();
        candidate.setAreaName3(segment.getLeftAreaName3());
        candidate.setAreaName4(fullTownName);
        candidate.setPostCode1(segment.getLeftPostCode1());
        candidate.setGenericField1(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        Address address = constraints.getHandler().getInputAddress();
        candidate.setCountry(address.getCountry());
        CHE_AddressUtils.converttoCamelCase(candidate);
        return candidate;
    }

    protected String getFormattedStreetAddress() {
        return CHE_InternalBrowseAddress.reconstructAddress(this);
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    private String getFirstFoundPlaceNameFromSegment(Segment segment, int side) {
        int rangeCount;
        if ((side == 0 || side == 1) && (rangeCount = segment.getRangeCount(side)) > 0) {
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                if (range == null || CHE_AddressUtils.isEmpty(range.getPlaceName())) continue;
                return range.getPlaceName();
            }
        }
        return null;
    }

    public static String getFormattedPreAddress(Address addr) {
        String preMainCommon;
        String preAddrCommon;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((preAddrCommon = (String)fields.get("pre_addr_common")) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("pre_main_address_common")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return buf.toString().trim();
    }

    public static String reconstructAddress(InternalBrowseAddress cand) {
        String original_address = cand.getGenericField4();
        if (original_address != null) {
            return original_address;
        }
        StringBuffer buff = new StringBuffer();
        String tmp = CHE_InternalBrowseAddress.noNulls(CHE_InternalCandidateAddress.reconstructMainAddress((Address)cand));
        if (tmp.length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = CHE_InternalBrowseAddress.noNulls(CHE_InternalBrowseAddress.getFormattedPreAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(' ');
            }
        }
        if ((tmp = CHE_InternalBrowseAddress.noNulls(cand.getPreThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalBrowseAddress.noNulls(cand.getPostThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalBrowseAddress.noNulls(cand.getAddressNumber())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
        }
        return buff.toString();
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    public String getAreaName2() {
        Segment segment;
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && (segment = this.getSegmentAt(0)) != null) {
            String right;
            String left = segment.getLeftAreaName2();
            areaName2 = left != null ? left : (right = segment.getRightAreaName2());
        }
        return areaName2;
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegmentAt(0)) != null) {
            String right;
            String left = segment.getLeftAreaName1();
            areaName1 = left != null ? left : (right = segment.getRightAreaName1());
        }
        return areaName1;
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

