/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.util.Locale;
import java.util.StringTokenizer;

public class CHE_InternalGeographicCandidate
extends EMEA_InternalGeographicCandidate {
    private static final double DELTA = 1.0E-10;
    private String m_possibleLocality;
    private double m_possibleLocalityScore = -1.0;
    private static final double LOCALITY_PERFECT_MATCHED_SCORE = 0.999999;
    private boolean m_isAPCandidate;

    public CHE_InternalGeographicCandidate() {
        this.setStringScorer(new StringScorer(true, new Locale("ch", "CH"), CHE_AddressTerm.getScoringRules().toUpperCase()));
    }

    public CHE_InternalGeographicCandidate(boolean isAPCandidate) {
        this();
        this.m_isAPCandidate = isAPCandidate;
    }

    private void checkForeignLanguageAreaNameScores(Address inputAddress) {
        GeoInfoRecord record = this.getGeoInfoRecord();
        if (this.getAreaName3Score() != 1.0 && record != null && record.getAltAreaName3() != null) {
            double highScore = this.getAreaName3Score();
            StringTokenizer tokens = new StringTokenizer(record.getAltAreaName3(), "/", false);
            while (tokens.hasMoreTokens() && highScore != 1.0) {
                String s = tokens.nextToken();
                StringScorer stringScorer = this.getStringScorer();
                String string = inputAddress.getAreaName4() == null ? inputAddress.getAreaName3() : inputAddress.getAreaName4();
                double tempScore = stringScorer.scoreString(s, string);
                if (!(tempScore > this.getAreaName3Score()) || !(tempScore > highScore)) continue;
                highScore = tempScore;
            }
            this.setAreaName3Score(highScore);
        }
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        CandidateAddress candidate = new CandidateAddress();
        String areaName1 = this.getAreaName1();
        candidate.setAreaName1(areaName1);
        String areaName2 = this.getAreaName2();
        if (areaName2 != null) {
            candidate.setAreaName2(areaName2);
        }
        String areaName3 = this.getAreaName3();
        String areaName4 = this.getAreaName4();
        if (areaName4 != null && this.getPrecision() == 11) {
            candidate.setAreaName3(areaName4);
            candidate.setAreaName4(areaName3);
        } else {
            candidate.setAreaName3(areaName3);
        }
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.fieldExists(inputAddress.getAreaName2())) {
            if (this.getAreaName2Score() == 1.0) {
                candidate.setAreaName2Matched();
            }
        } else if (!this.fieldExists(candidate.getAreaName2())) {
            candidate.setAreaName2Matched();
        }
        if (this.fieldExists(inputAddress.getAreaName1())) {
            if (this.getAreaName1Score() == 1.0) {
                candidate.setAreaName1Matched();
            }
        } else if (!this.fieldExists(candidate.getAreaName1())) {
            candidate.setAreaName1Matched();
        }
        if (this.fieldExists(inputAddress.getAreaName3())) {
            if (this.doesAreaName3PerfectMatched()) {
                candidate.setAreaName3Matched();
            }
        } else if (!this.fieldExists(candidate.getAreaName3())) {
            candidate.setAreaName3Matched();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.m_possibleLocality != null && this.getAreaName3Score() < this.m_possibleLocalityScore + 1.0E-10 && this.getAreaName3Score() > this.m_possibleLocalityScore - 1.0E-10) {
            candidate.setAreaName4(this.m_possibleLocality);
        }
        if (this.getCentroid() != null) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystem();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)this.getCentroid()));
        } else {
            candidate.setLocation(new DoublePoint());
        }
        candidate.setLocationPrecision(this.getPrecision());
        String geoRes = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geoRes);
        Address address = constraints.getHandler().getInputAddress();
        candidate.setCountry(address.getCountry());
        CHE_AddressUtils.converttoCamelCase(candidate);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidate;
    }

    private boolean fieldExists(String field) {
        return field != null && field.trim().length() != 0;
    }

    public boolean doesAreaName3PerfectMatched() {
        if (this.getAreaName3Score() == 1.0) {
            return true;
        }
        return this.m_possibleLocality != null && this.getAreaName3Score() == 0.999999;
    }

    public boolean isAPCandidate() {
        return this.m_isAPCandidate;
    }

    public void scoreCountry(Address inputAddress) {
        String inputCountry;
        String candidateCountry;
        StringScorer scorer = this.getStringScorer();
        double countryScore = scorer.scoreString(candidateCountry = this.getCountry(), inputCountry = inputAddress.getCountry());
        if (countryScore != 1.0) {
            candidateCountry = inputCountry;
        }
        countryScore = scorer.scoreString(candidateCountry, inputCountry);
        this.setCountryScore(countryScore);
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        if (charsToIgnore == null) {
            charsToIgnore = " _-. ,'/";
        }
        String inputTown = inputAddress.getAreaName3();
        String candTown = this.getAreaName4() == null ? this.getAreaName3() : this.getAreaName4();
        String candAltTown = this.getGeoInfoRecord().getAltAreaName3();
        double area3Score = 0.0;
        EMEA_GeoInfoRecord geoRecord = (EMEA_GeoInfoRecord)this.getGeoInfoRecord();
        String altLanguageName = geoRecord.getAltLanguageNames();
        if (inputTown != null && candTown != null) {
            String geoInfoName;
            area3Score = this.getStringScorer().scoreString(CHE_AddressTerm.cleanExtendedCharsInString(candTown.toUpperCase()), CHE_AddressTerm.cleanExtendedCharsInString(inputTown.toUpperCase()), charsToIgnore);
            if (area3Score != 1.0 && !CHE_AddressUtils.isEmpty(geoInfoName = this.getAreaName3()) && !geoInfoName.equals(candTown)) {
                double tempScore = this.getStringScorer().scoreString(inputTown.toUpperCase(), geoInfoName.toUpperCase(), charsToIgnore);
                if (tempScore > area3Score) {
                    area3Score = tempScore;
                }
                if (tempScore != 1.0 && (tempScore = this.getStringScorer().scoreString(CHE_AddressTerm.cleanExtendedCharsInString(inputTown.toUpperCase()), CHE_AddressTerm.cleanExtendedCharsInString(geoInfoName.toUpperCase()), charsToIgnore)) > area3Score) {
                    area3Score = tempScore;
                }
            }
            if (area3Score != 1.0) {
                double score;
                String candSortTown = geoRecord.getAreaName3Short();
                if (candSortTown != null) {
                    candSortTown = candSortTown.toUpperCase();
                }
                if ((score = this.getStringScorer().scoreString(inputTown.toUpperCase(), candSortTown, charsToIgnore)) > area3Score) {
                    area3Score = score;
                }
            }
            if (area3Score != 1.0 && candAltTown != null) {
                String[] tokens = candAltTown.split("/");
                for (int index = 0; index < tokens.length; ++index) {
                    double score = this.getStringScorer().scoreString(tokens[index], inputTown, charsToIgnore);
                    if (!(score > area3Score)) continue;
                    area3Score = score;
                }
            }
        }
        if (inputTown != null && candTown != null && area3Score != 1.0) {
            double newScore;
            StringBuffer candFullName = new StringBuffer();
            StringBuffer inputFullName = new StringBuffer();
            boolean foundInputAbbr = false;
            boolean foundCandAbbr = false;
            if ((foundCandAbbr || foundInputAbbr) && (newScore = this.getStringScorer().scoreString(candFullName.toString(), inputFullName.toString(), charsToIgnore)) > area3Score) {
                area3Score = newScore;
            }
        }
        if (area3Score != 1.0) {
            String candidateAltTown = null;
            if (altLanguageName != null) {
                StringTokenizer tokens = new StringTokenizer(altLanguageName, "/");
                while (tokens.hasMoreTokens()) {
                    candidateAltTown = tokens.nextToken().toUpperCase();
                    if (candidateAltTown == null) continue;
                    candidateAltTown = CHE_AddressTerm.removeCommonWords(candidateAltTown, false);
                    double score = this.getStringScorer().scoreString(candidateAltTown, inputTown);
                    if (!(score > area3Score) || (area3Score = score) != 1.0) continue;
                    break;
                }
            }
        }
        this.setAreaName3Score(area3Score);
        String candAreaName3 = candTown;
        String parsedAreaName3 = inputTown;
        if (area3Score != 1.0 && parsedAreaName3 != null && candAreaName3 != null) {
            int candCount;
            StringTokenizer parsedToker = new StringTokenizer(parsedAreaName3, " -", false);
            StringTokenizer candToker = new StringTokenizer(candAreaName3, " -", false);
            int parsedCount = parsedToker.countTokens();
            if (parsedCount > (candCount = candToker.countTokens())) {
                double multiWordScore = 0.0;
                for (int i = 0; i < candCount; ++i) {
                    String tempCand = (String)candToker.nextElement();
                    String tempParsed = (String)parsedToker.nextElement();
                    multiWordScore += this.getStringScorer().scoreString(tempCand, tempParsed, charsToIgnore);
                }
                if (candCount > 0) {
                    multiWordScore /= (double)parsedCount;
                }
                if (multiWordScore > area3Score && multiWordScore > 0.8) {
                    if (multiWordScore == 1.0) {
                        double regionScore;
                        StringBuffer buf = new StringBuffer();
                        while (parsedToker.hasMoreTokens()) {
                            buf.append(parsedToker.nextToken());
                        }
                        if (buf.length() > 0 && (regionScore = this.getStringScorer().scoreString(buf.toString(), this.getAreaName2(), charsToIgnore)) != 1.0) {
                            multiWordScore = 0.95;
                        }
                    }
                    area3Score = multiWordScore;
                    this.setAreaName3Score(area3Score);
                }
            }
        }
        this.checkForeignLanguageAreaNameScores(inputAddress);
        this.setAreaName1Score(this.getStringScorer().scoreString(inputAddress.getAreaName1(), this.getAreaName1()));
        if (CHE_AddressUtils.isEmpty(inputAddress.getAreaName1()) && this.getAreaName1Score() == 0.0) {
            this.setAreaName1Score(1.0);
        }
        this.setAreaName2Score(1.0);
        String inputAreaName4 = inputAddress.getAreaName3();
        String candLocality = geoRecord.getAliasedLocality();
        this.setAreaName4Score(this.getStringScorer().scoreString(inputAreaName4, candLocality));
        this.scoreCountry(inputAddress);
    }

    public int compareTo(Object o1) {
        CHE_InternalGeographicCandidate candidate1 = this;
        InternalGeographicCandidate candidate2 = (InternalGeographicCandidate)o1;
        if (candidate1.isCloseMatch() ^ candidate2.isCloseMatch()) {
            if (candidate1.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (candidate1.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (candidate1.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (candidate1.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (candidate1.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (candidate1.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (candidate1.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (candidate1.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (candidate1.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (candidate1.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (candidate1.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (candidate2.getCountryScore() > candidate2.getCountryScore()) {
            return -1;
        }
        if (candidate1.getPrecision() == 10 && candidate2.getPrecision() != 10) {
            return 1;
        }
        if (candidate1.getPrecision() != 10 && candidate2.getPrecision() == 10) {
            return -1;
        }
        if (candidate1.getPrecision() > candidate2.getPrecision()) {
            if (candidate1.getPrecision() != 11 || candidate1.getAreaName4Score() != 0.0) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getPrecision() < candidate2.getPrecision()) {
            if (candidate2.getPrecision() != 11 || candidate2.getAreaName4Score() != 0.0) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

