/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.DEU.DEU_ScoringAddress;
import com.mapinfo.mapmarker.CHE.FRA.FRA_ScoringAddress;
import com.mapinfo.mapmarker.CHE.ITA.ITA_ScoringAddress;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.IScoringHelper;
import java.util.Locale;

public class CHE_ScoringHelper
implements IScoringHelper {
    private static StringScorer m_stringScorer;

    public Address makeParsedAddressCopy(Address pa) {
        return new AddressImpl(pa);
    }

    public StringScorer makeStringScorer() {
        return m_stringScorer;
    }

    public static void setStringScorer(StringScorer scorer) {
        m_stringScorer = scorer;
    }

    public char getFirstNormalCharacter(String s) {
        char c = Character.toUpperCase(s.charAt(0));
        return c;
    }

    public ScoringAddress makeScoringAddress(Address addr, IConstraints constraints, IHandler handler) {
        Address preparsedAddress = ((CHE_Handler)handler).getPreParsedAddress();
        EMEA_ScoringAddress scoringAddress = this.getScoringAddress(preparsedAddress, addr);
        scoringAddress.setStringScorer(this.makeStringScorer());
        scoringAddress.setCharsToIgnore(constraints.getHandler().getMatcherConstants().getStreetMatcherConstants().getCharsToIgnore());
        constraints.setHandler(handler);
        return scoringAddress;
    }

    public static String getCollationRules() {
        return CHE_AddressTerm.getScoringRules();
    }

    public static char getFirstNormChar(String s) {
        char c = Character.toUpperCase(s.charAt(0));
        return c;
    }

    private EMEA_ScoringAddress getScoringAddress(Address address, Address addr) {
        String language = (String)address.getAdditionalFields().get("highest_scoring_language");
        EMEA_ScoringAddress scoringAddress = null;
        if (language.equals("DEU")) {
            scoringAddress = new DEU_ScoringAddress(addr);
        } else if (language.equals("FRA")) {
            scoringAddress = new FRA_ScoringAddress(addr);
        } else if (language.equals("ITA")) {
            scoringAddress = new ITA_ScoringAddress(addr);
        }
        return scoringAddress;
    }

    static {
        CHE_ScoringHelper.setStringScorer(new StringScorer(true, new Locale("ch", "CH"), CHE_AddressTerm.getScoringRules().toUpperCase()));
    }
}

