/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_BrowseHelper;
import com.mapinfo.mapmarker.CHE.CHE_ConstraintsHelper;
import com.mapinfo.mapmarker.CHE.CHE_HandlerImpl;
import com.mapinfo.mapmarker.CHE.CHE_IntersectionHelper;
import com.mapinfo.mapmarker.CHE.CHE_MatcherConstants;
import com.mapinfo.mapmarker.CHE.CHE_ParsedInputAddressHelper;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.CHE_StreetGeocoder;
import com.mapinfo.mapmarker.CHE.browse.CHE_BrowseFilter;
import com.mapinfo.mapmarker.CHE.browse.CHE_BrowseGeocoder;
import com.mapinfo.mapmarker.CHE.custom.CHE_CustomGeocoder;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataManager;
import com.mapinfo.mapmarker.CHE.filters.CloserHouseFilterRule;
import com.mapinfo.mapmarker.CHE.filters.ComparePrefixFilterRule;
import com.mapinfo.mapmarker.CHE.filters.LocalityFilterRule;
import com.mapinfo.mapmarker.CHE.filters.MatchingHouseFilter;
import com.mapinfo.mapmarker.CHE.filters.NoInputPostcodeFilterRule;
import com.mapinfo.mapmarker.CHE.filters.PerfectCityFilterRule;
import com.mapinfo.mapmarker.CHE.filters.PerfectPostcodeFilterRule;
import com.mapinfo.mapmarker.CHE.filters.PerfectPreAddressFilterRule;
import com.mapinfo.mapmarker.CHE.filters.PerfectStreetFilterRule;
import com.mapinfo.mapmarker.CHE.filters.PreferHouseLevelMatchFilterRule;
import com.mapinfo.mapmarker.CHE.filters.StreetTypeFilterRule;
import com.mapinfo.mapmarker.CHE.matcher.CHE_MatchConstraintsConverter;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParseRuleHandler;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.EMEA.EMEA_ParseHandler;
import com.mapinfo.mapmarker.EMEA.parser.EMEA_Parser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IParsedInputAddressHelper;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.filters.DictionaryBonusCloseMatchFilterRule;
import com.mapinfo.mapmarker.common.filters.DictionaryUserPriorityCloseMatchFilter;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.common.filters.IntersectionDictionaryBonusCloseMatchFilterRule;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.FatalHandlerException;
import com.mapinfo.mapmarker.core.HandlerValidator;
import com.mapinfo.mapmarker.core.IParseHandler;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IIntersectionHelper;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseHelper;
import com.mapinfo.mapmarker.core.matcher.CoreMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchConstraintsConverter;
import com.mapinfo.mapmarker.core.matcher.IMatcher;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.HashMap;

public class CHE_SpecificHandler {
    private static final ExtendedCharacters germanextendedCharacters = new ExtendedCharacters("com/mapinfo/mapmarker/CHE/parser/DEUExtendedCharacters.properties");
    private static final ExtendedCharacters frenchextendedCharacters = new ExtendedCharacters("com/mapinfo/mapmarker/CHE/parser/FRAExtendedCharacters.properties");
    private static final ExtendedCharacters italianextendedCharacters = new ExtendedCharacters("com/mapinfo/mapmarker/CHE/parser/ITAExtendedCharacters.properties");
    private static GenericSoundex ITALIANSOUNDEX;
    private static GenericSoundex FRENCHSOUNDEX;
    private static GenericSoundex GERMANSOUNDEX;

    private static void testit() throws GeocodableAddressCreationException {
        AddressImpl addr = new AddressImpl();
        addr.setCountry("CHE");
        IHandler handler = CHE_SpecificHandler.buildHandler((Address)addr);
        try {
            HandlerValidator.validateHandler((IHandler)handler, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        catch (FatalHandlerException ex) {
            throw new GeocodableAddressCreationException(2500, (Throwable)ex);
        }
    }

    public static IHandler buildHandler(Address address) throws GeocodableAddressCreationException {
        CHE_HandlerImpl handler = null;
        try {
            CHE_PreParseHandler m_preParseHandler = new CHE_PreParseHandler();
            handler = new CHE_HandlerImpl();
            if (address.getGenericField4() != null && address.getGenericField4().length() != 0) {
                handler.setGeocodeTypeForParsing(Integer.parseInt(address.getGenericField4()));
                address.setGenericField4(null);
            }
            m_preParseHandler.preParse(address, handler);
            CHESwissSoundex soundex = CHESwissSoundex.getSoundexInstance();
            HashMap<String, GenericSoundex> soundexMap = new HashMap<String, GenericSoundex>();
            soundexMap.put("DEU", GERMANSOUNDEX);
            soundexMap.put("FRA", FRENCHSOUNDEX);
            soundexMap.put("ITA", ITALIANSOUNDEX);
            soundex.setSoundexMap(soundexMap);
            handler.setInputAddress(address);
            handler.setDataManager((IDataManager)new CHE_DataManager());
            handler.setMatcherConstants(new CHE_MatcherConstants());
            ((CoreHandler)handler).setParseHandler((IParseHandler)new EMEA_ParseHandler());
            handler.setCustomGeocoder(new CHE_CustomGeocoder());
            ((CoreHandler)handler).setGeocodeCustomSupported(true);
            handler.setLocalConstraintsHelper(new CHE_ConstraintsHelper());
            handler.setMatchConstraintsConverter((IMatchConstraintsConverter)new CHE_MatchConstraintsConverter());
            handler.setScoringHelper(new CHE_ScoringHelper());
            ((ICoreAddressGeocoder)handler).setStreetGeocoder((IStreetGeocoder)new CHE_StreetGeocoder(handler));
            ((CoreHandler)handler).setBrowseFilter((IBrowseFilter)new CHE_BrowseFilter());
            ((CoreHandler)handler).setBrowseHelper((IBrowseHelper)new CHE_BrowseHelper());
            ((CoreHandler)handler).setBrowseGeocoder((IBrowseGeocoder)new CHE_BrowseGeocoder());
            ((CoreHandler)handler).setIntersectionHelper((IIntersectionHelper)new CHE_IntersectionHelper());
            ((CoreHandler)handler).setParser((IParser)new EMEA_Parser());
            ((CoreHandler)handler).setPreParseHandler(handler.getPreParseHandler());
            handler.setMatcherHandler(handler.getMatcherHandler());
            CHE_ParseRuleHandler parse = new CHE_ParseRuleHandler(handler.getCountryCode());
            handler.setRuleHandler(parse);
            parse.addParsingRules(handler);
            handler.setParsedInputAddressHelper((IParsedInputAddressHelper)new CHE_ParsedInputAddressHelper());
            handler.setGeocodePostalSupported(true);
            handler.setGeocodeGeographicSupported(true);
            handler.setGeocodeSupported(true);
            handler.setBrowseSupported(true);
            ICloseMatchFilterRule[] candidateCloseMatchFilterRules = new ICloseMatchFilterRule[]{new StreetTypeFilterRule(), new PerfectCityFilterRule(), new PreferHouseLevelMatchFilterRule(), new CloserHouseFilterRule(), new PerfectPostcodeFilterRule(), new ComparePrefixFilterRule(), new PerfectStreetFilterRule(), new LocalityFilterRule(), new NoInputPostcodeFilterRule(), new MatchingHouseFilter(), new PerfectPreAddressFilterRule(), new DictionaryBonusCloseMatchFilterRule(), new DictionaryUserPriorityCloseMatchFilter()};
            ICloseMatchFilterRule[] intersectionCloseMatchFilterRules = new ICloseMatchFilterRule[]{new IntersectionDictionaryBonusCloseMatchFilterRule()};
            handler.setMatcher((IMatcher)new CoreMatcher(candidateCloseMatchFilterRules, intersectionCloseMatchFilterRules));
        }
        catch (MMJEDataManagerInitializationException e) {
            throw new GeocodableAddressCreationException(2306, (Throwable)e);
        }
        return handler;
    }

    static {
        GERMANSOUNDEX = new GenericSoundex("com/mapinfo/mapmarker/CHE/parser/DEUSoundex.properties", germanextendedCharacters);
        FRENCHSOUNDEX = new GenericSoundex("com/mapinfo/mapmarker/CHE/parser/FRASoundex.properties", frenchextendedCharacters);
        ITALIANSOUNDEX = new GenericSoundex("com/mapinfo/mapmarker/CHE/parser/ITASoundex.properties", italianextendedCharacters);
        try {
            CHE_SpecificHandler.testit();
        }
        catch (GeocodableAddressCreationException ex) {
            MMJLog.getLog().error("Unable to create CHE_SpecificHandler", (Throwable)ex);
        }
    }
}

