/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_Address;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.common.Address;

public final class CHE_UserCandidateAddress
extends CandidateAddress
implements CHE_Address {
    public static final String PRE_ADDR_COMMON = "pre_addr_common";

    public CHE_UserCandidateAddress(String country) {
        this.setCountry(country);
    }

    public CHE_UserCandidateAddress(Address address) {
        super(address);
        this.setCountry(address.getCountry());
    }

    CHE_UserCandidateAddress(String housenumber, String street, String town, String postcode, String province, String postaddress, String placeName, String country) {
        this.setCountry(country);
        this.setPostAddress(postaddress);
        this.setHouseNumber(housenumber);
        this.setTown(town);
        this.setPostcode(postcode);
        this.setStreet(street);
        this.setProvince(province);
        this.setPlaceName(placeName);
    }

    @Override
    public String getPostAddress() {
        return super.getPostAddress();
    }

    public String getPreAddress() {
        return super.getPreAddress();
    }

    @Override
    public String getHouseNumber() {
        return super.getAddressNumber();
    }

    @Override
    public String getTown() {
        return this.getAreaName3();
    }

    @Override
    public String getPostcode() {
        return this.getPostCode1();
    }

    @Override
    public String getStreet() {
        String postAddress;
        String postDirectional;
        String postTFareType;
        String mainAddress;
        String preAddress;
        String additionalFields;
        String preTFareType;
        if (this.getLocationPrecision() == 6) {
            return this.getMainAddress();
        }
        String formatedStreetAddress = this.getFormattedStreetAddress();
        if (formatedStreetAddress != null || formatedStreetAddress.length() != 0) {
            if (this.getAddressNumber() != null && this.getAddressNumber().length() > 0) {
                int index = formatedStreetAddress.lastIndexOf(this.getAddressNumber());
                if (index > 0) {
                    formatedStreetAddress = formatedStreetAddress.substring(0, index);
                } else {
                    index = formatedStreetAddress.indexOf(this.getAddressNumber());
                    if (index == 0) {
                        formatedStreetAddress = formatedStreetAddress.substring(this.getAddressNumber().length());
                    }
                }
            }
            return formatedStreetAddress;
        }
        StringBuffer tmpStreet = new StringBuffer(75);
        String preDirectional = this.getPreDirectional();
        if (preDirectional != null) {
            tmpStreet.append(preDirectional + " ");
        }
        if ((preTFareType = this.getPreThoroughfareType()) != null) {
            tmpStreet.append(preTFareType + " ");
        }
        if ((additionalFields = (String)this.getAdditionalFields().get("post_st_type_common")) != null) {
            tmpStreet.append(" " + additionalFields);
        }
        if ((preAddress = this.getPreAddress()) != null) {
            tmpStreet.append(preAddress);
            if (!preAddress.endsWith(" ")) {
                tmpStreet.append(" ");
            }
        }
        if ((mainAddress = this.getMainAddress()) != null) {
            tmpStreet.append(" " + mainAddress);
        }
        if ((postTFareType = this.getPostThoroughfareType()) != null) {
            tmpStreet.append(" " + postTFareType);
        }
        if ((postDirectional = this.getPostDirectional()) != null) {
            tmpStreet.append(" " + postDirectional);
        }
        if ((postAddress = this.getPostAddress()) != null) {
            tmpStreet.append(" " + postAddress);
        }
        return tmpStreet.toString();
    }

    @Override
    public String getProvince() {
        return this.getAreaName2();
    }

    @Override
    public String getLocality() {
        return this.getAreaName4();
    }

    @Override
    public String getRegion() {
        return this.getAreaName1();
    }

    @Override
    public String getPlaceName() {
        return super.getPlaceName();
    }

    public boolean doesHnrMatch() {
        return this.doesAddressNumberMatch();
    }

    public boolean doesPostcodeMatch() {
        return this.doesPostalCode1Match();
    }

    public boolean doesStreetMatch() {
        return this.doesStreetNameMatch();
    }

    public boolean doesTownMatch() {
        return this.doesAreaName3Match();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\nHouseNumber: " + this.getHouseNumber());
        buff.append("\nStreet: " + this.getStreet());
        buff.append("\nPostcode: " + this.getPostcode());
        buff.append("\nTown: " + this.getTown());
        buff.append("\nProvince: " + this.getProvince());
        buff.append("\nPostAddress: " + this.getPostAddress());
        buff.append("\nCountry: " + this.getCountry());
        if (this.getLocation() != null) {
            buff.append("\nCoordinates (" + this.getLocation().x + ", " + this.getLocation().y + ")");
        } else {
            buff.append("\nNo Coordinates Available");
        }
        return buff.toString();
    }

    @Override
    public void setTown(String town) {
        super.setAreaName3(town);
    }

    @Override
    public void setStreet(String street) {
        super.setMainAddress(street);
    }

    @Override
    public void setPostcode(String postcode) {
        super.setPostCode1(postcode);
    }

    @Override
    public void setHouseNumber(String housenumber) {
        super.setAddressNumber(housenumber);
    }

    @Override
    public void setProvince(String province) {
        super.setAreaName2(province);
    }

    @Override
    public void setRegion(String region) {
        super.setAreaName1(region);
    }
}

