/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU;

import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.CHE_StreetMultipleSegmentComparator;
import com.mapinfo.mapmarker.CHE.matcher.CHE_InternalMatchPreferences;
import com.mapinfo.mapmarker.CHE.matcher.CHE_MatcherUtils;
import com.mapinfo.mapmarker.EMEA.EMEA_MatcherHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;

public final class DEU_MatcherHandler
extends EMEA_MatcherHandler {
    public DEU_MatcherHandler() {
        this.setComparator(new CHE_StreetMultipleSegmentComparator());
    }

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants constants, ScoringAddress scoringAddress) throws MatcherException {
        if (candidate instanceof CHE_InternalCandidateAddress && ((CHE_InternalCandidateAddress)candidate).isAPCandidate() && !candidate.isHouseNumberFromPlaceMatch() && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && StringUtilities.isEmpty((String)candidate.getAddressNumber())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (((CHE_InternalMatchPreferences)preferences).areSacsLimited() && !CHE_MatcherUtils.acceptWithSacLimit((Address)scoringAddress, candidate)) {
            return;
        }
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode2() && candidate.getPostCode2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPostAddressScore() != 1.0 || candidate.getPreAddressScore() != 1.0 || candidate.getPreThoroughfareTypeScore() != 1.0 || candidate.getPostThoroughfareTypeScore() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() < constants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAdditionalFieldScore() < constants.getAdditionalFieldsCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        double maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        maximumAddressScore = this.fieldExists(parsedAddress.getPreThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPreThoroughfareType()) : (maximumAddressScore += blankConstants.getPreThoroughfareType());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreAddress()) ? (maximumAddressScore += matchedConstants.getPreAddress()) : (maximumAddressScore += blankConstants.getPreAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getMainAddress()) ? (maximumAddressScore += matchedConstants.getMainAddress()) : (maximumAddressScore += blankConstants.getMainAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostAddress()) ? (maximumAddressScore += matchedConstants.getPostAddress()) : (maximumAddressScore += blankConstants.getPostAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPostThoroughfareType()) : (maximumAddressScore += blankConstants.getPostThoroughfareType());
        this.setMaximumAddressScore(maximumAddressScore += matchedConstants.getAdditionalFields());
    }

    @Override
    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress parsedAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        candidate.computeScores(parsedAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = this.fieldExists(parsedAddress.getPreAddress()) || this.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress() * candidate.getPreAddressScore());
        score = this.fieldExists(parsedAddress.getMainAddress()) || this.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        score = this.fieldExists(parsedAddress.getPostAddress()) || this.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress() * candidate.getPostAddressScore());
        score = this.fieldExists(parsedAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType()) ? (score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore()) : (score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore());
        score = this.fieldExists(parsedAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType()) ? (score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore()) : (score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore());
        score = this.fieldExists(parsedAddress.getPlaceName()) || this.fieldExists(candidate.getPlaceName()) ? (score += matchedConstants.getPlaceName() * candidate.getPlaceNameScore()) : (score += blankConstants.getPlaceName() * candidate.getPlaceNameScore());
        candidate.setCombinedAddressScore((score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore()) / this.getMaximumAddressScore());
        score = 0.0;
        score = this.fieldExists(parsedAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = this.fieldExists(parsedAddress.getPostCode2()) ? (score += matchedConstants.getPostalCode2() * candidate.getPostCode2Score()) : (score += blankConstants.getPostalCode2() * candidate.getPostCode2Score());
        score = this.fieldExists(parsedAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = this.fieldExists(parsedAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = this.fieldExists(parsedAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = this.fieldExists(parsedAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        candidate.setCombinedAdditionalFieldScore(score / this.getMaximumAdditionalFieldScore());
        candidate.buildInputMatchScore((Address)parsedAddress, matchedConstants);
    }

    @Override
    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        if (!this.stringEquals(best.getPostCode1(), other.getPostCode1())) {
            return false;
        }
        if (!this.stringEquals(best.getAreaName3(), other.getAreaName3())) {
            return false;
        }
        if (!this.stringEquals(best.getAreaName4(), other.getAreaName4())) {
            return false;
        }
        return best.getPlaceNameScore() == other.getPlaceNameScore();
    }

    private boolean stringEquals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equalsIgnoreCase(string2);
    }
}

