/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU.parser;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DEU_AddressTerm {
    private static final String KEY_COMMON_WORDS = "common-words";
    private static final String KEY_IGNORE_WORDS = "ignore-words";
    private static final String KEY_DIRECTIONALS = "directionals";
    private static final String ROMAN_NUMERAL_WORDS = "roman_numeral_words";
    private static Vector ignoreWords = null;
    private static Vector directionals = null;
    private static char[] PUNCTUATION_CHARS = new char[]{'-', '_', '/', '\\', ',', '\"'};
    private static char[] romanNumberChars = new char[]{'X', 'V', 'I', ' '};
    private static StringBuffer punctuationList = null;
    private static final String VALID_NUMERALS = "IVXLCDM";
    private static final long[] CORRESPONDING_VALUES = new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L};
    private static HashMap romanNumeralWordList = null;
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String CHARACTERS_TO_KEEP_KEY = "characters_to_keep";
    private static List m_charactersToKeep;

    public static boolean isIgnoreWord(String word) {
        if (word == null) {
            return false;
        }
        return ignoreWords != null && ignoreWords.contains(word.toUpperCase().trim());
    }

    public static boolean isCommonWord(String word) {
        boolean result = false;
        if (CHE_AddressTerm.m_commonTermList != null && CHE_AddressTerm.m_commonTermList.contains(word.toUpperCase())) {
            result = true;
        }
        return result;
    }

    public static boolean isDirectional(String word) {
        if (word == null || word.trim().length() == 0 || directionals == null) {
            return false;
        }
        return directionals.contains(word.trim().toUpperCase());
    }

    public static String[] removeCommonWords(String str) {
        if (CHE_AddressTerm.m_commonTermList == null || str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer commonBuf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, ".- ");
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (!CHE_AddressTerm.m_commonTermList.contains(word.toUpperCase())) {
                buf.append(word);
                buf.append(' ');
                continue;
            }
            commonBuf.append(word);
            commonBuf.append(' ');
        }
        String[] ret = new String[2];
        String str1 = buf.toString().trim();
        ret[0] = str1.length() > 0 ? str1 : null;
        str1 = commonBuf.toString().trim();
        ret[1] = str1.length() > 0 ? str1 : null;
        return ret;
    }

    public static String removePunctuationChars(String inTerm) {
        StringBuffer tempString = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(inTerm, String.valueOf(PUNCTUATION_CHARS));
        while (tokens.hasMoreElements()) {
            tempString.append(tokens.nextElement());
            tempString.append(' ');
        }
        return tempString.toString().trim();
    }

    private static void loadRomanNumeralWords(String key, String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (romanNumeralWordList == null) {
            romanNumeralWordList = new HashMap();
        }
        romanNumeralWordList.put(key.substring(ROMAN_NUMERAL_WORDS.length()), raw);
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        int index = term.trim().lastIndexOf(".");
        if (index > 0) {
            term = term.substring(0, index - 1);
        }
        term = term.toUpperCase();
        char[] termChars = term.toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            int j;
            for (j = 0; j < romanNumberChars.length && termChars[i] != romanNumberChars[j]; ++j) {
            }
            if (j != romanNumberChars.length) continue;
            return false;
        }
        return true;
    }

    public static long convertRomanToLong(String romanNumerals) {
        long sum = 0L;
        long oldV = 0L;
        if (romanNumerals.equals("1")) {
            sum = 1L;
        } else {
            for (int k = romanNumerals.length() - 1; k >= 0; --k) {
                char c = romanNumerals.charAt(k);
                int pos = VALID_NUMERALS.indexOf(Character.toUpperCase(c));
                if (pos < 0) continue;
                long newV = CORRESPONDING_VALUES[pos];
                if (newV < oldV) {
                    newV = -newV;
                }
                sum += newV;
                oldV = newV;
            }
        }
        return sum;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isPunctuation(String term) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(term) > -1;
    }

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (punctuationList == null) {
                punctuationList = new StringBuffer(raw.length());
            }
            punctuationList.append(raw);
        }
    }

    public static boolean isPunctuation(char ch) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(ch) > -1;
    }

    public static String isromanWord(String word) {
        if (romanNumeralWordList == null || word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)romanNumeralWordList.get(word);
    }

    public static String getCharactersToKeep() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < m_charactersToKeep.size(); ++i) {
            buffer.append(m_charactersToKeep.get(i));
        }
        return buffer.toString();
    }

    static {
        try {
            Properties prop = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/DEU/parser/DEU_AddressTerms.properties");
            ignoreWords = new Vector();
            directionals = new Vector();
            m_charactersToKeep = new ArrayList();
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String word;
                StringTokenizer st;
                String value;
                String key = (String)e.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    DEU_AddressTerm.loadPunctuations(prop.getProperty(key));
                }
                if (key.startsWith(KEY_COMMON_WORDS)) continue;
                if (key.startsWith(KEY_IGNORE_WORDS)) {
                    value = (String)prop.get(key);
                    st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        word = st.nextToken().toUpperCase().trim();
                        ignoreWords.add(word);
                    }
                    continue;
                }
                if (key.startsWith(KEY_DIRECTIONALS)) {
                    value = (String)prop.get(key);
                    st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        word = st.nextToken().toUpperCase().trim();
                        directionals.add(word);
                    }
                    continue;
                }
                if (key.startsWith(ROMAN_NUMERAL_WORDS)) {
                    DEU_AddressTerm.loadRomanNumeralWords(key, prop.getProperty(key));
                    continue;
                }
                if (!key.startsWith(CHARACTERS_TO_KEEP_KEY)) continue;
                value = (String)prop.get(key);
                m_charactersToKeep.add(value);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
    }
}

