/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU.parser;

import com.mapinfo.mapmarker.CHE.DEU.DEU_LocaliserProperties;
import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DEU_ParsePostAddressRule
implements IParseRule {
    private static final String m_punctuations = " ()-/.\"',\\";
    private final String POST_CODE_INVALID = "Post Code supplied is alphanumeric or has an invalid number of digits";
    private final String[] REGION_CODES = DEU_LocaliserProperties.getPostCodePrefixes();

    public void parse(Address inputAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        if (inputAddress == null) {
            throw new ParserException(2000);
        }
        if (parsedAddress == null) {
            throw new ParserException(2001);
        }
        String postCode1 = parsedAddress.getPostCode1();
        String areaName3 = parsedAddress.getAreaName3();
        if (postCode1 != null && postCode1.trim().length() != 0 && areaName3 != null && areaName3.trim().length() != 0) {
            if (!this.parsePostalFields(postCode1.trim(), areaName3.trim(), parsedAddress)) {
                throw new ParserException(2008, new Object[]{"Post Code supplied is alphanumeric or has an invalid number of digits"});
            }
        } else {
            LinkedList listOfTokens;
            StringTokenizer tokens;
            String postAddress = parsedAddress.getPostAddress();
            postAddress = this.replaceTabsWithSpaces(postAddress);
            if ((postAddress = this.stripRegionFromZip(postAddress)) != null && postAddress.trim().length() != 0) {
                tokens = new StringTokenizer(postAddress, " ,");
                if (tokens.countTokens() == 0) {
                    return;
                }
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                if (listOfTokens == null || listOfTokens.size() < 1) {
                    return;
                }
                int tokenCount = listOfTokens.size();
                if (tokenCount == 1) {
                    String token = (String)listOfTokens.getFirst();
                    token = this.removeCountryCode(token);
                    if (postAddress.length() > 2 && StringUtilities.isNumeric((String)token)) {
                        parsedAddress.setPostCode1(token);
                    } else if (!StringUtilities.hasNumeric((String)token)) {
                        parsedAddress.setAreaName3(token.trim());
                    }
                } else {
                    int i;
                    String postCode = (String)listOfTokens.getFirst();
                    StringBuffer city = new StringBuffer();
                    for (int i2 = 1; i2 < listOfTokens.size(); ++i2) {
                        city.append((String)listOfTokens.get(i2) + " ");
                    }
                    boolean bSwap = false;
                    if (!this.parsePostalFields(postCode, city.toString(), parsedAddress) || parsedAddress.getPostCode1() == null) {
                        bSwap = true;
                    }
                    boolean notParsed = false;
                    if (bSwap) {
                        postCode = (String)listOfTokens.getLast();
                        city = null;
                        city = new StringBuffer();
                        for (i = 0; i < listOfTokens.size() - 1; ++i) {
                            city.append((String)listOfTokens.get(i) + " ");
                        }
                        if (!this.parsePostalFields(postCode, city.toString(), parsedAddress) || parsedAddress.getPostCode1() == null) {
                            notParsed = true;
                        }
                    }
                    if (notParsed) {
                        postCode = (String)listOfTokens.get(0);
                        if (StringUtilities.hasNumeric((String)postCode)) {
                            // empty if block
                        }
                        if (StringUtilities.hasNumeric((String)(postCode = (String)listOfTokens.get(listOfTokens.size() - 1)))) {
                            // empty if block
                        }
                        postCode = null;
                        city = null;
                        city = new StringBuffer();
                        for (i = 0; i < listOfTokens.size(); ++i) {
                            city.append((String)listOfTokens.get(i) + " ");
                        }
                        if (!this.parsePostalFields(postCode, city.toString(), parsedAddress)) {
                            // empty if block
                        }
                    }
                }
            }
            if (areaName3 != null && areaName3.trim().length() != 0) {
                tokens = new StringTokenizer(areaName3, m_punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                areaName3 = this.concatanateList(listOfTokens);
                this.parseCity(areaName3.trim(), parsedAddress);
            }
            if (postCode1 != null && postCode1.trim().length() != 0) {
                tokens = new StringTokenizer(postCode1, m_punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                String pc = this.stripRegionFromZip((postCode1 = this.concatanateList(listOfTokens)).trim());
                if (this.isPostalCode(pc)) {
                    parsedAddress.setPostCode1(pc);
                } else if (parsedAddress.getAreaName3() == null) {
                    return;
                }
            }
            if (!(parsedAddress.getPostCode1() != null && parsedAddress.getPostCode1().trim().length() != 0 || parsedAddress.getAreaName3() != null && parsedAddress.getAreaName3().trim().length() != 0)) {
                throw new ParserException(2000);
            }
        }
    }

    private void parseCity(String city, Address pa) {
        int slashIdx = city.indexOf("/");
        if (slashIdx != -1) {
            city = city.substring(0, slashIdx);
        }
        if (!StringUtilities.hasNumeric((String)city)) {
            pa.setAreaName3(city);
        }
    }

    private String stripRegionFromZip(String zip) {
        if (zip == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(zip, " -/.,", true);
        int count = this.REGION_CODES.length;
        StringBuffer outBuf = new StringBuffer(zip.length());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean tokenIsRegionCode = false;
            for (int i = 0; i < count; ++i) {
                if (!token.equalsIgnoreCase(this.REGION_CODES[i])) continue;
                tokenIsRegionCode = true;
                break;
            }
            if (tokenIsRegionCode) continue;
            outBuf.append(token);
        }
        String delimiters = " -/.,()";
        while (outBuf.length() > 0 && delimiters.indexOf(outBuf.charAt(0)) != -1) {
            outBuf.deleteCharAt(0);
        }
        while (outBuf.length() > 0 && delimiters.indexOf(outBuf.charAt(outBuf.length() - 1)) != -1) {
            outBuf.deleteCharAt(outBuf.length() - 1);
        }
        return outBuf.toString();
    }

    private boolean isPostalCode(String pc) {
        return pc != null && pc.length() > 2 && StringUtilities.isNumeric((String)pc);
    }

    public String replaceTabsWithSpaces(String term) {
        if (term == null) {
            return null;
        }
        if (term.trim().equals("")) {
            return term;
        }
        StringBuffer newTerm = new StringBuffer();
        for (int i = 0; i < term.length(); ++i) {
            char c = term.charAt(i);
            if (c == '\t') {
                newTerm.append(' ');
                continue;
            }
            newTerm.append(c);
        }
        return newTerm == null ? null : newTerm.toString();
    }

    public static String removeCommonWords(String str) {
        String[] strArray = DEU_AddressTerm.removeCommonWords(str);
        if (strArray != null && strArray[0] != null) {
            return strArray[0];
        }
        return str;
    }

    public String removeCountryCode(String input) {
        String newPostCode;
        if (input == null || input.trim().length() < 6 || input.trim().length() > 6) {
            return input;
        }
        if (StringUtilities.isNumeric((String)input)) {
            return input;
        }
        if (input.substring(0, 1).equals("D") && StringUtilities.isNumeric((String)(newPostCode = input.substring(1)))) {
            return newPostCode;
        }
        return input;
    }

    protected boolean parsePostalFields(String postCode, String city, Address pa) {
        StringTokenizer tokens;
        if (city != null && city.trim().length() > 0) {
            tokens = new StringTokenizer(city, m_punctuations, true);
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            city = this.concatanateList(listOfTokens);
            this.parseCity(city, pa);
        }
        boolean foundCity = false;
        if (pa.getAreaName3() != null) {
            foundCity = true;
        }
        if (postCode != null && postCode.trim().length() > 0) {
            tokens = new StringTokenizer(postCode, m_punctuations, true);
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            postCode = this.concatanateList(listOfTokens);
            postCode = this.stripRegionFromZip(postCode);
            if (StringUtilities.isNumeric((String)(postCode = postCode.trim())) && postCode.length() > 2) {
                pa.setPostCode1(postCode);
            } else if (!foundCity) {
                return false;
            }
        }
        return foundCity;
    }

    private String concatanateList(LinkedList listOfTokens) {
        String term;
        while (listOfTokens.size() > 0 && DEU_AddressTerm.isPunctuation(term = (String)listOfTokens.getFirst())) {
            listOfTokens.removeFirst();
        }
        while (listOfTokens.size() > 0 && DEU_AddressTerm.isPunctuation(term = (String)listOfTokens.getLast())) {
            listOfTokens.removeLast();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < listOfTokens.size(); ++i) {
            buf.append(listOfTokens.get(i));
        }
        return buf.toString();
    }
}

