/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class DEU_ThoroughfareTypes {
    private final int TYPE_FOUND_UNKNOWN = 0;
    private final int TYPE_FOUND_START = 1;
    private final int TYPE_FOUND_END = 2;
    private static Properties m_streetTypes = null;
    private static HashMap m_preferKeys = new HashMap();
    private static String[] m_sortedStreetTypes = null;
    private boolean m_preChar = false;
    private boolean m_postChar = false;
    private String m_sepChar;
    private int m_typeFound = 0;
    private String m_type = "";
    private int m_location = -1;
    private char[] m_tfareChars = new char[]{' ', '.', '_', '-'};
    private static HashMap m_keys = new HashMap();

    public boolean hasPreSeparator() {
        return this.m_preChar;
    }

    public boolean hasPostSeparator() {
        return this.m_postChar;
    }

    public String getSeparatorChar() {
        return this.m_sepChar;
    }

    public boolean foundAtStart() {
        return this.m_typeFound == 1;
    }

    public boolean foundAtEnd() {
        return this.m_typeFound == 2;
    }

    public String getTypeName() {
        return this.m_type;
    }

    public int getTypeNameLocation() {
        return this.m_location;
    }

    public boolean findStreetType(String mainAddr) {
        String newMainAddr;
        boolean rc = false;
        boolean prevRc = false;
        if (mainAddr == null || mainAddr.trim().length() == 0) {
            return false;
        }
        String savedMainAddr = newMainAddr = mainAddr.trim();
        newMainAddr = savedMainAddr.replace(' ', '-');
        if (m_sortedStreetTypes == null) {
            return rc;
        }
        int numberOfTypes = m_sortedStreetTypes.length;
        for (int i = 0; i < numberOfTypes; ++i) {
            if (rc) {
                return rc;
            }
            String type = m_sortedStreetTypes[i];
            boolean keepLooking = true;
            int searchOffset = 0;
            while (keepLooking) {
                keepLooking = false;
                int idx = this.indexOfIgnoreCase(searchOffset, newMainAddr, type);
                if (idx == -1 || idx == 0 && prevRc) continue;
                if (type.toUpperCase().length() == newMainAddr.toUpperCase().length()) {
                    return false;
                }
                KeyInfo keyInfo = DEU_ThoroughfareTypes.getKeyInfo(type);
                if (keyInfo != null) {
                    String s;
                    if (idx == 0 && keyInfo.canStart()) {
                        this.m_typeFound = 1;
                        this.m_type = type;
                        if (this.m_type.compareToIgnoreCase(newMainAddr) != 0 && StringUtilities.isSpecialChar((char)(s = savedMainAddr.substring(this.m_type.length(), this.m_type.length() + 1)).charAt(0), (char[])this.m_tfareChars)) {
                            this.m_postChar = true;
                            this.m_sepChar = s;
                        }
                        prevRc = true;
                        this.m_location = idx;
                    } else if (idx == 0) {
                        searchOffset = idx + 1;
                        keepLooking = true;
                    }
                    if (idx > 0 && idx + type.length() == newMainAddr.length() && keyInfo.canEnd()) {
                        this.m_typeFound = 2;
                        this.m_type = type;
                        s = savedMainAddr.substring(idx - 1, idx);
                        if (StringUtilities.isSpecialChar((char)s.charAt(0), (char[])this.m_tfareChars)) {
                            this.m_preChar = true;
                            this.m_sepChar = s;
                        }
                        rc = true;
                        this.m_location = idx;
                    } else if (idx <= 0 || idx + type.length() != newMainAddr.length()) {
                        searchOffset = idx + 1;
                        keepLooking = true;
                    }
                }
                keyInfo = null;
            }
        }
        return prevRc ? prevRc : rc;
    }

    public String getPreferredTypeName() {
        String ptn = "";
        if (this.m_type.trim().length() > 0) {
            KeyInfo k = new KeyInfo();
            k.loadKey(m_streetTypes, this.getTypeName());
            ptn = k.getPreferredTypeName();
        }
        return ptn;
    }

    public static String getPreferredTypeName(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        String str = word.trim();
        str = str.replace(' ', '-');
        for (String type : m_sortedStreetTypes) {
            KeyInfo keyInfo;
            if (!str.equalsIgnoreCase(type) || (keyInfo = DEU_ThoroughfareTypes.getKeyInfo(type.toUpperCase())) == null) continue;
            return keyInfo.getPreferredTypeName();
        }
        return null;
    }

    private static KeyInfo getKeyInfo(String key) {
        Object o = m_keys.get(key);
        if (o != null) {
            return (KeyInfo)o;
        }
        return null;
    }

    private int indexOfIgnoreCase(int start, String source, String find) {
        int rc = -1;
        if (find.length() <= source.length()) {
            char[] src = source.toCharArray();
            char[] fnd = find.toCharArray();
            int srcLen = src.length;
            int fndLen = fnd.length;
            char f = Character.toUpperCase(fnd[0]);
            int idx = -1;
            for (int i = start; i < srcLen; ++i) {
                char s = Character.toUpperCase(src[i]);
                if (s != f) continue;
                idx = i;
                if (source.substring(idx).length() < fndLen) {
                    return -1;
                }
                if (!this.equalIgnoreCase(source.substring(idx, idx + fndLen).toCharArray(), find.toCharArray())) continue;
                return idx;
            }
        }
        return rc;
    }

    private boolean equalIgnoreCase(char[] src, char[] fnd) {
        int len = src.length;
        if (len != fnd.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char s = src[i];
            char f = fnd[i];
            if (Character.toUpperCase(s) == Character.toUpperCase(f)) continue;
            return false;
        }
        return true;
    }

    private static String[] getSortedStreetTypes() throws IOException {
        int numberOfKeys = m_keys.size();
        if (m_keys == null || numberOfKeys == 0) {
            return null;
        }
        String[] keyTypes = new String[numberOfKeys];
        int i = 0;
        Enumeration<?> e = m_streetTypes.propertyNames();
        while (e.hasMoreElements()) {
            String type;
            keyTypes[i] = type = (String)e.nextElement();
            ++i;
        }
        for (i = 0; i < numberOfKeys - 1; ++i) {
            for (int j = i + 1; j < numberOfKeys; ++j) {
                if (keyTypes[i].trim().length() >= keyTypes[j].trim().length()) continue;
                String temp = new String(keyTypes[i]);
                keyTypes[i] = keyTypes[j];
                keyTypes[j] = temp;
            }
        }
        return keyTypes;
    }

    public static String lookupProperName(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        return (String)m_preferKeys.get(key);
    }

    public static String lookupPreferredName(String key) {
        if (key == null) {
            return null;
        }
        Object o = m_keys.get(key);
        if (o != null) {
            return ((KeyInfo)o).getPreferredTypeName();
        }
        return null;
    }

    public static boolean isStreetType(String word) {
        if (word == null || word.trim().length() == 0) {
            return false;
        }
        String str = word.trim();
        str = str.replace(' ', '-');
        for (String type : m_sortedStreetTypes) {
            if (!str.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            if (m_streetTypes == null) {
                m_streetTypes = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/DEU/parser/DEU_ThoroughfareTypes.properties");
                Enumeration<?> e = m_streetTypes.propertyNames();
                while (e.hasMoreElements()) {
                    KeyInfo key = new KeyInfo();
                    String type = (String)e.nextElement();
                    key.loadKey(m_streetTypes, type);
                    m_keys.put(type, key);
                }
                m_sortedStreetTypes = DEU_ThoroughfareTypes.getSortedStreetTypes();
            }
        }
        catch (Throwable T) {
            T.printStackTrace();
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
    }

    static class KeyInfo {
        private String m_type = "";
        private String m_preferredType = "";
        private String m_properName = "";
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        KeyInfo() {
        }

        public String getTypeName() {
            return this.m_type;
        }

        public String getPreferredTypeName() {
            return this.m_preferredType;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }

        public void loadKey(Properties p, String k) {
            String val = p.getProperty(k);
            StringTokenizer tokens = new StringTokenizer(val, ",");
            this.m_preferredType = tokens.nextToken();
            this.m_properName = tokens.nextToken();
            m_preferKeys.put(this.m_preferredType, this.m_properName);
            this.m_canStart = tokens.nextToken().compareToIgnoreCase("TRUE") == 0;
            this.m_canEnd = tokens.nextToken().compareToIgnoreCase("TRUE") == 0;
        }
    }
}

