/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class FRA_LocaliserProperties {
    private static final String FRA_LOCALISER_NUMBER_HNRS_CODES = "NUMBER_HNRS_CODES";
    private static final String FRA_LOCALISER_POSTCODE_LENGTH = "POSTCODE_LENGTH";
    private static final String FRA_LOCALISER_POSTCODE_COUNTRY_PREFIXES = "POSTCODE_COUNTRY_PREFIXES";
    private static Properties properties = null;

    public static int getNumberHNRSCodes() {
        String numberCodes = properties.getProperty(FRA_LOCALISER_NUMBER_HNRS_CODES);
        int result = 0;
        try {
            result = Integer.parseInt(numberCodes);
        }
        catch (NumberFormatException x) {
            System.err.println("FRA_LOCALISER_NUMBER_HNRS_CODES is not a valid number in FRA_LocaliserProperties.properties");
            x.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    public static int getPostCodeLength() {
        String postCodeLength = properties.getProperty(FRA_LOCALISER_POSTCODE_LENGTH);
        int result = 0;
        try {
            result = Integer.parseInt(postCodeLength);
        }
        catch (NumberFormatException x) {
            System.err.println("FRA_LOCALISER_POSTCODE_LENGTH is not a valid number in FRA_LocaliserProperties.properties");
            x.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    public static String[] getPostCodePrefixes() {
        String prefixString = properties.getProperty(FRA_LOCALISER_POSTCODE_COUNTRY_PREFIXES);
        if (prefixString == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prefixString, ",");
        while (tokens.hasMoreTokens()) {
            v.add(tokens.nextToken());
        }
        Object[] prefixes = new String[v.size()];
        v.copyInto(prefixes);
        return prefixes;
    }

    static {
        try {
            properties = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/CHE_LocaliserProperties.properties");
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load CHE_LocaliserProperties.properties");
        }
    }
}

