/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA;

import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressTerm;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_NumberTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FRA_ScoringAddress
extends EMEA_ScoringAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "pre_main_address_common";
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    private boolean scorePostAddress = true;
    private static double minScoreConsidered = 0.85;
    private Map m_cacheMap = new HashMap();

    public FRA_ScoringAddress(Address addr) {
        super(addr);
    }

    public double scorePostAddress(String parsedAddress) {
        double highScore = 0.0;
        if (this.scorePostAddress) {
            double score = 0.0;
            String parsedPostAddr = parsedAddress;
            String candPostAddr = this.getPostAddress();
            highScore = this.scoreItems(parsedPostAddr, candPostAddr);
            if (highScore < 1.0) {
                if (parsedPostAddr == null && candPostAddr != null) {
                    parsedPostAddr = (String)this.getAdditionalFields().get("post_addr_common");
                } else if (parsedPostAddr != null && candPostAddr == null) {
                    candPostAddr = (String)this.getAdditionalFields().get("post_addr_common");
                }
                if (parsedPostAddr != null && candPostAddr != null) {
                    String newParsedPostAddr;
                    if (FRA_AddressTerm.isRomanNumber(candPostAddr)) {
                        String newCandPostAddr = FRA_NumberTerm.lookupNumber(candPostAddr);
                        if (newCandPostAddr != null && (score = this.scoreItems(parsedPostAddr, newCandPostAddr)) > highScore && score > minScoreConsidered) {
                            highScore = score;
                        }
                    } else if (FRA_AddressTerm.isRomanNumber(parsedPostAddr) && (newParsedPostAddr = FRA_NumberTerm.lookupNumber(parsedPostAddr)) != null && (score = this.scoreItems(newParsedPostAddr, candPostAddr)) > highScore && score > minScoreConsidered) {
                        highScore = score;
                    }
                }
            }
        } else {
            highScore = 1.0;
        }
        return highScore;
    }

    public double scorePreAddress(StreetCandidateAddress parsedAddress) {
        boolean parsedHasPreAddr;
        String parsedPreAddr = this.getPreAddress();
        String candPreAddr = parsedAddress.getPreAddress();
        double bestscore = this.scoreItems(parsedPreAddr, candPreAddr);
        boolean candHasPreAddr = candPreAddr != null && candPreAddr.length() > 0;
        boolean bl = parsedHasPreAddr = parsedPreAddr != null && parsedPreAddr.length() > 0;
        if (bestscore != 1.0 && candHasPreAddr && parsedHasPreAddr) {
            double score;
            boolean checkAgain = false;
            if (parsedPreAddr.indexOf(45) > -1) {
                parsedPreAddr = FRA_AddressTerm.replaceChars(parsedPreAddr, new char[]{'-'}, ' ');
                checkAgain = true;
            }
            if (candPreAddr.indexOf(45) > -1) {
                candPreAddr = FRA_AddressTerm.replaceChars(candPreAddr, new char[]{'-'}, ' ');
                checkAgain = true;
            }
            if (checkAgain && (score = this.scoreItems(parsedPreAddr, candPreAddr)) > bestscore && score > minScoreConsidered) {
                bestscore = score;
            }
        }
        if (bestscore != 1.0 && candHasPreAddr != parsedHasPreAddr) {
            boolean parsedHasPostAddr;
            String candPostAddr = parsedAddress.getPostAddress();
            String parsedPostAddr = this.getPostAddress();
            boolean candHasPostAddr = candPostAddr != null && candPostAddr.length() > 0;
            boolean bl2 = parsedHasPostAddr = parsedPostAddr != null && parsedPostAddr.length() > 0;
            if (candHasPostAddr != parsedHasPostAddr) {
                if (candHasPreAddr && parsedHasPostAddr) {
                    double score = this.scoreItems(parsedPostAddr, candPreAddr);
                    if (score > minScoreConsidered) {
                        bestscore = score;
                        this.scorePostAddress = false;
                        parsedAddress.setPostAddressScore(1.0);
                        return bestscore;
                    }
                } else {
                    bestscore = this.scoreItems(parsedPreAddr, candPostAddr);
                }
            } else {
                bestscore = candHasPreAddr ? 0.6 : 0.4;
            }
        }
        if (bestscore != 1.0) {
            String str1 = (String)this.getAdditionalFields().get(PRE_ADDR_COMMON);
            String str2 = candPreAddr;
            double score = 0.0;
            if (str1 != null && str2 != null) {
                score = this.scoreItems(str1, str2);
                if (score != 1.0 && parsedPreAddr == null) {
                    StringTokenizer st = new StringTokenizer(str1);
                    StringTokenizer st1 = new StringTokenizer(str2);
                    if (st1.hasMoreTokens()) {
                        str2 = st1.nextToken();
                    }
                    int tokens = 0;
                    while (st.hasMoreTokens()) {
                        str1 = st.nextToken();
                        ++tokens;
                        if (str1.charAt(0) != str2.charAt(0)) continue;
                        if (str1.length() == 1) {
                            if (!st1.hasMoreTokens()) break;
                            str2 = st1.nextToken();
                            continue;
                        }
                        if (!str1.endsWith(".")) continue;
                        if (str1.length() == 2 && str1.charAt(0) == str2.charAt(0)) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) continue;
                            str2 = st1.nextToken();
                            continue;
                        }
                        score += 0.5 * this.scoreItems(str1, str2);
                        if (!st1.hasMoreTokens()) continue;
                        str2 = st1.nextToken();
                    }
                    if (tokens > 0) {
                        score /= (double)tokens;
                    }
                }
                if (bestscore < score && score > minScoreConsidered) {
                    bestscore = score;
                }
            } else {
                score = 0.0;
                str1 = parsedPreAddr;
                str2 = (String)this.getAdditionalFields().get(PRE_ADDR_COMMON);
                if (str1 != null && str2 != null && (score = this.scoreItems(str1, str2)) != 1.0 && this.getPreAddress() == null) {
                    StringTokenizer st = new StringTokenizer(str1);
                    StringTokenizer st1 = new StringTokenizer(str2);
                    if (st1.hasMoreTokens()) {
                        str2 = st1.nextToken();
                    }
                    int tokens = 0;
                    score = 0.0;
                    while (st.hasMoreTokens()) {
                        str1 = st.nextToken();
                        ++tokens;
                        if (str1.charAt(0) != str2.charAt(0)) continue;
                        if (str1.length() == 1) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) break;
                            str2 = st.nextToken();
                            continue;
                        }
                        if (!str1.endsWith(".")) continue;
                        if (str1.length() == 2 && str1.charAt(0) == str2.charAt(0)) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) break;
                            str2 = st1.nextToken();
                            continue;
                        }
                        score += 0.5 * this.scoreItems(str1, str2);
                        if (!st1.hasMoreTokens()) continue;
                        str2 = st1.nextToken();
                    }
                    if (tokens > 0) {
                        score /= (double)tokens;
                    }
                }
            }
            if (bestscore < score && score > minScoreConsidered) {
                bestscore = score;
            }
        }
        return bestscore;
    }

    public double getPreThoroughfareTypeScore(String candPreThroughfaretype) {
        return this.getStringScorer().scoreString(this.getPreThoroughfareType(), candPreThroughfaretype);
    }

    public double getPostThoroughfareTypeScore(String candPostThroughfaretype) {
        return this.getStringScorer().scoreString(this.getPostThoroughfareType(), candPostThroughfaretype);
    }

    @Override
    public double scoreItems(String str1, String str2) {
        return this.doScore(str1, str2, this.m_cacheMap, false);
    }

    @Override
    protected double doScore(String str1, String str2, Map cache, boolean bNoShortWordBonus) {
        if (str1 == null) {
            if (str2 == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (str2 == null) {
            return 0.0;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0;
        }
        String temScoringStrinng = str1 + " " + str2;
        if (!this.m_cacheMap.containsKey(temScoringStrinng)) {
            String charsToIgnore = this.getCharsToIgnore();
            if (charsToIgnore != null && charsToIgnore.length() != 0) {
                str1 = StringUtilities.stripString((String)str1, (String)charsToIgnore);
                str2 = StringUtilities.stripString((String)str2, (String)charsToIgnore);
            }
            double score = this.getStringScorer().scoreString(str1, str2, bNoShortWordBonus);
            score = this.scoreExtensions(score, str1, str2, bNoShortWordBonus);
            this.m_cacheMap.put(temScoringStrinng, String.valueOf(score));
            return score;
        }
        return Double.parseDouble((String)this.m_cacheMap.get(temScoringStrinng));
    }
}

