/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressTerm;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FRA_Abbreviations {
    private static Properties m_words = null;
    private static Properties m_abbr = null;
    private static HashMap m_multiWordAbbreviations = null;

    public static List getWordsForAbbreviation(String abbr) {
        if (m_abbr == null || abbr == null || abbr.equals("")) {
            return null;
        }
        String ret = m_abbr.getProperty(abbr.toLowerCase());
        if (ret == null || ret.equals("")) {
            return null;
        }
        StringTokenizer tokeniser = new StringTokenizer(ret, ",");
        String temp = null;
        ArrayList<String> list = null;
        while (tokeniser.hasMoreElements()) {
            if (list == null) {
                list = new ArrayList<String>(3);
            }
            temp = (String)tokeniser.nextElement();
            list.add(temp);
        }
        return list;
    }

    public static List getAbbreviationsForWord(String word) {
        if (m_words == null || word == null || word.equals("")) {
            return null;
        }
        String ret = m_words.getProperty(word.toLowerCase());
        if (ret == null || ret.equals("")) {
            return null;
        }
        StringTokenizer tokeniser = new StringTokenizer(ret, ",");
        ArrayList<String> list = null;
        String temp = null;
        while (tokeniser.hasMoreElements()) {
            if (list == null) {
                list = new ArrayList<String>(3);
            }
            temp = (String)tokeniser.nextElement();
            list.add(temp);
        }
        return list;
    }

    public static String expandAbbreviations(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(name, "-_ ", true);
        StringBuffer buf = new StringBuffer(name.length() + 10);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            char ch = str.charAt(0);
            if (ch == '-' || ch == '_' || ch == ' ') {
                buf.append(ch);
                continue;
            }
            List list = FRA_Abbreviations.getAbbreviationsForWord(str);
            list = list != null ? FRA_Abbreviations.getWordsForAbbreviation((String)list.get(0)) : FRA_Abbreviations.getWordsForAbbreviation(str);
            if (list != null) {
                buf.append(list.get(0));
                continue;
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static String expandMultiWordAbbreviations(String name) {
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(name, FRA_AddressTerm.getPunctuationsAsString(), true));
        boolean expanded = FRA_Abbreviations.expandMultiWordAbbreviations(listOfTokens, true);
        if (expanded) {
            int listSize = listOfTokens.size();
            StringBuffer buf = new StringBuffer(name.length() + 20);
            for (int i = 0; i < listSize; ++i) {
                buf.append(listOfTokens.get(i));
            }
            return buf.toString();
        }
        return name;
    }

    public static boolean expandMultiWordAbbreviations(List list, boolean containPunctuations) {
        int listSize = list.size();
        ArrayList keyList = new ArrayList(m_multiWordAbbreviations.keySet());
        int keyListSize = keyList.size();
        for (int i = 0; i < keyListSize; ++i) {
            String key = (String)keyList.get(i);
            for (int j = 0; j < listSize; ++j) {
                int k;
                String word = ((String)list.get(j)).toUpperCase();
                if (key.equals(word)) {
                    StringTokenizer abbreviatedTokens = new StringTokenizer((String)m_multiWordAbbreviations.get(key), FRA_AddressTerm.getPunctuationsAsString(), containPunctuations);
                    list.remove(j);
                    while (abbreviatedTokens.hasMoreTokens()) {
                        list.add(j++, abbreviatedTokens.nextToken());
                    }
                    return true;
                }
                if (!key.startsWith(word)) continue;
                int startNdx = j;
                int endNdx = j;
                int charSize = key.length();
                String newWord = word;
                int p = j + 1;
                boolean found = false;
                for (k = word.length(); k < charSize; ++k) {
                    word = null;
                    while (p < listSize) {
                        word = ((String)list.get(p)).toUpperCase();
                        if ((!containPunctuations || !FRA_AddressTerm.isPunctuation(word)) && key.charAt(k) == word.charAt(0)) break;
                        word = null;
                        ++p;
                    }
                    if (word != null) {
                        newWord = newWord + word;
                        endNdx = p;
                        if (!key.equals(newWord)) continue;
                        found = true;
                        break;
                    }
                    found = false;
                    break;
                }
                if (!found) continue;
                for (k = startNdx; k <= endNdx; ++k) {
                    list.remove(startNdx);
                }
                StringTokenizer abbreviatedTokens = new StringTokenizer((String)m_multiWordAbbreviations.get(key), FRA_AddressTerm.getPunctuationsAsString(), containPunctuations);
                while (abbreviatedTokens.hasMoreTokens()) {
                    list.add(startNdx++, abbreviatedTokens.nextToken());
                }
                return true;
            }
        }
        return false;
    }

    static {
        try {
            if (m_words == null) {
                m_abbr = new Properties();
                m_multiWordAbbreviations = new HashMap(10);
                m_words = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/FRA/parser/FRA_Words.properties");
                Properties p = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/FRA/parser/FRA_Abbreviations.properties");
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key);
                    if (value != null && value.indexOf(32) > 0) {
                        m_multiWordAbbreviations.put(key.toUpperCase(), value);
                        continue;
                    }
                    m_abbr.put(key, value);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for FRA_Parser.");
        }
    }
}

