/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressComponent;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressTerm;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.HashMap;

public class FRA_MainAddressInfo {
    FRA_AddressComponent houseNumber;
    FRA_AddressComponent houseNumberRangeEnd;
    FRA_AddressComponent preStreetCommon;
    FRA_AddressComponent streetType;
    FRA_AddressComponent postStreetCommon;
    FRA_AddressComponent preAddress;
    FRA_AddressComponent preCommon;
    FRA_AddressComponent streetName;
    FRA_AddressComponent postCommon;
    FRA_AddressComponent postAddress;
    FRA_AddressComponent mayBePostAddress;
    FRA_ThoroughfareTypes tft;
    private boolean debug = false;
    private int direction;
    public static int DIR_FORWARDS = 1;
    public static int DIR_BACKWARDS = 2;

    public FRA_MainAddressInfo(FRA_ThoroughfareTypes tft) {
        this.tft = tft;
        this.direction = DIR_FORWARDS;
    }

    public FRA_MainAddressInfo(FRA_ThoroughfareTypes tft, int parseDirection) {
        if (parseDirection != DIR_FORWARDS && parseDirection != DIR_BACKWARDS) {
            parseDirection = DIR_FORWARDS;
        }
        this.direction = parseDirection;
        this.tft = tft;
    }

    public FRA_AddressComponent getComponent(int type) {
        switch (type) {
            case 0: {
                if (this.houseNumber == null) {
                    this.houseNumber = new FRA_AddressComponent("", 0, this.direction);
                }
                return this.houseNumber;
            }
            case 1: {
                if (this.houseNumberRangeEnd == null) {
                    this.houseNumberRangeEnd = new FRA_AddressComponent("", 1, this.direction);
                }
                return this.houseNumberRangeEnd;
            }
            case 2: {
                if (this.preStreetCommon == null) {
                    this.preStreetCommon = new FRA_AddressComponent("", 2, this.direction);
                }
                return this.preStreetCommon;
            }
            case 3: {
                if (this.streetType == null) {
                    this.streetType = new FRA_AddressComponent("", 3, this.direction);
                }
                return this.streetType;
            }
            case 4: {
                if (this.preCommon == null) {
                    this.preCommon = new FRA_AddressComponent("", 4, this.direction);
                }
                return this.preCommon;
            }
            case 5: {
                if (this.streetName == null) {
                    this.streetName = new FRA_AddressComponent("", 5, this.direction);
                }
                return this.streetName;
            }
            case 6: {
                if (this.postCommon == null) {
                    this.postCommon = new FRA_AddressComponent("", 6, this.direction);
                }
                return this.postCommon;
            }
            case 7: {
                if (this.postAddress == null) {
                    this.postAddress = new FRA_AddressComponent("", 7, this.direction);
                }
                return this.postAddress;
            }
            case 12: {
                if (this.preAddress == null) {
                    this.preAddress = new FRA_AddressComponent("", 12, this.direction);
                }
                return this.preAddress;
            }
            case 11: {
                if (this.postStreetCommon == null) {
                    this.postStreetCommon = new FRA_AddressComponent("", 11, this.direction);
                }
                return this.postStreetCommon;
            }
            case 15: {
                if (this.mayBePostAddress == null) {
                    this.mayBePostAddress = new FRA_AddressComponent("", 15, this.direction);
                }
                return this.mayBePostAddress;
            }
        }
        if (this.debug) {
            MMJLog.getLog().debug("MainAddressInfo.getComponent called with an unknown type");
        }
        return null;
    }

    public boolean isPresent(int type) {
        switch (type) {
            case 0: {
                if (this.houseNumber == null) {
                    return false;
                }
                String houseNumberString = this.houseNumber.getAddressComponentString();
                if (houseNumberString == null) {
                    return false;
                }
                return !houseNumberString.equals("");
            }
            case 1: {
                return this.houseNumberRangeEnd == null ? false : this.houseNumberRangeEnd.getAddressComponentString() != null || !this.houseNumberRangeEnd.getAddressComponentString().equals("");
            }
            case 2: {
                return this.preStreetCommon == null ? false : this.preStreetCommon.getAddressComponentString() != null || !this.preStreetCommon.getAddressComponentString().equals("");
            }
            case 3: {
                return this.streetType == null ? false : this.streetType.getAddressComponentString() != null || !this.streetType.getAddressComponentString().equals("");
            }
            case 4: {
                return this.preCommon == null ? false : this.preCommon.getAddressComponentString() != null || !this.preCommon.getAddressComponentString().equals("");
            }
            case 5: {
                return this.streetName == null ? false : this.streetName.getAddressComponentString() != null || !this.streetName.getAddressComponentString().equals("");
            }
            case 6: {
                return this.postCommon == null ? false : this.postCommon.getAddressComponentString() != null || !this.postCommon.getAddressComponentString().equals("");
            }
            case 7: {
                return this.postAddress == null ? false : this.postAddress.getAddressComponentString() != null || !this.postAddress.getAddressComponentString().equals("");
            }
            case 11: {
                return this.postStreetCommon == null ? false : this.postStreetCommon.getAddressComponentString() != null || !this.postStreetCommon.getAddressComponentString().equals("");
            }
            case 12: {
                return this.preAddress == null ? false : this.preAddress.getAddressComponentString() != null || !this.preAddress.getAddressComponentString().equals("");
            }
        }
        return false;
    }

    public void addComponent(FRA_AddressComponent ac) {
        switch (ac.getType()) {
            case 0: {
                this.houseNumber = ac;
                return;
            }
            case 1: {
                if (this.houseNumberRangeEnd == null) {
                    this.houseNumberRangeEnd = ac;
                    return;
                }
                if (!this.debug) break;
                MMJLog.getLog().debug("Trying to add second house number range end to AddressInfo");
                break;
            }
            case 2: {
                if (this.preStreetCommon == null) {
                    this.preStreetCommon = ac;
                    return;
                }
                if (!this.debug) break;
                MMJLog.getLog().debug("Trying to add streetCommon AddressInfo and it already exists!");
                break;
            }
            case 3: {
                if (this.streetType == null) {
                    this.streetType = ac;
                    return;
                }
                if (!this.debug) break;
                MMJLog.getLog().debug("Trying to add streettype AddressInfo and it already exists!");
                break;
            }
            case 4: {
                if (this.preCommon == null) {
                    this.preCommon = ac;
                    break;
                }
                this.preCommon.addToAddressComponent(ac.getAddressComponentString());
                break;
            }
            case 5: {
                if (this.streetName == null) {
                    this.streetName = ac;
                    return;
                }
                if (!this.debug) break;
                MMJLog.getLog().debug("Trying to add main address to AddressInfo");
                break;
            }
            case 6: {
                if (this.postAddress != null) {
                    if (this.debug) {
                        MMJLog.getLog().debug("Trying to add to postCommon when postAddress has been used! Adding to postAddress instead");
                    }
                    this.postAddress.addToAddressComponent(ac.getAddressComponentString());
                    return;
                }
                if (this.postCommon == null) {
                    this.postCommon = ac;
                    break;
                }
                this.postCommon.addToAddressComponent(ac.getAddressComponentString());
                break;
            }
            case 7: {
                if (this.postAddress == null) {
                    this.postAddress = ac;
                    break;
                }
                this.postAddress.addToAddressComponent(ac.getAddressComponentString());
                break;
            }
            case 11: {
                if (this.postStreetCommon == null) {
                    this.postStreetCommon = ac;
                    break;
                }
                this.postStreetCommon.addToAddressComponent(ac.getAddressComponentString());
                break;
            }
            case 12: {
                if (this.preAddress == null) {
                    this.preAddress = ac;
                    break;
                }
                this.preAddress.addToAddressComponent(ac.getAddressComponentString());
                break;
            }
            default: {
                if (!this.debug) break;
                MMJLog.getLog().debug("Trying to add an unknown type to preAddress!");
            }
        }
    }

    public String toString() {
        if (this.direction == DIR_FORWARDS) {
            return this.privateToStringForwards();
        }
        if (this.direction == DIR_BACKWARDS) {
            return this.privateToStringBackwards();
        }
        return null;
    }

    public void toParsedAddress(Address pa) {
        if (this.direction == DIR_FORWARDS) {
            this.toParsedAddressForwards(pa);
        } else if (this.direction == DIR_BACKWARDS) {
            this.toParsedAddressBackwards(pa);
        }
    }

    private void toParsedAddressForwards(Address pa) {
        String mainAddrStr;
        if (this.houseNumber != null) {
            pa.setAddressNumber(this.houseNumber.getAddressComponentString());
        }
        String strTypeStr = this.streetType == null ? null : FRA_ThoroughfareTypes.getPrefferedName(this.streetType.getAddressComponentString());
        String postAddrStr = this.postAddress == null ? null : this.postAddress.getAddressComponentString();
        String preCommonStr = this.preCommon == null ? null : this.preCommon.getAddressComponentString();
        String preStreetCommonStr = this.preStreetCommon == null ? null : this.preStreetCommon.getAddressComponentString();
        String string = mainAddrStr = this.streetName == null ? null : this.streetName.getAddressComponentString();
        if (mainAddrStr == null || mainAddrStr.equals("")) {
            if (postAddrStr != null && !postAddrStr.equals("") && !FRA_AddressTerm.isPunctuation(postAddrStr)) {
                mainAddrStr = postAddrStr;
                postAddrStr = null;
            } else if (preCommonStr != null && !preCommonStr.equals("")) {
                mainAddrStr = preCommonStr;
                preCommonStr = null;
            } else if (preStreetCommonStr != null && !preStreetCommonStr.equals("")) {
                mainAddrStr = preStreetCommonStr;
            }
        }
        if (mainAddrStr != null && mainAddrStr.length() == 1 && postAddrStr != null && !postAddrStr.equals("") && postAddrStr.length() > 1) {
            mainAddrStr = postAddrStr;
            postAddrStr = null;
        }
        if ((strTypeStr == null || strTypeStr.length() == 0) && FRA_ThoroughfareTypes.isStreetType(mainAddrStr) && postAddrStr != null && !FRA_AddressTerm.isPunctuation(postAddrStr)) {
            strTypeStr = mainAddrStr;
            mainAddrStr = postAddrStr;
            postAddrStr = null;
        }
        pa.setMainAddress(mainAddrStr);
        pa.setPostAddress(postAddrStr);
        if (strTypeStr != null && strTypeStr.length() != 0) {
            pa.setPreThoroughfareType(strTypeStr);
        }
        HashMap<String, String> addFields = null;
        if (preStreetCommonStr != null || this.preCommon != null || this.postCommon != null) {
            addFields = new HashMap<String, String>(3);
        }
        if (this.preStreetCommon != null && this.preStreetCommon.getAddressComponentString() != null) {
            addFields.put("pre_street_type_common", this.preStreetCommon.getAddressComponentString());
        }
        if (this.preCommon != null && this.preCommon.getAddressComponentString() != null) {
            addFields.put("pre_addr_common", this.preCommon.getAddressComponentString());
        }
        if (this.postCommon != null && this.postCommon.getAddressComponentString() != null) {
            addFields.put("post_addr_common", this.postCommon.getAddressComponentString());
        }
        if (addFields != null) {
            pa.setAdditionalFields(addFields);
        }
    }

    public void toParsedAddressBackwards(Address pa) {
        if (this.houseNumber != null) {
            StringBuffer wholeAddressNumber = new StringBuffer();
            wholeAddressNumber.append(this.houseNumber.getAddressComponentString());
            if (this.houseNumberRangeEnd != null) {
                wholeAddressNumber.append("-");
                wholeAddressNumber.append(this.houseNumberRangeEnd.getAddressComponentString() == null ? "" : this.houseNumberRangeEnd.getAddressComponentString());
            }
            if (wholeAddressNumber.length() > 0) {
                pa.setAddressNumber(wholeAddressNumber.toString());
            } else {
                String temp = null;
                pa.setAddressNumber(temp);
            }
        }
        String preStreetCommonStr = this.preStreetCommon == null ? null : this.preStreetCommon.getAddressComponentString();
        String strTypeStr = this.streetType == null ? null : FRA_ThoroughfareTypes.getPrefferedName(this.streetType.getAddressComponentString());
        String preAddressStr = this.preAddress == null ? null : this.preAddress.getAddressComponentString();
        String preCommonStr = this.preCommon == null ? null : this.preCommon.getAddressComponentString();
        String mainAddrStr = this.streetName == null ? null : this.streetName.getAddressComponentString();
        String postCommonStr = this.postCommon == null ? null : this.postCommon.getAddressComponentString();
        String postAddressStr = this.postAddress == null ? null : this.postAddress.getAddressComponentString();
        String postStreetTypeStr = null;
        boolean usePostStreetType = false;
        if (mainAddrStr == null || mainAddrStr.equals("")) {
            if (preAddressStr != null && !preAddressStr.equals("") && !FRA_AddressTerm.isPunctuation(preAddressStr)) {
                mainAddrStr = preAddressStr;
                preAddressStr = null;
                postCommonStr = preCommonStr;
                preCommonStr = null;
            } else if (postCommonStr != null && !postCommonStr.equals("")) {
                int lastSpaceIndex = postCommonStr.lastIndexOf(" ");
                if (lastSpaceIndex < 0) {
                    mainAddrStr = postCommonStr;
                    postCommonStr = null;
                } else {
                    String firstPart = postCommonStr.substring(0, lastSpaceIndex);
                    String secondPart = postCommonStr.substring(lastSpaceIndex, postCommonStr.length());
                    mainAddrStr = secondPart.trim();
                    postCommonStr = null;
                    preCommonStr = firstPart.trim();
                }
            } else if (preStreetCommonStr != null && !preStreetCommonStr.equals("")) {
                usePostStreetType = true;
                postStreetTypeStr = strTypeStr;
                strTypeStr = null;
                mainAddrStr = preStreetCommonStr;
                preStreetCommonStr = null;
            }
        }
        if (mainAddrStr != null && mainAddrStr.length() == 1 && preAddressStr != null && !preAddressStr.equals("") && preAddressStr.length() > 1) {
            mainAddrStr = preAddressStr;
            preAddressStr = null;
        }
        if ((strTypeStr == null || strTypeStr.length() == 0) && mainAddrStr != null && FRA_ThoroughfareTypes.isStreetType(mainAddrStr) && preAddressStr != null && !FRA_AddressTerm.isPunctuation(preAddressStr)) {
            strTypeStr = mainAddrStr;
            mainAddrStr = preAddressStr;
            preAddressStr = null;
        }
        if (mainAddrStr == null && strTypeStr != null) {
            mainAddrStr = strTypeStr;
            strTypeStr = null;
        }
        if (mainAddrStr != null && !mainAddrStr.equals("")) {
            pa.setMainAddress(mainAddrStr);
        }
        if (preAddressStr != null && !preAddressStr.equals("")) {
            pa.setPreAddress(preAddressStr);
        }
        if (postAddressStr != null && !postAddressStr.equals("")) {
            pa.setPostAddress(postAddressStr);
        }
        if (!usePostStreetType) {
            if (strTypeStr != null && strTypeStr.length() != 0) {
                pa.setPreThoroughfareType(strTypeStr);
            }
        } else if (postStreetTypeStr != null && postStreetTypeStr.length() != 0) {
            pa.setPostThoroughfareType(postStreetTypeStr);
        }
        HashMap<String, String> addFields = null;
        if (preStreetCommonStr != null || this.preCommon != null || this.postCommon != null || this.postStreetCommon != null) {
            addFields = new HashMap<String, String>(3);
        }
        if (preStreetCommonStr != null && this.preStreetCommon != null && this.preStreetCommon.getAddressComponentString() != null) {
            addFields.put("pre_street_type_common", this.preStreetCommon.getAddressComponentString());
        }
        if (preCommonStr != null && this.preCommon != null && this.preCommon.getAddressComponentString() != null) {
            addFields.put("pre_addr_common", this.preCommon.getAddressComponentString());
        }
        if (postCommonStr != null && this.postCommon != null && this.postCommon.getAddressComponentString() != null) {
            addFields.put("post_addr_common", this.postCommon.getAddressComponentString());
        }
        if (this.postStreetCommon != null && this.postStreetCommon.getAddressComponentString() != null) {
            addFields.put("post_st_type_common", this.postStreetCommon.getAddressComponentString());
        }
        if (this.mayBePostAddress != null && this.mayBePostAddress.getAddressComponentString() != null) {
            if (addFields == null) {
                addFields = new HashMap(3);
            }
            addFields.put("expanded_pre_main_common", this.mayBePostAddress.getAddressComponentString());
        }
        if (addFields != null) {
            addFields.put("highest_scoring_language", (String)pa.getAdditionalFields().get("highest_scoring_language"));
            pa.setAdditionalFields(addFields);
        }
    }

    private String privateToStringForwards() {
        StringBuffer wholeLine = new StringBuffer();
        if (this.houseNumber != null) {
            wholeLine.append(this.houseNumber.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.houseNumberRangeEnd != null) {
            wholeLine.append("- ");
            wholeLine.append(this.houseNumberRangeEnd.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.preStreetCommon != null) {
            wholeLine.append(this.preStreetCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.streetType != null) {
            wholeLine.append(this.streetType.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.preCommon != null) {
            wholeLine.append(this.preCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.streetName != null) {
            wholeLine.append(this.streetName.getAddressComponentString());
            if ((this.postCommon == null || this.postCommon.getAddressComponent().length() <= 0 || this.postCommon.getAddressComponent().charAt(0) != '-' && this.postCommon.getAddressComponent().charAt(0) != '.') && wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.postCommon != null) {
            wholeLine.append(this.postCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'') {
                wholeLine.append(" ");
            }
        }
        if (this.postAddress != null) {
            wholeLine.append(this.postAddress.getAddressComponentString());
        }
        return wholeLine.toString();
    }

    private String privateToStringBackwards() {
        StringBuffer wholeLine = new StringBuffer();
        if (this.houseNumber != null) {
            wholeLine.append(this.houseNumber.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.houseNumberRangeEnd != null) {
            wholeLine.append("- ");
            wholeLine.append(this.houseNumberRangeEnd.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.preStreetCommon != null && this.preStreetCommon.getAddressComponentString() != null && !this.preStreetCommon.getAddressComponentString().equals("")) {
            wholeLine.append(this.preStreetCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.streetType != null) {
            wholeLine.append(this.streetType.getAddressComponentString());
            wholeLine.append(" ");
        }
        if (this.postStreetCommon != null && this.postStreetCommon.getAddressComponentString() != null && !this.postStreetCommon.getAddressComponentString().equals("")) {
            wholeLine.append(this.postStreetCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.preAddress != null && this.preAddress.getAddressComponentString() != null && !this.preAddress.getAddressComponentString().equals("")) {
            wholeLine.append(this.preAddress.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'') {
                wholeLine.append(" ");
            }
        }
        if (this.preCommon != null && this.preCommon.getAddressComponentString() != null && !this.preCommon.getAddressComponentString().equals("")) {
            wholeLine.append(this.preCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.streetName != null) {
            wholeLine.append(this.streetName.getAddressComponentString());
            if ((this.postCommon == null || this.postCommon.getAddressComponent().length() <= 0 || this.postCommon.getAddressComponent().charAt(0) != '-' && this.postCommon.getAddressComponent().charAt(0) != '.') && wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'' && wholeLine.charAt(wholeLine.length() - 1) != '.') {
                wholeLine.append(" ");
            }
        }
        if (this.postCommon != null && this.postCommon.getAddressComponentString() != null && !this.postCommon.getAddressComponentString().equals("")) {
            wholeLine.append(this.postCommon.getAddressComponentString());
            if (wholeLine.length() > 0 && wholeLine.charAt(wholeLine.length() - 1) != '-' && wholeLine.charAt(wholeLine.length() - 1) != '\'') {
                wholeLine.append(" ");
            }
        }
        if (this.postAddress != null && this.postAddress.getAddressComponentString() != null && !this.postAddress.getAddressComponentString().equals("")) {
            wholeLine.append(this.postAddress.getAddressComponentString());
        }
        if (this.mayBePostAddress != null && this.mayBePostAddress.getAddressComponentString() != null && !this.mayBePostAddress.getAddressComponentString().equals("")) {
            wholeLine.append(this.mayBePostAddress.getAddressComponentString());
        }
        return wholeLine.toString();
    }
}

