/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_Abbreviations;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressComponent;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressTerm;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_MainAddressInfo;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_NumberTerm;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_SpecialStreetHandling;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.CHE.FRA.parser.Logger;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class FRA_ParseMainAddressRule
implements IParseRule {
    public static final int MAX_ADDITIONAL_FIELDS = 2;
    private StringBuffer strBuf = null;
    private StringBuffer preAddrBuf = null;
    private StringBuffer postAddrBuf = null;
    private StringBuffer hnrBuf = null;
    public static final String UNPARSED_HNR = "unparsed_hnr";
    String preTTT = null;
    private boolean debug = false;
    public static final String ABBR_MAIN_ADDRESS = "abbr_main_address";
    private boolean obsPostcode = false;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String mayBePreAddress;
        this.obsPostcode = false;
        String hnr = null;
        String str = null;
        if (pa.getMainAddress() != null && FRA_SpecialStreetHandling.handleSpecialStreet(pa, str = pa.getMainAddress())) {
            HashMap<String, String> addFields = new HashMap<String, String>();
            addFields.put("unparsed_input_street", str);
            addFields.put("input_house_number", ura.getAddressNumber());
            pa.setAdditionalFields(addFields);
            return;
        }
        hnr = FRA_ParseMainAddressRule.getProperHouseNumber(pa.getAddressNumber());
        if (!FRA_ParseMainAddressRule.isValidHouseNumber(hnr) && !FRA_ParseMainAddressRule.isValidHouseNumberRange(hnr)) {
            hnr = null;
        }
        if (this.isEmpty(str = pa.getMainAddress())) {
            return;
        }
        if (str != null && str.length() != 0) {
            str = str.replaceAll("\"", "");
            str = str.replaceAll("[+]", "");
        }
        this.strBuf = new StringBuffer(str.length());
        this.preAddrBuf = new StringBuffer(str.length());
        this.postAddrBuf = new StringBuffer(str.length());
        this.hnrBuf = new StringBuffer(str.length());
        StringTokenizer tokens = new StringTokenizer(str, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        FRA_Abbreviations.expandMultiWordAbbreviations(listOfTokens, true);
        this.removeJunk(listOfTokens);
        this.removeJunk(listOfTokens);
        this.cleanAddress(listOfTokens);
        FRA_ParseMainAddressRule.cleanHNR(listOfTokens);
        if (listOfTokens.size() == 0) {
            pa.setMainAddress(null);
            return;
        }
        FRA_MainAddressInfo mainAddressInfo = null;
        boolean forwards = false;
        mainAddressInfo = forwards ? this.processMainAddressLineForwards(listOfTokens, pa) : this.processMainAddressLineBackwards(listOfTokens, pa);
        String addressReconstructed = mainAddressInfo.toString();
        mainAddressInfo.toParsedAddress(pa);
        if (hnr != null) {
            pa.setAddressNumber(hnr);
        }
        if (this.obsPostcode) {
            pa.setPostCode1(null);
        }
        if (this.debug && !Logger.compareToSavedMainAddress(addressReconstructed)) {
            MMJLog.getLog().debug("<< " + Logger.getSavedMainAddressPart());
            MMJLog.getLog().debug(">> " + addressReconstructed);
        }
        if (pa.getAdditionalFields() != null && (mayBePreAddress = (String)pa.getAdditionalFields().get("expanded_pre_main_common")) != null && pa.getPreAddress() == null) {
            pa.setPreAddress(mayBePreAddress);
        }
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    private String getDelimiters() {
        StringBuffer buf = new StringBuffer(20);
        if (FRA_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(FRA_AddressTerm.getPunctuationsAsString());
        }
        if (FRA_AddressTerm.getOrdinalsAsString() != null) {
            buf.append(FRA_AddressTerm.getOrdinalsAsString());
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    protected void setPreAddress(String preAddress) {
        if (preAddress == null) {
            this.preAddrBuf = null;
            return;
        }
        this.preAddrBuf = new StringBuffer(preAddress.length());
        this.preAddrBuf.append(preAddress);
    }

    protected void setPostAddress(String postAddress) {
        if (postAddress == null) {
            this.postAddrBuf = null;
            return;
        }
        this.postAddrBuf = new StringBuffer(postAddress.length());
        this.postAddrBuf.append(postAddress);
    }

    public static boolean isValidHouseNumber(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen > 1 && FRA_ParseMainAddressRule.isAlpha(hnr.charAt(hnrLen - 1))) {
            return FRA_ParseMainAddressRule.isValidNumberFormat(hnr.substring(0, hnrLen - 1), hnrLen - 1);
        }
        return FRA_ParseMainAddressRule.isValidNumberFormat(hnr, hnrLen);
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-/");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!FRA_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return FRA_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    public boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public void cleanAddress(LinkedList list) {
        String temp;
        while (list.size() > 0 && (temp = (String)list.getFirst()).length() == 1 && FRA_AddressTerm.isPunctuation(temp)) {
            list.removeFirst();
        }
        while (list.size() > 0 && (temp = (String)list.getLast()).length() == 1 && FRA_AddressTerm.isPunctuation(temp)) {
            list.removeLast();
        }
        String lastPunctuation = null;
        for (int i = 0; i < list.size(); ++i) {
            String temp2 = (String)list.get(i);
            if (temp2.length() == 1 && FRA_AddressTerm.isPunctuation(temp2)) {
                if (temp2.equals(lastPunctuation)) {
                    list.remove(i);
                    break;
                }
                lastPunctuation = temp2;
                continue;
            }
            lastPunctuation = null;
        }
    }

    public static String getProperHouseNumber(String inHnr) {
        String temp;
        if (inHnr == null || inHnr.trim().length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(inHnr, ",. /-", true);
        String houseNum = null;
        ArrayList<String> list = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (FRA_ParseMainAddressRule.cleanHNR(list)) {
            StringBuffer buf = new StringBuffer(inHnr.length());
            for (int i = 0; i < list.size(); ++i) {
                buf.append(list.get(i));
            }
            st = new StringTokenizer(buf.toString(), ",. /-", true);
        }
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            if (!FRA_ParseMainAddressRule.isValidHouseNumber(temp)) continue;
            houseNum = temp;
            break;
        }
        if (!st.hasMoreTokens()) {
            if (houseNum != null) {
                return houseNum.trim();
            }
            return null;
        }
        temp = st.nextToken();
        if (temp.equals(" ") && st.hasMoreTokens()) {
            temp = st.nextToken();
        }
        if (FRA_ParseMainAddressRule.isValidHouseNumber(temp)) {
            return houseNum.trim();
        }
        if (FRA_ParseMainAddressRule.isValidHouseNumber(houseNum + temp)) {
            houseNum = houseNum + temp;
            if (st.hasMoreTokens()) {
                temp = st.nextToken();
            }
            if (temp.equals(" ") && st.hasMoreTokens()) {
                temp = st.nextToken();
            }
        }
        if ((temp.equals("-") || temp.equals("/")) && st.hasMoreTokens()) {
            temp = st.nextToken();
            if (temp.equals(" ") && st.hasMoreTokens()) {
                temp = st.nextToken();
            }
            if (FRA_ParseMainAddressRule.isValidHouseNumberRange(houseNum + "-" + temp)) {
                houseNum = houseNum + "-" + temp;
                temp = st.hasMoreTokens() ? st.nextToken() : null;
                if (temp != null && temp.equals(" ") && st.hasMoreTokens()) {
                    temp = st.nextToken();
                }
                if (FRA_ParseMainAddressRule.isValidHouseNumberRange(houseNum + temp)) {
                    houseNum = houseNum + temp;
                    if (st.hasMoreTokens()) {
                        temp = st.nextToken();
                    }
                    if (temp.equals(" ") && st.hasMoreTokens()) {
                        temp = st.nextToken();
                    }
                }
            }
        }
        return houseNum.trim();
    }

    protected void appendPreAddress(String term) {
        if (this.preAddrBuf == null) {
            this.initPreAddrBuf(0);
        }
        this.preAddrBuf.append(term);
    }

    protected void insertPreAddress(String term) {
        if (this.preAddrBuf == null) {
            this.initPreAddrBuf(0);
        }
        this.preAddrBuf.insert(0, term);
    }

    protected void appendPostAddress(String term) {
        if (this.postAddrBuf == null) {
            this.initPostAddrBuf(0);
        }
        this.postAddrBuf.append(term);
    }

    protected void insertPostAddress(String term) {
        if (this.postAddrBuf == null) {
            this.initPostAddrBuf(0);
        }
        this.postAddrBuf.insert(0, term);
    }

    protected void appendHnr(String term) {
        if (this.hnrBuf == null) {
            this.initHnrBuf(0);
        }
        this.hnrBuf.append(term);
    }

    protected void insertHnr(String term) {
        if (this.hnrBuf == null) {
            this.initHnrBuf(0);
        }
        this.hnrBuf.insert(0, term);
    }

    protected void appendStreet(String term) {
        if (this.strBuf == null) {
            this.initStrBuf(0);
        }
        this.strBuf.append(term);
        this.debug(this.strBuf.toString());
    }

    protected void insertStreet(String term) {
        if (this.strBuf == null) {
            this.initStrBuf(0);
        }
        this.strBuf.insert(0, term);
    }

    protected void initStrBuf(int size) {
        this.strBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initPreAddrBuf(int size) {
        this.preAddrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initPostAddrBuf(int size) {
        this.postAddrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initHnrBuf(int size) {
        this.hnrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected String getPreAddress() {
        if (this.preAddrBuf != null && this.preAddrBuf.length() > 0) {
            return this.preAddrBuf.toString();
        }
        return null;
    }

    protected String getPostAddress() {
        if (this.postAddrBuf != null && this.postAddrBuf.length() > 0) {
            return this.postAddrBuf.toString();
        }
        return null;
    }

    protected String getHnr() {
        if (this.hnrBuf != null && this.hnrBuf.length() > 0) {
            return this.hnrBuf.toString();
        }
        return null;
    }

    protected boolean canBePartOfHnr(String term) {
        if (term == null) {
            return false;
        }
        if (FRA_ParseMainAddressRule.isValidHouseNumber(term)) {
            return true;
        }
        if (FRA_AddressTerm.isHnrCanContainTerm(term)) {
            return true;
        }
        if (FRA_AddressTerm.isOrdinal(term)) {
            return false;
        }
        if (term.length() == 1) {
            return FRA_ParseMainAddressRule.isAlpha(term.charAt(0)) || term.charAt(0) == ' ';
        }
        return false;
    }

    protected void setHnr(String hnr) {
        if (hnr == null) {
            this.hnrBuf = null;
            return;
        }
        this.hnrBuf = new StringBuffer(hnr.length());
        this.hnrBuf.append(hnr);
    }

    protected String getStreet() {
        if (this.strBuf != null && this.strBuf.length() > 0) {
            return this.strBuf.toString();
        }
        return null;
    }

    private static boolean cleanHNR(List listOfTokens) {
        String[] hnrPrefixes = new String[]{"BIS", "TER"};
        boolean previousWasNumber = false;
        int removeAt = -1;
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            if (FRA_AddressTerm.isPunctuation(term)) continue;
            if (!previousWasNumber && FRA_AddressTerm.isDigit(term.charAt(0))) {
                previousWasNumber = true;
                continue;
            }
            if (previousWasNumber) {
                for (int j = 0; j < hnrPrefixes.length; ++j) {
                    if (!hnrPrefixes[j].equalsIgnoreCase(term)) continue;
                    removeAt = i;
                    break;
                }
            }
            if (removeAt > -1) break;
            previousWasNumber = false;
        }
        if (removeAt > -1) {
            listOfTokens.remove(removeAt);
            if (listOfTokens.size() > removeAt && FRA_AddressTerm.isPunctuation((String)listOfTokens.get(removeAt))) {
                listOfTokens.remove(removeAt);
            }
            return true;
        }
        return false;
    }

    protected boolean couldBeOrdinal(String termToInvestigate) {
        if (termToInvestigate == null || termToInvestigate.equals("")) {
            return false;
        }
        return FRA_AddressTerm.isDigit(termToInvestigate.charAt(0));
    }

    public boolean peek(int typeToLookFor, LinkedList list, int i, FRA_ThoroughfareTypes tft) {
        if (list == null || list.size() < i) {
            return false;
        }
        if (typeToLookFor == 3) {
            for (int k = 0; k < i; ++k) {
                String temp = (String)list.get(k);
                if (!FRA_ThoroughfareTypes.isStreetType(temp)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private FRA_MainAddressInfo processMainAddressLineForwards(LinkedList list, Address pa) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private FRA_MainAddressInfo processMainAddressLineBackwards(LinkedList list, Address pa) {
        tft = new FRA_ThoroughfareTypes();
        mainAddressInfo = new FRA_MainAddressInfo(tft, FRA_MainAddressInfo.DIR_BACKWARDS);
        lastType = -1;
        thisTerm = null;
        lastTermWasStreetNumber = false;
        lastTypeDodgyNumber = -99;
        lastTermWasMonth = -99;
        ordinalBuffer = null;
        forceThisTermToCommon = false;
        block56: for (i = list.size() - 1; i >= 0; --i) {
            block94: {
                block97: {
                    block98: {
                        block96: {
                            block95: {
                                thisTerm = (String)list.get(i);
                                forceThisTermToCommon = false;
                                if (lastTermWasMonth != -99 && lastTermWasMonth - i > 2) {
                                    lastTermWasMonth = -99;
                                }
                                if (thisTerm == null || thisTerm.equals(" ") || thisTerm.equals("&")) continue;
                                isHouseNumberPresent = mainAddressInfo.isPresent(0);
                                isStreetTypePresent = mainAddressInfo.isPresent(3);
                                isValidHouseNumber = FRA_AddressTerm.isHnrCanContainTerm(thisTerm);
                                v0 = haveHadSuspiciousNumber = lastTypeDodgyNumber != -99;
                                if (isHouseNumberPresent && isStreetTypePresent && !isValidHouseNumber && !haveHadSuspiciousNumber) continue;
                                if (!FRA_ParseMainAddressRule.isValidHouseNumber(thisTerm) && !FRA_AddressTerm.isRomanNumber(thisTerm)) break block94;
                                if (ordinalBuffer == null || ordinalBuffer.equals("")) break block95;
                                thisTerm = thisTerm + ordinalBuffer;
                                break block94;
                            }
                            if (lastTermWasMonth == -99) break block96;
                            realNumber = FRA_NumberTerm.lookupNumber(thisTerm);
                            if (realNumber == null) {
                                forceThisTermToCommon = true;
                            } else {
                                thisTerm = realNumber;
                            }
                            break block94;
                        }
                        if (lastType == 10) {
                            if (!mainAddressInfo.isPresent(0)) continue;
                            temp = mainAddressInfo.getComponent(0).getAddressComponentString();
                            mainAddressInfo.getComponent(0).reset();
                            mainAddressInfo.getComponent(0).addToAddressComponent(thisTerm);
                            addressComponent = new FRA_AddressComponent(temp, 1, FRA_MainAddressInfo.DIR_BACKWARDS);
                            mainAddressInfo.addComponent(addressComponent);
                            lastType = 0;
                            continue;
                        }
                        if (lastType != 3 && lastType != 2 && lastType != 5 && lastType != 12 && lastType != 4 && lastType != 11) break block97;
                        if (lastTypeDodgyNumber == -99) {
                            if (i > 1) {
                                lastTypeDodgyNumber = lastType;
                            }
                            lastType = 0;
                            addressComponent = new FRA_AddressComponent(thisTerm, 0, FRA_MainAddressInfo.DIR_BACKWARDS);
                            mainAddressInfo.addComponent(addressComponent);
                            continue;
                        }
                        temp = mainAddressInfo.getComponent(0).getAddressComponentString();
                        realNumber = FRA_NumberTerm.lookupNumber(temp);
                        if (realNumber != null) break block98;
                        forceThisTermToCommon = true;
                        break block94;
                    }
                    switch (lastTypeDodgyNumber) {
                        case 3: {
                            break;
                        }
                        case 4: {
                            temp2 = mainAddressInfo.getComponent(4).getAddressComponentString();
                            mainAddressInfo.getComponent(4).reset();
                            newPreCommon = temp;
                            if (newPreCommon != null && newPreCommon.length() > 0 && newPreCommon.charAt(newPreCommon.length() - 1) != '\'' && newPreCommon.charAt(newPreCommon.length() - 1) != '-') {
                                newPreCommon = newPreCommon + " ";
                            }
                            newPreCommon = newPreCommon + temp2;
                            mainAddressInfo.getComponent(4).addToAddressComponent(newPreCommon);
                            ** GOTO lbl83
                        }
                        case 5: {
                            mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm);
                            ** GOTO lbl83
                        }
                        case 12: {
                            mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm);
                            ** GOTO lbl83
                        }
                        case 6: {
                            temp2 = mainAddressInfo.getComponent(6).getAddressComponentString();
                            mainAddressInfo.getComponent(6).reset();
                            newPostCommon = temp;
                            if (newPostCommon != null && newPostCommon.length() > 0 && newPostCommon.charAt(newPostCommon.length() - 1) != '\'' && newPostCommon.charAt(newPostCommon.length() - 1) != '-') {
                                newPostCommon = newPostCommon + " ";
                            }
                            newPostCommon = newPostCommon + temp2;
                            mainAddressInfo.getComponent(6).addToAddressComponent(newPostCommon);
                        }
lbl83:
                        // 5 sources

                        default: {
                            lastType = 0;
                            mainAddressInfo.getComponent(0).reset();
                            mainAddressInfo.getComponent(0).addToAddressComponent(thisTerm);
                            break;
                        }
                    }
                    continue;
                }
                realNumber = FRA_NumberTerm.lookupNumber(thisTerm);
                if (realNumber != null) {
                    thisTerm = realNumber;
                    forceThisTermToCommon = true;
                    lastTermWasStreetNumber = true;
                }
                forceThisTermToCommon = true;
            }
            if (lastType == 10 && (mainAddressInfo.isPresent(3) || !this.peek(3, list, i, tft))) break;
            if (!forceThisTermToCommon && this.couldBeOrdinal(thisTerm)) {
                len = thisTerm.length();
                number = new StringBuffer();
                string = new StringBuffer();
                stop = false;
                for (k = 0; k < len && !stop; ++k) {
                    if (FRA_AddressTerm.isDigit(thisTerm.charAt(k))) {
                        number.append(thisTerm.charAt(k));
                        continue;
                    }
                    string.append(thisTerm.charAt(k));
                }
                numericalPart = number.toString();
                stringPart = string.toString();
                if (FRA_AddressTerm.isOrdinal(stringPart) && (realWord = FRA_NumberTerm.lookupOrdinal(numericalPart)) != null) {
                    thisTerm = realWord;
                    forceThisTermToCommon = true;
                    lastTermWasStreetNumber = true;
                }
            }
            if (FRA_AddressTerm.isOrdinal(thisTerm)) {
                ordinalBuffer = thisTerm;
                continue;
            }
            ordinalBuffer = null;
            if (FRA_AddressTerm.isHnrCanContainTerm(thisTerm) && lastType == 0) {
                lastType = 10;
                continue;
            }
            if (FRA_AddressTerm.isCommonTermWithPostNumber(thisTerm)) {
                if (lastTermWasStreetNumber) {
                    temp = mainAddressInfo.getComponent(lastType).getAddressComponentString();
                    firstSpace = temp.indexOf(" ");
                    if (firstSpace > 0) {
                        temp = temp.substring(firstSpace);
                        mainAddressInfo.getComponent(lastType).reset();
                        mainAddressInfo.getComponent(lastType).addToAddressComponent(temp);
                    } else {
                        mainAddressInfo.getComponent(lastType).reset();
                    }
                }
                lastTermWasStreetNumber = false;
                continue;
            }
            if (FRA_AddressTerm.isPunctuation(thisTerm)) {
                switch (lastType) {
                    case -1: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Found punctuation at end of main address");
                        break;
                    }
                    case 8: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Found 2 punctuations in a row!");
                        break;
                    }
                    case 6: {
                        mainAddressInfo.getComponent(6).addToAddressComponent(thisTerm, 10);
                        lastType = 6;
                        break;
                    }
                    case 5: {
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm);
                        lastType = 4;
                        break;
                    }
                    case 4: {
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm, 10);
                        lastType = 4;
                        break;
                    }
                    case 12: {
                        mainAddressInfo.getComponent(12).addToAddressComponent(thisTerm, 10);
                        lastType = 12;
                        break;
                    }
                    case 11: {
                        mainAddressInfo.getComponent(11).addToAddressComponent(thisTerm, 10);
                        lastType = 11;
                        break;
                    }
                    case 3: {
                        if (this.debug) break;
                    }
                    case 2: {
                        mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm, 10);
                        lastType = 2;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Unknown lastType whilst looking at punctuation");
                        break;
                    }
                }
                continue;
            }
            if (FRA_ThoroughfareTypes.isStreetType(thisTerm)) {
                if (!mainAddressInfo.isPresent(3)) {
                    mainAddressInfo.getComponent(3).addToAddressComponent(thisTerm);
                    lastType = 3;
                    if (!mainAddressInfo.isPresent(0)) continue;
                    oldHouseNumber = mainAddressInfo.getComponent(0).getAddressComponentString();
                    mainAddressInfo.getComponent(0).reset();
                    realNumber = FRA_NumberTerm.lookupNumber(oldHouseNumber);
                    if (realNumber == null) {
                        switch (lastTypeDodgyNumber) {
                            case -1: 
                            case 6: {
                                mainAddressInfo.getComponent(6).addToAddressComponent(oldHouseNumber);
                                lastType = 6;
                                break;
                            }
                            case 5: {
                                mainAddressInfo.getComponent(4).addToAddressComponent(oldHouseNumber);
                                lastType = 4;
                                break;
                            }
                            case 4: {
                                mainAddressInfo.getComponent(4).addToAddressComponent(oldHouseNumber);
                                lastType = 4;
                                break;
                            }
                            case 12: {
                                mainAddressInfo.getComponent(11).addToAddressComponent(oldHouseNumber);
                                lastType = 11;
                                break;
                            }
                            case 11: {
                                mainAddressInfo.getComponent(11).addToAddressComponent(oldHouseNumber);
                                lastType = 11;
                            }
                        }
                        continue;
                    }
                    switch (lastTypeDodgyNumber) {
                        case 4: {
                            temp2 = mainAddressInfo.getComponent(4).getAddressComponentString();
                            mainAddressInfo.getComponent(4).reset();
                            newPreCommon = realNumber;
                            if (newPreCommon != null && newPreCommon.length() > 0 && newPreCommon.charAt(newPreCommon.length() - 1) != '\'' && newPreCommon.charAt(newPreCommon.length() - 1) != '-') {
                                newPreCommon = newPreCommon + " ";
                            }
                            newPreCommon = newPreCommon + temp2;
                            mainAddressInfo.getComponent(4).addToAddressComponent(newPreCommon);
                            break;
                        }
                        case 5: {
                            mainAddressInfo.getComponent(4).addToAddressComponent(realNumber);
                            break;
                        }
                        case 12: {
                            mainAddressInfo.getComponent(2).addToAddressComponent(realNumber);
                            break;
                        }
                        case 6: {
                            temp2 = mainAddressInfo.getComponent(6).getAddressComponentString();
                            mainAddressInfo.getComponent(6).reset();
                            newPostCommon = realNumber;
                            if (newPostCommon != null && newPostCommon.length() > 0 && newPostCommon.charAt(newPostCommon.length() - 1) != '\'' && newPostCommon.charAt(newPostCommon.length() - 1) != '-') {
                                newPostCommon = newPostCommon + " ";
                            }
                            newPostCommon = newPostCommon + temp2;
                            mainAddressInfo.getComponent(6).addToAddressComponent(newPostCommon);
                            break;
                        }
                    }
                    continue;
                }
                tempMainAddress = mainAddressInfo.getComponent(3).getAddressComponentString();
                mainAddressInfo.getComponent(3).reset();
                mainAddressInfo.getComponent(3).addToAddressComponent(thisTerm);
                if (mainAddressInfo.isPresent(5) && !mainAddressInfo.isPresent(12)) {
                    mainAddressInfo.getComponent(12).addToAddressComponent(tempMainAddress);
                } else {
                    mainAddressInfo.getComponent(5).addToAddressComponent(tempMainAddress);
                }
                if (mainAddressInfo.isPresent(2)) {
                    tempPostStreetCommon = mainAddressInfo.getComponent(2).getAddressComponentString();
                    mainAddressInfo.getComponent(2).reset();
                    mainAddressInfo.getComponent(11).addToAddressComponent(tempPostStreetCommon);
                }
                lastType = 3;
                continue;
            }
            if (forceThisTermToCommon || FRA_AddressTerm.isCommonTerm(thisTerm)) {
                switch (lastType) {
                    case -1: 
                    case 6: {
                        mainAddressInfo.getComponent(6).addToAddressComponent(thisTerm);
                        lastType = 6;
                        break;
                    }
                    case 5: {
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm);
                        lastType = 4;
                        break;
                    }
                    case 4: {
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm);
                        lastType = 4;
                        break;
                    }
                    case 12: {
                        mainAddressInfo.getComponent(11).addToAddressComponent(thisTerm);
                        lastType = 11;
                        break;
                    }
                    case 11: {
                        mainAddressInfo.getComponent(11).addToAddressComponent(thisTerm);
                        lastType = 11;
                        break;
                    }
                    case 3: {
                        mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm);
                        lastType = 2;
                        break;
                    }
                    case 2: {
                        mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm);
                        lastType = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        if (lastTypeDodgyNumber == -99) {
                            mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm);
                            lastType = 2;
                            break;
                        }
                        if (lastTypeDodgyNumber != 5) continue block56;
                        oldHouseNumber = mainAddressInfo.getComponent(0).getAddressComponentString();
                        mainAddressInfo.getComponent(0).reset();
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm);
                        newPreAddressCommon = mainAddressInfo.getComponent(4).getAddressComponentString();
                        mainAddressInfo.getComponent(4).reset();
                        if (newPreAddressCommon == null) {
                            newPreAddressCommon = new String();
                        }
                        if (newPreAddressCommon != null && newPreAddressCommon.length() > 0 && newPreAddressCommon.charAt(newPreAddressCommon.length() - 1) != '\'' && newPreAddressCommon.charAt(newPreAddressCommon.length() - 1) != '-') {
                            newPreAddressCommon = newPreAddressCommon + " ";
                        }
                        if ((tempOldHouseNumber = FRA_NumberTerm.lookupNumber(oldHouseNumber)) != null && !tempOldHouseNumber.equals("")) {
                            oldHouseNumber = tempOldHouseNumber;
                        }
                        newPreAddressCommon = newPreAddressCommon + oldHouseNumber;
                        mainAddressInfo.getComponent(4).addToAddressComponent(newPreAddressCommon);
                        lastType = 4;
                        lastTypeDodgyNumber = -99;
                        break;
                    }
                    case 8: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Error while switching on common term, the last type was set to punctuation");
                        break;
                    }
                    default: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Unknown lastType whilst sorting through a precommon: " + lastType + " term: " + thisTerm);
                        break;
                    }
                }
                continue;
            }
            if (FRA_AddressTerm.isRomanNumber(thisTerm)) {
                switch (lastType) {
                    case -1: {
                        mainAddressInfo.getComponent(7).addToAddressComponent(thisTerm);
                        lastType = 7;
                        break;
                    }
                    case 6: {
                        mainAddressInfo.getComponent(6).addToAddressComponent(thisTerm, 10);
                        lastType = 6;
                        break;
                    }
                    case 5: {
                        mainAddressInfo.getComponent(12).addToAddressComponent(thisTerm);
                        lastType = 12;
                        break;
                    }
                    case 4: {
                        mainAddressInfo.getComponent(4).addToAddressComponent(thisTerm, 10);
                        lastType = 4;
                        break;
                    }
                    case 12: {
                        mainAddressInfo.getComponent(12).addToAddressComponent(thisTerm, 10);
                        lastType = 12;
                        break;
                    }
                    case 11: {
                        mainAddressInfo.getComponent(11).addToAddressComponent(thisTerm, 10);
                        lastType = 11;
                        break;
                    }
                    case 3: {
                        mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm, 10);
                        lastType = 2;
                        break;
                    }
                    case 2: {
                        mainAddressInfo.getComponent(2).addToAddressComponent(thisTerm, 10);
                        lastType = 2;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        if (!this.debug) continue block56;
                        MMJLog.getLog().debug("Unknown lastType whilst looking at punctuation");
                        break;
                    }
                }
                continue;
            }
            v1 = lastTermWasMonth = FRA_AddressTerm.isMonth(thisTerm) != false ? i : -99;
            if (mainAddressInfo.isPresent(5)) {
                if (mainAddressInfo.isPresent(3)) {
                    if (mainAddressInfo.isPresent(15)) break;
                    mainAddressInfo.getComponent(15).addToAddressComponent(thisTerm, 15);
                    break;
                }
                temp = null;
                if (mainAddressInfo.isPresent(11) && mainAddressInfo.getComponent(11).getAddressComponentString() != null && !mainAddressInfo.getComponent(11).getAddressComponentString().equals("")) {
                    temp = mainAddressInfo.getComponent(11).getAddressComponentString();
                    mainAddressInfo.getComponent(11).reset();
                    thisTerm = new String(thisTerm + " " + temp);
                }
                mainAddressInfo.getComponent(12).addToAddressComponent(thisTerm);
                lastType = 12;
                continue;
            }
            mainAddressInfo.getComponent(5).addToAddressComponent(thisTerm);
            lastType = 5;
        }
        return mainAddressInfo;
    }

    private void removeJunk(LinkedList listOfTokens) {
        int i;
        this.debug("removeJunk: List = " + listOfTokens.toString());
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            int n;
            String term = (String)listOfTokens.get(i);
            if (term.equalsIgnoreCase("B")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("P")) {
                            this.obsPostcode = true;
                            end = n++;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                end = n++;
                            }
                            if (n < listOfTokens.size()) {
                                String temp = (String)listOfTokens.get(n);
                                if (temp != null && temp.equals(" ")) {
                                    ++n;
                                }
                                if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                    end = n;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if (term.equalsIgnoreCase("Boite") || term.equalsIgnoreCase("Bo\ufffdte")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("Postale")) {
                            end = n++;
                            this.obsPostcode = true;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                end = n++;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("CEDEX")) {
                this.obsPostcode = true;
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BP")) {
                this.obsPostcode = true;
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BOITEPOSTALE") || term.equalsIgnoreCase("Bo\ufffdtePOSTALE")) {
                this.obsPostcode = true;
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("ARM\ufffdES")) {
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("NAVY")) {
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        end = n++;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("AIR")) {
                start = i;
                end = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            }
            if (end > 0) break;
        }
        this.debug("removeJunk: POBOX start = " + start);
        this.debug("removeJunk: POBOX end = " + end);
        if (start >= 0 && end > 0 && start <= end) {
            for (i = start; i <= end; ++i) {
                this.debug("removeJunk: Removing " + listOfTokens.get(start));
                listOfTokens.remove(start);
            }
        }
    }

    public static boolean isAlpha(char ch) {
        char c = Character.toUpperCase(ch);
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isValidNumberFormat(String num, int len) {
        boolean bRc = true;
        if (num == null || num.trim().length() == 0) {
            return false;
        }
        if (num.trim().length() == len) {
            for (int i = 0; i < num.length(); ++i) {
                char ch = num.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                bRc = false;
                break;
            }
        } else {
            bRc = false;
        }
        return bRc;
    }
}

