/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.FRA.FRA_LocaliserProperties;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_Abbreviations;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class FRA_ParsePostAddressRule
implements IParseRule {
    public static final int POST_CODE_INVALID = 0;
    public static final int POST_CODE_FULL = 3;
    public static final int POST_CODE_PARTIAL = 4;
    public static final String SHORT_AREANAME4 = "SHORT_AREANAME4";
    private static final int VALID_POSTCODE_LENGTH = FRA_LocaliserProperties.getPostCodeLength();
    private static MultiWordAreaNameComparator multiWordAreaNameComparator;
    private String originalAreaName1;
    private String originalAreaName2;
    private String originalAreaName4;
    private static final String punctuations = " ()-/.,\\'";
    private static String[] countryNames;
    private static String[] multiWordAreaNames;
    private boolean obsPostcode = false;
    private boolean debug = false;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String shortTownName;
        String townName;
        StringTokenizer tokens;
        String shortAreaName4;
        this.originalAreaName1 = pa.getAreaName1();
        this.originalAreaName2 = pa.getAreaName2();
        this.originalAreaName4 = pa.getAreaName4();
        if (this.originalAreaName4 != null && !this.originalAreaName4.equals("") && (shortAreaName4 = FRA_ParsePostAddressRule.removeCommonWords(this.originalAreaName4, true)) != null && !shortAreaName4.equals("")) {
            HashMap<String, String> addFields = pa.getAdditionalFields();
            if (addFields != null) {
                addFields = new HashMap<String, String>(1);
            }
            addFields.put(SHORT_AREANAME4, shortAreaName4);
            pa.setAdditionalFields(addFields);
        }
        LinkedList listOfTokens = null;
        this.obsPostcode = false;
        if (pa.getPostAddress() != null && pa.getPostAddress().trim().length() > 0) {
            tokens = new StringTokenizer(pa.getPostAddress(), punctuations, true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            this.removeJunk(listOfTokens);
            listOfTokens = this.removeCountry(listOfTokens);
            this.seperatePostcode(listOfTokens, pa);
            pa.setPostAddress(null);
        } else {
            if (pa.getPostCode1() != null && pa.getPostCode1().trim().length() > 0) {
                tokens = new StringTokenizer(pa.getPostCode1());
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                this.seperatePostcode(listOfTokens, pa);
            }
            String allTownNamesBeforeParsing = pa.getAreaName3();
            pa.setGenericField1(allTownNamesBeforeParsing);
            if (allTownNamesBeforeParsing != null && allTownNamesBeforeParsing.trim().length() > 0) {
                StringTokenizer tokens2 = new StringTokenizer(allTownNamesBeforeParsing, punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens2);
            }
        }
        if (listOfTokens != null) {
            this.debug("List before cleanTown: " + listOfTokens.toString());
            this.removeJunk(listOfTokens);
            this.cleanTown(listOfTokens);
            this.debug("List after cleanTown: " + listOfTokens.toString());
            this.seperateTown(listOfTokens, pa);
        }
        if ((townName = pa.getAreaName3()) != null) {
            townName = FRA_Abbreviations.expandAbbreviations(townName);
            pa.setAreaName3(townName);
        }
        if (this.obsPostcode) {
            pa.setPostCode1(null);
        }
        if (this.originalAreaName1 != null && !this.originalAreaName1.equals("")) {
            pa.setAreaName1(this.originalAreaName1);
        }
        if (this.originalAreaName2 != null && !this.originalAreaName2.equals("")) {
            pa.setAreaName2(this.originalAreaName2);
        }
        if (this.originalAreaName4 != null && !this.originalAreaName4.equals("")) {
            pa.setAreaName4(this.originalAreaName4);
        }
        if ((shortTownName = FRA_ParsePostAddressRule.removeCommonWords(pa.getAreaName3(), true)) != null && !shortTownName.equals("")) {
            HashMap<String, String> addFields = pa.getAdditionalFields();
            if (addFields == null) {
                addFields = new HashMap<String, String>(1);
            }
            addFields.put(SHORT_AREANAME4, shortTownName);
            pa.setAdditionalFields(addFields);
        }
        if (!(pa.getPostCode1() != null && pa.getPostCode1().trim().length() != 0 || pa.getAreaName3() != null && pa.getAreaName3().trim().length() != 0)) {
            throw new ParserException(2000);
        }
    }

    private void seperatePostcode(LinkedList listOfTokens, Address pa) {
        String postcode;
        if (listOfTokens == null || listOfTokens.size() == 0) {
            this.debug("seperatePostcode: empty token");
            return;
        }
        int len = listOfTokens.size();
        boolean partPostcode = false;
        StringBuffer postBuf = new StringBuffer();
        this.debug("seperatePostcode: List: " + listOfTokens.toString());
        for (int i = 0; i < len; ++i) {
            String temp = (String)listOfTokens.get(i);
            if (temp.equals(" ")) continue;
            if (StringUtilities.isNumeric((String)temp)) {
                if (postBuf.length() < VALID_POSTCODE_LENGTH && partPostcode) {
                    if (temp.length() > VALID_POSTCODE_LENGTH - postBuf.length()) {
                        listOfTokens.set(i, temp.substring(VALID_POSTCODE_LENGTH - postBuf.length()));
                        postBuf.append(temp.substring(0, VALID_POSTCODE_LENGTH - postBuf.length()));
                    } else {
                        postBuf.append(temp.substring(0));
                        listOfTokens.remove(i);
                        --len;
                    }
                    partPostcode = true;
                } else if (temp.length() > VALID_POSTCODE_LENGTH) {
                    postBuf.append(temp.substring(0, VALID_POSTCODE_LENGTH));
                    listOfTokens.set(i, temp.substring(VALID_POSTCODE_LENGTH));
                    partPostcode = false;
                } else {
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    partPostcode = true;
                }
                if (postBuf.length() != VALID_POSTCODE_LENGTH) continue;
                break;
            }
            partPostcode = false;
        }
        if ((postcode = postBuf.toString().trim()) != null && postcode.length() > 0) {
            pa.setPostCode1(postBuf.toString());
        } else {
            pa.setPostCode1(null);
        }
    }

    private void seperateTown(LinkedList listOfTokens, Address pa) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            this.debug("seperateTown: List empty");
            return;
        }
        boolean inBrackets = false;
        StringBuffer townBuff = new StringBuffer();
        StringBuffer origTownBuff = new StringBuffer();
        int lastAddition = -3;
        int wordCount = 0;
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            origTownBuff.append(term);
            if (term.equals("(")) {
                this.debug("seperateTown: Found (, ommiting it");
                inBrackets = true;
                continue;
            }
            if (term.equals(")")) {
                this.debug("seperateTown: Found ), ommiting it");
                inBrackets = false;
                continue;
            }
            if (FRA_AddressTerm.isPunctuation(term)) {
                this.debug("seperateTown: Found punctuation, replacing with space in buffer");
                if (lastAddition != i - 1) continue;
                townBuff.append(" ");
                continue;
            }
            if (FRA_AddressTerm.isCommonTerm(term)) {
                this.debug("seperateTown: Found common term, ommiting it");
                continue;
            }
            if (inBrackets) {
                this.debug("seperateTown: Term is in Brackets, ommiting it");
                continue;
            }
            this.debug("seperateTown: Adding " + term + " to areanames");
            townBuff.append(term);
            ++wordCount;
            lastAddition = i;
        }
        String shortTown = townBuff.toString().trim();
        boolean foundMultiWordTown = false;
        StringTokenizer strTok = null;
        String temp = new String();
        String fullTemp = new String();
        if (wordCount < 2) {
            this.clearAllAreaNames(pa);
            pa.setGenericField1(origTownBuff.toString());
            if (wordCount > 0 && !shortTown.equalsIgnoreCase(origTownBuff.toString())) {
                pa.setAreaName3(shortTown);
                pa.setGenericField1(origTownBuff.toString());
            } else {
                pa.setAreaName3(origTownBuff.toString());
            }
            return;
        }
        if (this.isMultiWordAreaName(shortTown)) {
            this.clearAllAreaNames(pa);
            pa.setAreaName3(shortTown);
            pa.setGenericField1(origTownBuff.toString());
            return;
        }
        if (wordCount > 2) {
            strTok = new StringTokenizer(shortTown);
            int len = strTok.countTokens();
            for (int i = 0; i < len; ++i) {
                temp = strTok.nextToken().trim();
                if (temp.equals("")) continue;
                if (foundMultiWordTown) {
                    FRA_ParsePostAddressRule.addStringToAreaNames(temp, pa);
                    continue;
                }
                fullTemp = fullTemp + temp + " ";
                if (i == 0 || !this.isMultiWordAreaName(fullTemp.trim())) continue;
                this.clearAllAreaNames(pa);
                pa.setAreaName3(fullTemp.trim());
                pa.setGenericField1(origTownBuff.toString());
                foundMultiWordTown = true;
            }
            if (!foundMultiWordTown) {
                temp = "";
                fullTemp = "";
                strTok = new StringTokenizer(shortTown);
                len = strTok.countTokens();
                LinkedList tokenList = StringUtilities.tokensToList((StringTokenizer)strTok);
                for (int i = len - 1; i >= 0; --i) {
                    temp = ((String)tokenList.get(i)).trim();
                    if (temp.equals("")) continue;
                    if (foundMultiWordTown) {
                        pa.setAreaName3((pa.getAreaName3() == null ? "" : pa.getAreaName3()) + temp);
                        pa.setGenericField1(pa.getAreaName3() == null ? "" : pa.getAreaName3());
                        continue;
                    }
                    fullTemp = temp + " " + fullTemp;
                    if (i == len - 1 || !this.isMultiWordAreaName(fullTemp.trim())) continue;
                    this.clearAllAreaNames(pa);
                    if (this.originalAreaName2 != null && !"".equals(this.originalAreaName2)) {
                        pa.setAreaName2(this.originalAreaName2);
                    } else {
                        pa.setAreaName2(fullTemp.toString());
                    }
                    foundMultiWordTown = true;
                }
            }
        } else {
            strTok = new StringTokenizer(shortTown);
            this.clearAllAreaNames(pa);
            while (strTok.hasMoreTokens()) {
                FRA_ParsePostAddressRule.addStringToAreaNames(strTok.nextToken(), pa);
            }
            pa.setGenericField1(origTownBuff.toString());
        }
        if (pa.getAreaName3() == null) {
            pa.setAreaName3(origTownBuff.toString());
        }
    }

    private void cleanTown(LinkedList listOfTokens) {
        String term;
        while (listOfTokens.size() > 0 && FRA_AddressTerm.isPunctuation(term = (String)listOfTokens.getFirst())) {
            listOfTokens.removeFirst();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the beggining");
        }
        while (listOfTokens.size() > 0 && FRA_AddressTerm.isPunctuation(term = (String)listOfTokens.getLast())) {
            listOfTokens.removeLast();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the end");
        }
    }

    public static String removeCommonWords(String inTown, boolean removePunctuation) {
        if (inTown == null || inTown.trim().length() == 0) {
            return null;
        }
        StringBuffer outTown = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inTown, " ()/.,\\-'_", true);
        char lastPunctuation = '\u0000';
        boolean hadProperWord = false;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.length() == 1) {
                if (!FRA_AddressTerm.isPunctuation(temp.charAt(0))) continue;
                if (!removePunctuation) {
                    if (lastPunctuation != temp.charAt(0)) {
                        outTown.append(temp);
                    }
                    lastPunctuation = temp.charAt(0);
                    continue;
                }
                if (hadProperWord) {
                    outTown.append(" ");
                }
                hadProperWord = false;
                continue;
            }
            if (FRA_AddressTerm.isCommonTerm(temp)) continue;
            outTown.append(temp);
            lastPunctuation = '\u0000';
            hadProperWord = true;
        }
        String shortTown = outTown.toString().trim();
        if (shortTown.length() > 0) {
            while (shortTown.length() > 0 && FRA_AddressTerm.isPunctuation(shortTown.substring(0, 1))) {
                shortTown = shortTown.substring(1);
            }
        }
        if (shortTown.length() == 0) {
            return null;
        }
        return shortTown;
    }

    public static String cleanTown(String name) {
        if (name != null) {
            StringTokenizer st = new StringTokenizer(name, " -_/\\");
            StringBuffer buf = new StringBuffer(name.length() + 5);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken();
                if ((temp.startsWith("D\ufffd") || temp.startsWith("d\ufffd") || temp.startsWith("Di") || temp.startsWith("di")) && temp.length() > 2) {
                    String temp1 = temp.substring(0, 2);
                    String temp2 = temp.substring(2);
                    buf.append(temp1);
                    buf.append(' ');
                    buf.append(temp2);
                    continue;
                }
                buf.append(temp);
                if (!st.hasMoreTokens()) continue;
                buf.append(' ');
            }
            return buf.toString();
        }
        return null;
    }

    private LinkedList removeCountry(LinkedList listOfTokens) {
        boolean countryCodeFound = false;
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < listOfTokens.size(); ++n) {
            String temp = (String)listOfTokens.get(n);
            if (this.isCountry(temp)) {
                this.debug("removeCountry: Found country space, removing it");
                countryCodeFound = true;
                continue;
            }
            countryCodeFound = false;
            if (temp.equals("-") && countryCodeFound) {
                this.debug("removeCountry:Found '-', removing it");
                continue;
            }
            if (temp.length() >= 3 && this.isCountry(temp.substring(0, 3)) && temp.length() > 3 && StringUtilities.isNumeric((String)temp.substring(3, 4))) {
                this.debug("removeCountry: '[CountryName]####' Found, setting tokens to ####");
                buff.append(temp.substring(3));
                continue;
            }
            buff.append(temp);
        }
        String newPostAddress = buff.toString().trim();
        this.debug("removeCountry: After processing : " + newPostAddress);
        if (newPostAddress == null || newPostAddress.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(buff.toString().trim(), punctuations, true);
        return StringUtilities.tokensToList((StringTokenizer)tokens);
    }

    public static void addStringToAreaNames(String s, Address pa) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (pa.getAreaName3() == null || pa.getAreaName3().length() == 0) {
            pa.setAreaName3(s);
        } else if (pa.getAreaName2() == null || pa.getAreaName2().length() == 0) {
            pa.setAreaName2(s);
        } else if (pa.getAreaName4() == null || pa.getAreaName4().length() == 0) {
            pa.setAreaName4(s);
        }
    }

    public static int getPostCodeType(String postCode) {
        if (postCode.length() == 5) {
            return 3;
        }
        if (postCode.length() >= 2) {
            return 4;
        }
        return 0;
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void clearAllAreaNames(Address pa) {
        pa.setAreaName1(null);
        pa.setAreaName2(null);
        pa.setAreaName3(null);
        pa.setAreaName4(null);
    }

    protected String createTownName(Address address) {
        if (address == null) {
            return null;
        }
        String result = "";
        if (address.getAreaName3() != null) {
            result = result + address.getAreaName3() + " ";
        }
        if (address.getAreaName4() != null) {
            result = result + address.getAreaName4() + " ";
        }
        if (address.getAreaName2() != null) {
            result = result + address.getAreaName2() + " ";
        }
        if (address.getAreaName1() != null) {
            result = result + address.getAreaName1() + " ";
        }
        if (result == null || result.trim().length() == 0) {
            return null;
        }
        return result.trim();
    }

    public boolean isCountry(String country) {
        for (int i = 0; i < countryNames.length; ++i) {
            if (!country.equalsIgnoreCase(countryNames[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isMultiWordAreaName(String areaName) {
        if (areaName == null || multiWordAreaNames == null) {
            return false;
        }
        int ndx = Arrays.binarySearch(multiWordAreaNames, areaName.toUpperCase(), multiWordAreaNameComparator);
        return ndx >= 0;
    }

    private void removeJunk(LinkedList listOfTokens) {
        int i;
        this.debug("removeJunk: List = " + listOfTokens.toString());
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            int n;
            String term = (String)listOfTokens.get(i);
            if (term.equalsIgnoreCase("B")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("P")) {
                            ++n;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            }
            if (term.equalsIgnoreCase("Boite") || term.equalsIgnoreCase("Bo\ufffdte")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("Postale")) {
                            ++n;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("CEDEX")) {
                this.obsPostcode = true;
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BP")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BOITEPOSTAL") || term.equalsIgnoreCase("Bo\ufffdtePOSTALE")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("ARM\ufffdES")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("NAVY")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("AIR")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FRA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            }
            if (end > 0) break;
        }
        this.debug("removeJunk: POBOX start = " + start);
        this.debug("removeJunk: POBOX end = " + end);
        if (start >= 0 && end > 0 && start < end) {
            for (i = start; i <= end; ++i) {
                this.debug("removeJunk: Removing " + listOfTokens.get(start));
                listOfTokens.remove(start);
            }
        }
    }

    static {
        countryNames = FRA_LocaliserProperties.getPostCodePrefixes();
        multiWordAreaNames = null;
        String filename = "com/mapinfo/mapmarker/FRA/parser/FRA_MultiWordAreaNames.properties";
        BufferedReader br = null;
        multiWordAreaNameComparator = new MultiWordAreaNameComparator();
        Properties properties = new Properties();
        try {
            properties.load(FRA_ParsePostAddressRule.class.getResourceAsStream("FRA_MultiWordAreaNames.properties"));
            InputStream is = FRA_ParsePostAddressRule.class.getResourceAsStream("FRA_MultiWordAreaNames.properties");
            br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> multiWordAreaNameList = new ArrayList<String>();
            String s = null;
            while ((s = br.readLine()) != null) {
                multiWordAreaNameList.add(s.toUpperCase());
            }
            multiWordAreaNames = multiWordAreaNameList.toArray(new String[multiWordAreaNameList.size()]);
            Arrays.sort(multiWordAreaNames, multiWordAreaNameComparator);
        }
        catch (FileNotFoundException fx) {
            System.err.println("Could not find " + filename);
            System.exit(1);
        }
        catch (IOException iox) {
            System.err.println("Could not read " + filename);
            System.exit(1);
        }
        catch (Throwable trw) {
            trw.printStackTrace();
            System.err.println(trw.getMessage());
            System.exit(1);
        }
    }

    private static class MultiWordAreaNameComparator
    implements Comparator {
        private Collator collator;

        public MultiWordAreaNameComparator() {
            try {
                RuleBasedCollator accentInsensitiveCollator = (RuleBasedCollator)Collator.getInstance(new Locale("fr", "FR"));
                accentInsensitiveCollator.setDecomposition(1);
                accentInsensitiveCollator.setStrength(0);
                this.collator = new RuleBasedCollator(accentInsensitiveCollator.getRules() + FRA_AddressTerm.getCollatorRules());
            }
            catch (ParseException e) {
                e.printStackTrace();
                this.collator = Collator.getInstance(new Locale("fr", "FR"));
            }
            this.collator.setDecomposition(1);
            this.collator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            return this.collator.compare(o1, o2);
        }
    }
}

