/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA;

import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.ITA.ITA_StreetCandidateAddress;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_Abbreviations;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_AddressTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.StringTokenizer;

public class ITA_ScoringAddress
extends EMEA_ScoringAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "pre_main_address_common";
    public static final double THOROUGHFARE_TYPE_THRESHOLD = 0.99;

    public ITA_ScoringAddress(Address addr) {
        super(addr);
    }

    public double scorePostAddress(String parsedAddress) {
        double postscore;
        double score = 0.0;
        score = this.scoreItems(parsedAddress, this.getPostAddress());
        if (score != 1.0 && parsedAddress != null && (postscore = this.scoreItems(parsedAddress, this.getPreAddress())) > score) {
            score = postscore;
        }
        if (score != 1.0) {
            String str1 = parsedAddress;
            String str2 = this.getPostAddress();
            if (str1 != null && str1.trim().length() > 0 && str2 != null && str2.trim().length() > 0) {
                boolean romanTermExistInStr1 = false;
                boolean romanTermExistInStr2 = false;
                StringTokenizer st1 = new StringTokenizer(str1, " ", false);
                String temp = null;
                while (!romanTermExistInStr1 && st1.hasMoreTokens()) {
                    temp = st1.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr1 = true;
                        continue;
                    }
                    if (!ITA_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr1 = true;
                }
                temp = null;
                StringTokenizer st2 = new StringTokenizer(str2, " ", false);
                while (!romanTermExistInStr2 && st2.hasMoreTokens()) {
                    temp = st2.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr2 = true;
                    }
                    if (!ITA_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr2 = true;
                }
                if (romanTermExistInStr2 && romanTermExistInStr1 && (score *= 1.21) > 1.0) {
                    score = 1.0;
                }
            }
        }
        return score;
    }

    public double scoreMainAddress(StreetCandidateAddress cand) {
        double score = 0.0;
        String parsedMainAddress = this.getMainAddress();
        String candidateMainAddress = cand.getMainAddress();
        boolean hasCandidateMainAddressAbbrevation = ITA_Abbreviations.hasAbbreviation(candidateMainAddress);
        score = hasCandidateMainAddressAbbrevation ? this.scoreItems(parsedMainAddress.substring(0, 1), candidateMainAddress.substring(0, 1)) : this.scoreItems(parsedMainAddress.toUpperCase(), candidateMainAddress.toUpperCase());
        return score;
    }

    public double scorePreAddress(StreetCandidateAddress cand) {
        double preAddressScore = 0.0;
        String parsedPreAddress = this.getPreAddress();
        String candPreAddress = cand.getPreAddress();
        if (parsedPreAddress != null && parsedPreAddress.length() == 0 || candPreAddress != null && candPreAddress.length() == 0) {
            preAddressScore = 0.8;
        } else {
            String candidatePreAddressFull;
            String parsedPreAddressFull;
            double score;
            String str2;
            String str1;
            double scorepreAddr = this.scoreItems(candPreAddress, parsedPreAddress);
            if (scorepreAddr != 1.0) {
                StringTokenizer st;
                str1 = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
                str2 = this.getPreAddress();
                if (str1 != null && str2 != null && candPreAddress == null) {
                    st = new StringTokenizer(str1);
                    if ((str1 = st.nextToken().toUpperCase()).charAt(0) == str2.charAt(0)) {
                        if (str1.length() == 1) {
                            scorepreAddr = 1.0;
                        } else if (str1.endsWith(".")) {
                            scorepreAddr = str1.length() == 2 ? 1.0 : 0.75 * this.scoreItems(str1, str2);
                        }
                    }
                } else {
                    str1 = candPreAddress;
                    str2 = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
                    if (str1 != null && str2 != null && this.getPreAddress() == null) {
                        st = new StringTokenizer(str2);
                        str2 = st.nextToken();
                        if (str1.charAt(0) == str2.charAt(0)) {
                            if (str2.length() == 1) {
                                scorepreAddr = 1.0;
                            } else if (str2.endsWith(".")) {
                                scorepreAddr = str2.length() == 2 ? 1.0 : 0.75 * this.scoreItems(str1, str2);
                            }
                        }
                    }
                }
            }
            if (scorepreAddr != 1.0) {
                str1 = candPreAddress;
                str2 = this.getPreAddress();
                if (str1 != null && str1.trim().length() > 0 && str2 != null && str2.trim().length() > 0) {
                    boolean romanTermExistInStr1 = false;
                    boolean romanTermExistInStr2 = false;
                    StringTokenizer st1 = new StringTokenizer(str1, " ", false);
                    String temp = null;
                    while (!romanTermExistInStr1 && st1.hasMoreTokens()) {
                        temp = st1.nextToken();
                        if (StringUtilities.isNumeric((String)temp)) {
                            romanTermExistInStr1 = true;
                            continue;
                        }
                        if (!ITA_AddressTerm.isRomanNumber(temp)) continue;
                        romanTermExistInStr1 = true;
                    }
                    temp = null;
                    StringTokenizer st2 = new StringTokenizer(str2, " ", false);
                    while (!romanTermExistInStr2 && st2.hasMoreTokens()) {
                        temp = st2.nextToken();
                        if (StringUtilities.isNumeric((String)temp)) {
                            romanTermExistInStr2 = true;
                        }
                        if (!ITA_AddressTerm.isRomanNumber(temp)) continue;
                        romanTermExistInStr2 = true;
                    }
                    if (romanTermExistInStr2 && romanTermExistInStr1 && (scorepreAddr *= 1.15) > 1.0) {
                        scorepreAddr = 1.0;
                    }
                }
            }
            if ((preAddressScore = scorepreAddr) != 1.0 && (score = this.scoreItems(parsedPreAddressFull = CHE_InternalCandidateAddress.getFormattedPreAddress((Address)this), candidatePreAddressFull = CHE_InternalCandidateAddress.getFormattedPreAddress((Address)cand))) > preAddressScore && score > 0.9) {
                preAddressScore = score;
            }
        }
        return preAddressScore;
    }

    public void scoreThoroughfareType(ScoringAddress input, ITA_StreetCandidateAddress cand) {
        boolean canSwitch = cand.getPreThoroughfareTypeScore() != -1.0 || cand.getPostThoroughfareTypeScore() != -1.0;
        String parsedPreType = input.getPreThoroughfareType();
        String candPreType = this.getPreThoroughfareType();
        String parsedPostType = input.getPostThoroughfareType();
        String candPostType = this.getPostThoroughfareType();
        if (parsedPreType != null && parsedPreType.length() == 0) {
            parsedPreType = null;
        }
        if (candPreType != null && candPreType.length() == 0) {
            candPreType = null;
        }
        if (parsedPostType != null && parsedPostType.length() == 0) {
            parsedPostType = null;
        }
        if (candPostType != null && candPostType.length() == 0) {
            candPostType = null;
        }
        if (parsedPreType == null && parsedPostType == null) {
            if (candPreType != null) {
                if (candPreType.equalsIgnoreCase("via")) {
                    cand.setPreThoroughfareTypeScore(1.0);
                } else {
                    cand.setPreThoroughfareTypeScore(0.99);
                }
            }
            if (candPostType != null) {
                if (candPostType.equalsIgnoreCase("via")) {
                    cand.setPostThoroughfareTypeScore(1.0);
                } else {
                    cand.setPostThoroughfareTypeScore(0.99);
                }
            }
        } else {
            if (candPreType != null) {
                cand.setPreThoroughfareTypeScore(input.scorePreThoroughfareType(candPreType));
            }
            if (candPostType != null) {
                cand.setPostThoroughfareTypeScore(input.scorePostThoroughfareType(candPostType));
            }
            if ((!(cand.getPreThoroughfareTypeScore() < 1.0) || parsedPreType == null) && cand.getPreThoroughfareTypeScore() < 0.99 && parsedPreType == null && candPreType != null) {
                cand.setPreThoroughfareTypeScore(0.99);
            }
            if (!(cand.getPostThoroughfareTypeScore() < 1.0) || parsedPostType != null) {
                // empty if block
            }
            double savedPreTypeScore = cand.getPreThoroughfareTypeScore();
            double savedPostTypeScore = cand.getPostThoroughfareTypeScore();
            if (canSwitch && (savedPreTypeScore < 0.99 || savedPostTypeScore < 0.99) && (candPostType != null || parsedPostType != null)) {
                input.setPreThoroughfareType(parsedPostType);
                input.setPostThoroughfareType(parsedPreType);
                cand.setPreThoroughfareTypeScore(-1.0);
                cand.setPostThoroughfareTypeScore(-1.0);
                this.scoreThoroughfareType(input, cand);
                double newPreTypeScore = cand.getPreThoroughfareTypeScore();
                double newPostTypeScore = cand.getPostThoroughfareTypeScore();
                input.setPreThoroughfareType(parsedPreType);
                input.setPostThoroughfareType(parsedPostType);
                if (!(!(newPreTypeScore < savedPreTypeScore) && !(newPostTypeScore < savedPostTypeScore) || (newPreTypeScore >= 0.99 || newPostTypeScore > 0.99) && savedPreTypeScore < 0.99 && savedPostTypeScore < 0.99)) {
                    cand.setPreThoroughfareTypeScore(savedPreTypeScore);
                    cand.setPostThoroughfareTypeScore(savedPostTypeScore);
                }
            }
        }
    }
}

