/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA;

import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.ITA.ITA_LocaliserProperties;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_ParseMainAddressRule;
import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ITA_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private Address savedParsedAddress;
    protected boolean resetParsedAddress;
    private ArrayList preCandOffsets;
    private static final int VALID_POSTCODE_LENGTH = ITA_LocaliserProperties.getPostCodeLength();

    public ITA_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        boolean tryAgain = false;
        if (!this.resetParsedAddress) {
            this.savedParsedAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        } else {
            this.setParsedAddress((Address)new AddressImpl(this.savedParsedAddress));
            this.resetParsedAddress = false;
        }
        Address pa = constraints.getHandler().getParsedAddress();
        ArrayList preCands = null;
        preCands = (ArrayList)constraints.getHandler().getIntermediateMatchResults();
        int candSize = 0;
        if (preCands != null) {
            candSize = preCands.size();
        }
        if (this.m_currentCase > 0 && preCands != null && candSize > 0) {
            if (this.preCandOffsets == null) {
                this.preCandOffsets = new ArrayList();
            }
            for (int i = 0; i < candSize; ++i) {
                Long streetOffset = new Long(((CHE_InternalCandidateAddress)((Object)preCands.get(i))).getStreetOffset());
                if (!this.preCandOffsets.contains(streetOffset)) {
                    this.preCandOffsets.add(streetOffset);
                }
                if (this.preCandOffsets.size() <= 0) continue;
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
            }
            constraints.setCustomObject((Object)"KEY_STREETS_TO_REMOVE", (Object)this.preCandOffsets);
        }
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                boolean sacMustMatchGeoAndPostal = new Boolean(constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
                if (sacMustMatchGeoAndPostal) {
                    constraints.removeCustomObject((Object)"KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    return true;
                }
            }
            case 1: {
                ++this.m_currentCase;
                boolean bSearchAreaName1 = new Boolean(constraints.getCustomString("KEY_GEOBASE_FOR_AREA1"));
                if (!(bSearchAreaName1 || pa.getAreaName1() == null && pa.getAreaName2() == null)) {
                    constraints.setCustomString("KEY_GEOBASE_FOR_AREA1", "true");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA3");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    return true;
                }
            }
            case 2: {
                ++this.m_currentCase;
                boolean bSearchAreaName4 = new Boolean(constraints.getCustomString("KEY_GEOBASE_FOR_AREA1"));
                if (!bSearchAreaName4) {
                    constraints.setCustomString("KEY_GEOBASE_FOR_AREA4", "true");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA3");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA1");
                    return true;
                }
            }
            case 3: {
                ++this.m_currentCase;
                boolean sacMustMatchGeoAndPostal = new Boolean(constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
                if (sacMustMatchGeoAndPostal) {
                    constraints.removeCustomObject((Object)"KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    return true;
                }
            }
            case 4: {
                ++this.m_currentCase;
                boolean bStringKey = new Boolean(constraints.getCustomString("KEY_GEOBASE_STRING_ONLY"));
                if (bStringKey) {
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_STRING_ONLY");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA1");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                    constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.m_currentCase = 0;
                    return true;
                }
            }
            case 5: {
                constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA1");
                constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
                boolean sacMustMatchGeoAndPostal = new Boolean(constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL"));
                if (!(sacMustMatchGeoAndPostal || pa.getPostCode1() == null || pa.getAreaName3() == null && pa.getAreaName1() == null && pa.getAreaName2() == null)) {
                    constraints.setCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL", "true");
                }
                ++this.m_currentCase;
                if (pa.getPreAddress() != null && pa.getPreAddress().trim().length() > 0) {
                    String temp = pa.getMainAddress();
                    if (pa.hasAdditionalFields() && pa.getAdditionalFields().get("pre_main_address_common") != null) {
                        temp = pa.getAdditionalFields().get("pre_main_address_common") + " " + temp;
                    }
                    pa.setPostAddress(temp);
                    pa.setMainAddress(pa.getPreAddress());
                    pa.setPreAddress((String)pa.getAdditionalFields().get("post_st_type_common"));
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    tryAgain = true;
                    this.resetParsedAddress = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 6: {
                ++this.m_currentCase;
                String addrNum = pa.getAddressNumber();
                if (pa.getPostAddress() == null && addrNum != null) {
                    StringTokenizer st = new StringTokenizer(addrNum, "-");
                    if (st.hasMoreTokens()) {
                        addrNum = st.nextToken();
                    }
                    try {
                        List candList;
                        IRetrievedCandidates candidates = constraints.getHandler().getDataManager().retrieveCandidates(pa, this.getScoringHelper().makeScoringAddress(pa, constraints, constraints.getHandler()), constraints);
                        if (candidates != null && (candList = candidates.getCandidates()) != null) {
                            Iterator it = candList.iterator();
                            boolean hasNumeric = false;
                            while (it.hasNext()) {
                                CHE_InternalCandidateAddress cand = (CHE_InternalCandidateAddress)((Object)it.next());
                                String postAddr = cand.getPostAddress();
                                if (postAddr == null || !StringUtilities.isNumeric((String)postAddr)) continue;
                                hasNumeric = true;
                                break;
                            }
                            if (hasNumeric) {
                                pa.setAddressNumber((String)null);
                                pa.setPostAddress(addrNum);
                                String upHnr = (String)pa.getAdditionalFields().get("unparsed_hnr");
                                if (upHnr != null && upHnr.trim().length() > addrNum.length()) {
                                    upHnr = upHnr.substring(addrNum.length());
                                    String newHnr = ITA_ParseMainAddressRule.getProperHouseNumber(upHnr);
                                    if (upHnr != null) {
                                        pa.setAddressNumber(newHnr);
                                    }
                                }
                                this.setSearchParsedAddress(pa);
                                this.setParsedAddress(pa);
                                tryAgain = true;
                                this.resetParsedAddress = true;
                                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                    catch (FatalDataAccessException fex) {
                        fex.printStackTrace();
                        throw new RuntimeException(fex);
                    }
                }
            }
            case 7: {
                ++this.m_currentCase;
                if (pa.getGenericField2() != null && pa.getGenericField2().trim().length() > 0) {
                    AddressImpl newInput = new AddressImpl();
                    newInput.setMainAddress(pa.getGenericField2());
                    newInput.setAreaName1(pa.getAreaName1());
                    newInput.setAreaName2(pa.getAreaName2());
                    newInput.setAreaName3(pa.getAreaName3());
                    newInput.setAreaName4(pa.getAreaName4());
                    newInput.setPostCode1(pa.getPostCode1());
                    newInput.setCountry(pa.getCountry());
                    try {
                        pa = ((CoreHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                    }
                    catch (ParserException PEx) {
                        pa = null;
                    }
                    if (pa != null) {
                        this.setSearchParsedAddress(pa);
                        this.setParsedAddress(pa);
                        tryAgain = true;
                        this.resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                    pa = constraints.getHandler().getParsedAddress();
                }
            }
            case 8: {
                ++this.m_currentCase;
                if (pa.getGenericField3() != null && pa.getGenericField3().trim().length() > 0) {
                    AddressImpl newInput = new AddressImpl();
                    newInput.setMainAddress(pa.getGenericField3());
                    newInput.setAreaName1(pa.getAreaName1());
                    newInput.setAreaName2(pa.getAreaName2());
                    newInput.setAreaName3(pa.getAreaName3());
                    newInput.setAreaName4(pa.getAreaName4());
                    newInput.setPostCode1(pa.getPostCode1());
                    newInput.setCountry(pa.getCountry());
                    try {
                        pa = ((CoreHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                    }
                    catch (ParserException PEx) {
                        pa = null;
                    }
                    if (pa != null) {
                        this.setSearchParsedAddress(pa);
                        this.setParsedAddress(pa);
                        tryAgain = true;
                        this.resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                    pa = constraints.getHandler().getParsedAddress();
                }
            }
            case 9: {
                AddressImpl newInput;
                ++this.m_currentCase;
                if (pa.getAdditionalFields() != null) {
                    String newMainAddress = (String)pa.getAdditionalFields().get("unparsed_main_address");
                    newInput = new AddressImpl(pa);
                    ITA_ParseMainAddressRule addressRule = new ITA_ParseMainAddressRule();
                    if (newMainAddress != null) {
                        newInput.setMainAddress(addressRule.replaceFullStops(newMainAddress, true));
                    }
                    try {
                        pa = ((CoreHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                    }
                    catch (ParserException PEx) {
                        pa = null;
                    }
                    if (pa != null) {
                        this.setSearchParsedAddress(pa);
                        tryAgain = true;
                        this.resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                    pa = constraints.getHandler().getParsedAddress();
                }
            }
            case 10: {
                ++this.m_currentCase;
                String postcode1 = pa.getPostCode1();
                if (postcode1 == null) break;
                AddressImpl newInput = new AddressImpl(pa);
                if (postcode1.length() < VALID_POSTCODE_LENGTH) {
                    for (int i = 0; i < VALID_POSTCODE_LENGTH - postcode1.length(); ++i) {
                        postcode1 = "0" + postcode1;
                    }
                }
                newInput.setPostCode1(postcode1);
                try {
                    pa = ((CoreHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                }
                catch (ParserException PEx) {
                    pa = null;
                }
                if (pa != null) {
                    this.setSearchParsedAddress(pa);
                    tryAgain = true;
                    this.resetParsedAddress = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
                pa = constraints.getHandler().getParsedAddress();
            }
        }
        return tryAgain;
    }
}

