/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ITA_Abbreviations {
    private static Properties m_abbr = null;
    private static Properties m_words = null;

    public static void load() throws Throwable {
        try {
            if (m_abbr == null) {
                Properties temp = null;
                m_abbr = new Properties();
                temp = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/ITA/parser/ITA_Abbreviations.properties");
                Enumeration<Object> em = temp.keys();
                m_words = new Properties();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    key = key == null ? null : key.toUpperCase();
                    String word = (String)temp.get(key);
                    if (word == null) {
                        word = (String)temp.get(key.toLowerCase());
                        key.toUpperCase();
                    }
                    word = word == null ? null : word.toUpperCase();
                    m_abbr.put(key, word);
                    m_words.put(word, key);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for ITA_Parser.");
        }
    }

    public static boolean isAbbreviation(String abbr) {
        return abbr != null && m_abbr.containsValue(abbr.toUpperCase());
    }

    public static boolean hasAbbreviation(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        return m_abbr.containsKey(term.trim().toUpperCase());
    }

    public static String getAbbreviation(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)m_abbr.get(word.trim().toUpperCase());
    }

    public static boolean containAbbreviations(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!ITA_Abbreviations.isAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static boolean containWordThatCanBeAbbreviated(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!ITA_Abbreviations.hasAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviateWords(String words) {
        if (words == null || words.trim().length() == 0) {
            return null;
        }
        StringBuffer output = new StringBuffer(words.length());
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            String abbr = ITA_Abbreviations.getAbbreviation(temp);
            if (abbr != null) {
                output.append(abbr);
            } else {
                output.append(temp);
            }
            output.append(" ");
        }
        return output.toString().trim();
    }

    public static String getWordForAbbreviation(String abbr) {
        if (abbr == null || abbr.trim().length() == 0 || m_words == null) {
            return null;
        }
        String word = (String)m_words.get(abbr.toUpperCase());
        return word;
    }

    static {
        try {
            ITA_Abbreviations.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

