/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_Abbreviations;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_AddressTerm;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_SpecialStreetHandling;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ITA_ParseMainAddressRule
implements IParseRule {
    public static final int MAX_ADDITIONAL_FIELDS = 2;
    private StringBuffer strBuf = null;
    private StringBuffer preAddrBuf = null;
    private StringBuffer postAddrBuf = null;
    private StringBuffer hnrBuf = null;
    public static final String UNPARSED_HNR = "unparsed_hnr";
    String preTTT = null;
    private boolean debug = false;
    public static final String UNPARSED_MAIN_ADDRESS = "unparsed_main_address";
    private boolean streetWithNumbers = false;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String finalPostAddress;
        String abbr;
        String fullWord;
        String tempHnr;
        String hnr = null;
        String str = null;
        hnr = ITA_ParseMainAddressRule.getProperHouseNumber(pa.getAddressNumber());
        if (!ITA_ParseMainAddressRule.isValidHouseNumber(hnr) && !ITA_ParseMainAddressRule.isValidHouseNumberRange(hnr)) {
            hnr = null;
        }
        if (pa.getMainAddress() != null && ITA_SpecialStreetHandling.handleSpecialStreet(pa, str = pa.getMainAddress())) {
            HashMap<String, String> addFields = new HashMap<String, String>();
            addFields.put("unparsed_input_street", str);
            addFields.put("input_house_number", ura.getAddressNumber());
            pa.setAdditionalFields(addFields);
            return;
        }
        str = this.checkMissingPunctuations(pa.getMainAddress());
        if (this.isEmpty(str)) {
            return;
        }
        HashMap<String, String> addFields = pa.getAdditionalFields();
        if (addFields == null) {
            addFields = new HashMap<String, String>(1);
        }
        addFields.put(UNPARSED_MAIN_ADDRESS, str);
        this.strBuf = new StringBuffer(str.length());
        this.preAddrBuf = new StringBuffer(str.length());
        this.postAddrBuf = new StringBuffer(str.length());
        this.hnrBuf = new StringBuffer(str.length());
        str = this.replaceFullStops(str, true);
        StringTokenizer tokens = new StringTokenizer(str, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        this.cleanAddress(listOfTokens);
        this.removeJunk(listOfTokens);
        this.seperateStreetName(listOfTokens);
        if (this.strBuf.length() > 0) {
            tokens = new StringTokenizer(this.strBuf.toString(), this.getDelimiters(), true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        }
        this.cleanAddress(listOfTokens);
        if (this.getHnr() != null && this.getHnr().length() > 0) {
            this.reCheckHnr();
        }
        if (hnr == null && !ITA_ParseMainAddressRule.isValidHouseNumber(hnr = ITA_ParseMainAddressRule.getProperHouseNumber(this.getHnr())) && !ITA_ParseMainAddressRule.isValidHouseNumberRange(hnr)) {
            hnr = null;
        }
        if (hnr != null) {
            pa.setAddressNumber(hnr);
        }
        if (hnr == null && this.getPreAddress() != null && (tempHnr = ITA_ParseMainAddressRule.getProperHouseNumber(this.getPreAddress())) != null) {
            pa.setAddressNumber(tempHnr);
            this.preAddrBuf.delete(0, this.preAddrBuf.length() - 1);
        }
        this.reCheckStreetName();
        if (this.strBuf.length() > 0) {
            tokens = new StringTokenizer(this.strBuf.toString(), this.getDelimiters(), true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        }
        this.cleanAddress(listOfTokens);
        this.seperateStreetFields(listOfTokens, pa);
        if (this.getPreAddress() != null) {
            pa.setGenericField2(this.getPreAddress());
        }
        if (this.getPostAddress() != null) {
            pa.setGenericField3(this.getPostAddress());
        }
        if (this.getHnr() != null) {
            HashMap<String, String> addFields2 = pa.getAdditionalFields();
            if (addFields2 == null) {
                addFields2 = new HashMap<String, String>(1);
            }
            addFields2.put(UNPARSED_HNR, this.getHnr());
        }
        if (pa.getMainAddress() != null && ITA_AddressTerm.isConcatWord(pa.getMainAddress())) {
            if (pa.getPostAddress() != null) {
                pa.setGenericField4(pa.getMainAddress() + pa.getPostAddress());
            }
        } else if (pa.getMainAddress() != null && ITA_Abbreviations.isAbbreviation(pa.getMainAddress()) && (fullWord = ITA_Abbreviations.getWordForAbbreviation(abbr = pa.getMainAddress())) != null) {
            pa.setMainAddress(fullWord);
        }
        if (pa.getPreAddress() != null && ITA_Abbreviations.isAbbreviation(pa.getPreAddress())) {
            pa.setPreAddress(ITA_Abbreviations.getWordForAbbreviation(pa.getPreAddress()));
        }
        if ((finalPostAddress = pa.getPostAddress()) != null && ITA_AddressTerm.isPunctuation(finalPostAddress)) {
            pa.setPostAddress(null);
        }
    }

    protected void seperateStreetName(LinkedList list) {
        int strStart = 0;
        int strEnd = -1;
        int i = 0;
        String term = null;
        String preTerm = null;
        while (i < list.size()) {
            preTerm = term;
            term = (String)list.get(i);
            if (ITA_AddressTerm.isStreetNotContainTerm(term)) {
                ++i;
                continue;
            }
            if (ITA_AddressTerm.isPunctuation(term) && preTerm != null && i + 1 < list.size()) {
                if (ITA_AddressTerm.isStreetNotContainTerm(preTerm + term + list.get(i + 1))) {
                    i += 2;
                    continue;
                }
            } else if (i + 2 < list.size() && ITA_AddressTerm.isPunctuation((String)list.get(i + 1)) && ITA_AddressTerm.isStreetNotContainTerm(term + list.get(i + 1) + list.get(i + 2))) {
                strStart = i;
                i += 3;
                continue;
            }
            if (ITA_ThoroughfareTypes.isStreetType(term)) {
                strStart = i;
                strEnd = i;
                if (i + 2 >= list.size() || !ITA_ThoroughfareTypes.isStreetType(term + '-' + list.get(i + 2))) break;
                list.set(i + 1, "-");
                strEnd = strStart + 2;
                break;
            }
            ++i;
        }
        int hnrStart = -1;
        int hnrEnd = -1;
        int possibleHnrStart = -1;
        boolean hnrFound = false;
        preTerm = null;
        boolean foundValidName = false;
        int listSize = list.size();
        for (i = strEnd < strStart ? strStart : strEnd + 1; i < listSize; ++i) {
            if (preTerm == null && i > 0) {
                preTerm = (String)list.get(i - 1);
            }
            term = (String)list.get(i);
            if (!foundValidName && ITA_AddressTerm.isPreNumStreetWord(preTerm)) {
                foundValidName = true;
            }
            if (ITA_AddressTerm.isStreetNotContainTerm(term)) {
                if (hnrFound) {
                    hnrEnd = i - 1;
                    break;
                }
                strEnd = i - 1;
                break;
            }
            if (ITA_AddressTerm.isPunctuation(term) && preTerm != null && i + 1 < list.size()) {
                if (ITA_AddressTerm.isStreetNotContainTerm(preTerm + term + list.get(i + 1))) {
                    if (hnrFound) {
                        hnrEnd = i - 2;
                        break;
                    }
                    strEnd = i - 2;
                    break;
                }
            } else if (i + 2 < list.size() && ITA_AddressTerm.isPunctuation((String)list.get(i + 1)) && ITA_AddressTerm.isStreetNotContainTerm(term + list.get(i + 1) + list.get(i + 2))) {
                if (hnrFound) {
                    hnrEnd = i - 1;
                    break;
                }
                strEnd = i - 1;
                break;
            }
            if (hnrFound) {
                if (this.canBePartOfHnr(term)) {
                    hnrEnd = i;
                    continue;
                }
                hnrEnd = i - 1;
                break;
            }
            if (ITA_ParseMainAddressRule.isValidHouseNumber(term) && foundValidName) {
                hnrStart = possibleHnrStart > -1 ? possibleHnrStart : i;
                strEnd = hnrStart - 1;
                hnrEnd = i;
                hnrFound = true;
                continue;
            }
            if (ITA_AddressTerm.isHnrStartTerm(term) && foundValidName) {
                possibleHnrStart = i;
                continue;
            }
            if (possibleHnrStart > -1 && !ITA_AddressTerm.isPunctuation(term)) {
                possibleHnrStart = -1;
                continue;
            }
            if (foundValidName || i - 1 <= strEnd) continue;
            foundValidName = true;
        }
        if (!hnrFound) {
            for (i = strEnd + 1; i < list.size(); ++i) {
                preTerm = term;
                term = (String)list.get(i);
                if (ITA_ThoroughfareTypes.isStreetType(term)) {
                    strEnd = i - 1;
                    break;
                }
                if (ITA_AddressTerm.isStreetNotContainTerm(term)) {
                    strEnd = i - 1;
                    break;
                }
                if (ITA_AddressTerm.isPunctuation(term)) {
                    if (!ITA_AddressTerm.isStreetNotContainTerm(preTerm + term) && (i + 1 >= list.size() || !ITA_AddressTerm.isStreetNotContainTerm(preTerm + term + list.get(i + 1)))) continue;
                    strEnd = i - 2;
                    break;
                }
                strEnd = i;
            }
        } else {
            i = hnrEnd + 1;
        }
        int preAddressEnd = strStart - 1;
        if (strEnd == -1 && hnrFound) {
            preAddressEnd = hnrStart - 1;
            strStart = hnrEnd + 1;
            strEnd = list.size() - 1;
        }
        for (i = 0; i <= preAddressEnd; ++i) {
            this.appendPreAddress((String)list.get(i));
        }
        for (i = strStart; i <= strEnd; ++i) {
            this.appendStreet((String)list.get(i));
        }
        if (hnrStart != -1 || hnrEnd != -1) {
            for (i = hnrStart; i <= hnrEnd; ++i) {
                this.appendHnr((String)list.get(i));
            }
        }
        while (i < list.size()) {
            this.appendPostAddress((String)list.get(i));
            ++i;
        }
        if (this.getStreet() == null || this.getStreet().length() == 0 || ITA_AddressTerm.isPunctuation(this.getStreet())) {
            if (this.getPreAddress() != null && this.getPreAddress().trim().length() > 0) {
                this.insertStreet(this.getPreAddress());
                this.setPreAddress(null);
            } else if (this.getPostAddress() != null && this.getPostAddress().trim().length() > 0) {
                this.appendStreet(this.getPostAddress());
                this.setPostAddress(null);
            }
        }
        boolean onlyStreetType = false;
        if (this.getPostAddress() != null && this.getPostAddress().trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(this.getPostAddress(), this.getDelimiters(), true);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken();
                if (temp.equals(" ")) continue;
                if (ITA_ThoroughfareTypes.isStreetType(temp)) {
                    onlyStreetType = true;
                    continue;
                }
                if (onlyStreetType && ITA_AddressTerm.isPunctuation(temp)) continue;
                onlyStreetType = false;
                break;
            }
            if (onlyStreetType) {
                this.appendStreet(this.getPostAddress());
                this.setPostAddress(null);
            }
        }
    }

    public String getDelimiters() {
        StringBuffer buf = new StringBuffer(20);
        if (ITA_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(ITA_AddressTerm.getPunctuationsAsString());
        }
        if (ITA_AddressTerm.getOrdinalsAsString() != null) {
            buf.append(ITA_AddressTerm.getOrdinalsAsString());
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    protected void setPreAddress(String preAddress) {
        if (preAddress == null) {
            this.preAddrBuf = null;
            return;
        }
        if (this.preAddrBuf == null) {
            this.preAddrBuf = new StringBuffer(preAddress.length());
        }
        this.preAddrBuf.delete(0, this.preAddrBuf.length());
        this.preAddrBuf.append(preAddress);
    }

    protected void setPostAddress(String postAddress) {
        if (postAddress == null) {
            this.postAddrBuf = null;
            return;
        }
        if (this.postAddrBuf == null) {
            this.postAddrBuf = new StringBuffer(postAddress.length());
        }
        this.postAddrBuf.delete(0, this.postAddrBuf.length());
        this.postAddrBuf.append(postAddress);
    }

    public static boolean isValidHouseNumber(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen > 1 && Character.isLetter(hnr.charAt(hnrLen - 1))) {
            return ITA_ParseMainAddressRule.isValidNumberFormat(hnr.substring(0, hnrLen - 1), hnrLen - 1);
        }
        return ITA_ParseMainAddressRule.isValidNumberFormat(hnr, hnrLen);
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-/");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!ITA_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return ITA_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    public boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public void removeIllegalTerms(LinkedList list) {
        int i = 0;
        while (i < list.size()) {
            String term = (String)list.get(i);
            if (ITA_AddressTerm.isStreetNotContainTerm(term)) {
                list.remove(i);
                continue;
            }
            if (list.size() > i + 2) {
                if (ITA_AddressTerm.isStreetNotContainTerm(term = term + (String)list.get(i + 1) + (String)list.get(i + 2))) {
                    list.remove(i + 2);
                    list.remove(i + 1);
                    list.remove(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public void cleanAddress(LinkedList list) {
        String temp;
        while (list.size() > 0 && (temp = (String)list.getFirst()).length() == 1 && ITA_AddressTerm.isPunctuation(temp)) {
            list.removeFirst();
        }
        while (list.size() > 0 && (temp = (String)list.getLast()).length() == 1 && ITA_AddressTerm.isPunctuation(temp)) {
            list.removeLast();
        }
        String lastPunctuation = null;
        for (int i = 0; i < list.size(); ++i) {
            String temp2 = (String)list.get(i);
            if (temp2.length() == 1 && ITA_AddressTerm.isPunctuation(temp2)) {
                if (temp2.equals(lastPunctuation)) {
                    list.remove(i);
                    break;
                }
                lastPunctuation = temp2;
                continue;
            }
            lastPunctuation = null;
        }
    }

    protected void seperateStreetFields(LinkedList list, Address pa) {
        StringTokenizer st;
        int numOfTokens;
        StringBuffer mainAddrBuf = new StringBuffer();
        StringBuffer preAddrBuf = new StringBuffer();
        StringBuffer postAddrBuf = new StringBuffer();
        StringBuffer preMainCommonBuf = new StringBuffer();
        StringBuffer postTypeCommonBuf = new StringBuffer();
        StringBuffer strTypeBuf = new StringBuffer();
        StringBuffer beforeTypeBuf = new StringBuffer();
        boolean NOTHING = false;
        boolean MAINADDR = true;
        int PREADDR = 2;
        int STTYPE = 3;
        int BEFORETYPE = 4;
        int lastType = 0;
        String term = null;
        String lastTerm = null;
        String lastPuncType = "";
        for (int i = list.size() - 1; i >= 0; --i) {
            if (term != null && !ITA_AddressTerm.isPunctuation(term)) {
                lastTerm = term;
            }
            if (term != null) {
                lastPuncType = term;
            }
            if (ITA_ThoroughfareTypes.isStreetType(term = (String)list.get(i)) && i > 1 && ((String)list.get(i - 1)).equals("-") && ITA_ThoroughfareTypes.isStreetType((String)list.get(i - 2))) {
                term = list.get(i - 2) + "-" + term;
                i -= 2;
            }
            if (ITA_AddressTerm.isPunctuation(term) || ITA_AddressTerm.isCommonTerm(term) || ITA_AddressTerm.isRomanNumber(term) && (!ITA_ThoroughfareTypes.isStreetType(term) || lastType == 0) || term.length() < 2 && !ITA_ThoroughfareTypes.isStreetType(term) && !lastPuncType.equalsIgnoreCase(".") || ITA_AddressTerm.isDirectional(term) || StringUtilities.isNumeric((String)term)) {
                switch (lastType) {
                    case 0: {
                        postAddrBuf.insert(0, term);
                        break;
                    }
                    case 1: {
                        preMainCommonBuf.insert(0, term);
                        break;
                    }
                    case 2: {
                        postTypeCommonBuf.insert(0, term);
                        break;
                    }
                    case 3: {
                        if (term.equals(" ") || term.equals("-")) break;
                        beforeTypeBuf.insert(0, term);
                        lastType = 3;
                    }
                }
                continue;
            }
            if (lastType == 4) {
                beforeTypeBuf.insert(0, term);
                continue;
            }
            if (ITA_ThoroughfareTypes.isStreetType(term) && (lastType == 1 || lastType == 2 || lastType == 3)) {
                if (lastTerm != null && ITA_ThoroughfareTypes.isStreetType(term + "-" + lastTerm)) {
                    switch (lastType) {
                        case 3: {
                            strTypeBuf.insert(0, "-");
                            strTypeBuf.insert(0, term);
                            break;
                        }
                        case 2: {
                            preAddrBuf.insert(0, "-");
                            preAddrBuf.insert(0, term);
                            break;
                        }
                        case 1: {
                            mainAddrBuf.insert(0, "-");
                            mainAddrBuf.insert(0, term);
                        }
                    }
                    continue;
                }
                if (lastType == 3) {
                    if (preAddrBuf.length() == 0) {
                        preAddrBuf.append(strTypeBuf);
                        postTypeCommonBuf.append(beforeTypeBuf);
                    } else {
                        postTypeCommonBuf.insert(0, strTypeBuf);
                        postTypeCommonBuf.insert(0, beforeTypeBuf);
                    }
                    strTypeBuf.delete(0, strTypeBuf.length());
                    strTypeBuf.append(term);
                    continue;
                }
                strTypeBuf.insert(0, term);
                lastType = 3;
                continue;
            }
            if ((lastType == 1 || lastType == 2) && i - 1 > 0 && ITA_AddressTerm.isPunctuation((String)list.get(i - 1)) && ITA_ThoroughfareTypes.isStreetType(list.get(i - 2) + "-" + term)) {
                strTypeBuf.insert(0, term);
                strTypeBuf.insert(0, "-");
                strTypeBuf.insert(0, list.get(i - 2));
                i -= 2;
                continue;
            }
            if (lastType == 1 || lastType == 2) {
                if (preAddrBuf.length() > 0) {
                    postTypeCommonBuf.insert(0, term);
                } else {
                    preAddrBuf.insert(0, term);
                }
                lastType = 2;
                continue;
            }
            mainAddrBuf.insert(0, term);
            lastType = 1;
        }
        String strType = strTypeBuf.toString().trim();
        String preAddr = ITA_AddressTerm.getValidTerm(preAddrBuf.toString(), true);
        String postAddr = ITA_AddressTerm.getValidTerm(postAddrBuf.toString(), true);
        String preMainCommon = ITA_AddressTerm.getValidTerm(preMainCommonBuf.toString(), true);
        String postTypeCommon = ITA_AddressTerm.getValidTerm(postTypeCommonBuf.toString(), true);
        String mainAddr = mainAddrBuf.toString();
        mainAddr = mainAddr != null ? (((numOfTokens = (st = new StringTokenizer(mainAddr, this.getDelimiters())).countTokens()) > 1 || this.streetWithNumbers) && ITA_ThoroughfareTypes.isStreetType(mainAddr) ? ITA_ThoroughfareTypes.lookupProperName(mainAddr) : ITA_AddressTerm.getValidTerm(mainAddr)) : ITA_AddressTerm.getValidTerm(mainAddr);
        boolean reCheckStreetType = true;
        if (mainAddr != null && mainAddr.trim().length() == 1) {
            if (preAddr != null) {
                if (preMainCommon != null) {
                    postAddr = preMainCommon + " " + mainAddr + postAddr;
                    mainAddr = preAddr;
                    preAddr = null;
                } else {
                    postAddr = mainAddr;
                    mainAddr = preAddr;
                    preAddr = null;
                }
            }
            if (strType != null && strType.length() > 1) {
                postAddr = postAddr != null ? mainAddr + " " + postAddr : mainAddr;
                mainAddr = strType;
                strType = null;
                reCheckStreetType = false;
            }
        }
        if (mainAddr == null) {
            if (postAddr != null && !ITA_AddressTerm.isPunctuation(postAddr)) {
                mainAddr = postAddr;
                postAddr = null;
            } else if (preAddr != null && preMainCommon != null) {
                postAddr = preMainCommon;
                preMainCommon = null;
                mainAddr = preAddr;
                preAddr = null;
            }
        }
        if (reCheckStreetType && (strType == null || strType.trim().length() == 0) && ITA_ThoroughfareTypes.isStreetType(mainAddr) && postAddr != null && !ITA_AddressTerm.isPunctuation(postAddr) && ITA_AddressTerm.getValidTerm(postAddr) != null && !StringUtilities.hasNumeric((String)postAddr)) {
            strType = mainAddr;
            mainAddr = postAddr;
            postAddr = null;
        }
        pa.setMainAddress(mainAddr);
        pa.setPreAddress(preAddr);
        pa.setPostAddress(postAddr);
        if (strType != null) {
            pa.setPreThoroughfareType(ITA_ThoroughfareTypes.lookupProperName(strType));
        }
        if (preMainCommon != null || postTypeCommon != null) {
            HashMap<String, String> addFields = new HashMap<String, String>(2);
            if (preMainCommon != null) {
                addFields.put("pre_main_address_common", preMainCommon);
            }
            if (postTypeCommon != null) {
                addFields.put("post_st_type_common", postTypeCommon);
            }
            pa.setAdditionalFields(addFields);
        }
    }

    public static String getProperHouseNumber(String inHnr) {
        String temp;
        if (inHnr == null || inHnr.trim().length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(inHnr, ",. /-", true);
        String houseNum = null;
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            if (temp.equalsIgnoreCase("KM") || temp.equalsIgnoreCase("INT")) {
                return null;
            }
            if (!ITA_ParseMainAddressRule.isValidHouseNumber(temp)) continue;
            houseNum = temp;
            break;
        }
        if (!st.hasMoreTokens()) {
            if (houseNum != null) {
                return houseNum.trim();
            }
            return null;
        }
        temp = st.nextToken();
        if (temp.equals(" ") && st.hasMoreTokens()) {
            temp = st.nextToken();
        }
        if (ITA_ParseMainAddressRule.isValidHouseNumber(temp)) {
            return houseNum.trim();
        }
        if (ITA_ParseMainAddressRule.isValidHouseNumber(houseNum + temp)) {
            houseNum = houseNum + temp;
            if (st.hasMoreTokens()) {
                temp = st.nextToken();
            }
            if (temp.equals(" ") && st.hasMoreTokens()) {
                temp = st.nextToken();
            }
        }
        if ((temp.equals("-") || temp.equals("/")) && st.hasMoreTokens()) {
            temp = st.nextToken();
            if (temp.equals(" ") && st.hasMoreTokens()) {
                temp = st.nextToken();
            }
            if (ITA_ParseMainAddressRule.isValidHouseNumberRange(houseNum + "-" + temp)) {
                houseNum = houseNum + "-" + temp;
                temp = st.hasMoreTokens() ? st.nextToken() : null;
                if (temp != null && temp.equals(" ") && st.hasMoreTokens()) {
                    temp = st.nextToken();
                }
                if (ITA_ParseMainAddressRule.isValidHouseNumberRange(houseNum + temp)) {
                    houseNum = houseNum + temp;
                    if (st.hasMoreTokens()) {
                        temp = st.nextToken();
                    }
                    if (temp.equals(" ") && st.hasMoreTokens()) {
                        temp = st.nextToken();
                    }
                }
            }
        }
        return houseNum.trim();
    }

    protected void appendPreAddress(String term) {
        if (this.preAddrBuf == null) {
            this.initPreAddrBuf(0);
        }
        this.preAddrBuf.append(term);
    }

    protected void insertPreAddress(String term) {
        if (this.preAddrBuf == null) {
            this.initPreAddrBuf(0);
        }
        this.preAddrBuf.insert(0, term);
    }

    protected void appendPostAddress(String term) {
        if (this.postAddrBuf == null) {
            this.initPostAddrBuf(0);
        }
        this.postAddrBuf.append(term);
    }

    protected void insertPostAddress(String term) {
        if (this.postAddrBuf == null) {
            this.initPostAddrBuf(0);
        }
        this.postAddrBuf.insert(0, term);
    }

    protected void appendHnr(String term) {
        if (this.hnrBuf == null) {
            this.initHnrBuf(0);
        }
        this.hnrBuf.append(term);
    }

    protected void insertHnr(String term) {
        if (this.hnrBuf == null) {
            this.initHnrBuf(0);
        }
        this.hnrBuf.insert(0, term);
    }

    protected void appendStreet(String term) {
        if (this.strBuf == null) {
            this.initStrBuf(0);
        }
        this.strBuf.append(term);
    }

    protected void insertStreet(String term) {
        if (this.strBuf == null) {
            this.initStrBuf(0);
        }
        this.strBuf.insert(0, term);
    }

    protected void initStrBuf(int size) {
        this.strBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initPreAddrBuf(int size) {
        this.preAddrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initPostAddrBuf(int size) {
        this.postAddrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected void initHnrBuf(int size) {
        this.hnrBuf = size <= 0 ? new StringBuffer() : new StringBuffer(size);
    }

    protected String getPreAddress() {
        if (this.preAddrBuf != null && this.preAddrBuf.length() > 0) {
            return this.preAddrBuf.toString();
        }
        return null;
    }

    protected String getPostAddress() {
        if (this.postAddrBuf != null && this.postAddrBuf.length() > 0) {
            return this.postAddrBuf.toString();
        }
        return null;
    }

    protected String getHnr() {
        if (this.hnrBuf != null && this.hnrBuf.length() > 0) {
            return this.hnrBuf.toString();
        }
        return null;
    }

    protected boolean canBePartOfHnr(String term) {
        if (term == null) {
            return false;
        }
        if (ITA_ParseMainAddressRule.isValidHouseNumber(term)) {
            return true;
        }
        if (ITA_AddressTerm.isHnrCanContainTerm(term)) {
            return true;
        }
        if (ITA_AddressTerm.isOrdinalChar(term)) {
            return true;
        }
        if (term.length() == 1) {
            return Character.isLetter(term.charAt(0)) || term.charAt(0) == ' ';
        }
        return false;
    }

    private String checkMissingPunctuations(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str);
        boolean lastCharWasPunctuation = false;
        boolean lastCharWasDigit = false;
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (ITA_AddressTerm.isPunctuation(ch)) {
                lastCharWasPunctuation = true;
                lastCharWasDigit = false;
                continue;
            }
            if (ITA_AddressTerm.isDigit(ch)) {
                if (!lastCharWasPunctuation && !lastCharWasDigit) {
                    buf.insert(i, ' ');
                    ++i;
                }
                lastCharWasDigit = true;
                lastCharWasPunctuation = false;
                continue;
            }
            if (lastCharWasDigit) {
                buf.insert(i, ' ');
                ++i;
                lastCharWasPunctuation = true;
                lastCharWasDigit = false;
                continue;
            }
            lastCharWasPunctuation = false;
            lastCharWasDigit = false;
        }
        return buf.toString();
    }

    public String replaceFullStops(String instring, boolean isNewCase) {
        if (instring == null) {
            return null;
        }
        StringBuffer newString = new StringBuffer(instring.length());
        StringBuffer oldString = new StringBuffer(instring);
        boolean isNumber = false;
        for (int i = 0; i < oldString.length(); ++i) {
            char ch = oldString.charAt(i);
            if (ITA_AddressTerm.isDigit(ch)) {
                isNumber = true;
            } else if (ch != ' ') {
                isNumber = false;
            }
            if (ch == '.' && !isNumber) {
                if (!isNewCase) continue;
                newString.append(" ");
                continue;
            }
            newString.append(ch);
        }
        return newString == null ? null : newString.toString();
    }

    private void reCheckHnr() {
        int pos;
        String term;
        boolean reCheck = false;
        LinkedList hnrList = null;
        LinkedList strList = null;
        String lastTerm = null;
        if (this.getHnr() != null && this.getHnr().length() != 0) {
            hnrList = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(this.getHnr(), this.getDelimiters(), true));
        }
        if (this.getStreet() != null && this.getStreet().trim().length() > 0) {
            strList = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(this.getStreet(), this.getDelimiters()));
            lastTerm = (String)strList.getLast();
        }
        if (hnrList == null || lastTerm == null) {
            return;
        }
        if (ITA_AddressTerm.isMonth(lastTerm)) {
            String num = (String)hnrList.getFirst();
            if (StringUtilities.isNumeric((String)num) && num.length() == 4) {
                reCheck = true;
            }
        } else if (ITA_AddressTerm.isPreNumStreetWord(lastTerm)) {
            reCheck = true;
        } else if (strList.size() > 1) {
            if (ITA_AddressTerm.isPreNumStreetWord((String)strList.get(strList.size() - 2) + " " + lastTerm)) {
                reCheck = true;
            }
        } else if (lastTerm.length() == 1 && Character.isLetter(lastTerm.charAt(0)) && strList.size() > 1 && ITA_ThoroughfareTypes.isStreetType(term = (String)strList.get(strList.size() - 2))) {
            reCheck = true;
        }
        if (reCheck && (pos = this.getFirstNumericIndex(hnrList)) > -1) {
            int i;
            for (i = 0; i <= pos; ++i) {
                this.appendStreet((String)hnrList.get(i));
            }
            this.setHnr(null);
            for (i = pos + 1; i < hnrList.size(); ++i) {
                this.appendHnr((String)hnrList.get(i));
            }
            this.streetWithNumbers = true;
        }
    }

    private int getFirstNumericIndex(LinkedList list) {
        if (list == null || list.size() == 0) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String term = (String)list.get(i);
            if (!StringUtilities.isNumeric((String)term) && !StringUtilities.hasNumeric((String)term)) continue;
            return i;
        }
        return -1;
    }

    protected void setHnr(String hnr) {
        if (hnr == null) {
            this.hnrBuf = null;
            return;
        }
        this.hnrBuf = new StringBuffer(hnr.length());
        this.hnrBuf.append(hnr);
    }

    private void reCheckStreetName() {
        StringTokenizer st = null;
        if (this.getStreet() == null || this.getStreet().length() <= 0) {
            return;
        }
        st = new StringTokenizer(this.getStreet(), this.getDelimiters(), true);
        boolean streetTypeOnly = false;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.equals(" ")) continue;
            if (ITA_ThoroughfareTypes.isStreetType(temp)) {
                streetTypeOnly = true;
                continue;
            }
            if (streetTypeOnly && (ITA_AddressTerm.isPunctuation(temp) || ITA_AddressTerm.isCommonTerm(temp))) continue;
            streetTypeOnly = false;
            break;
        }
        if (streetTypeOnly) {
            if (this.getPreAddress() != null && this.getPreAddress().length() > 0) {
                this.insertStreet(this.getPreAddress());
                this.setPreAddress(null);
            } else if (this.getPostAddress() != null && this.getPostAddress().length() > 0) {
                String savedPreAddress = this.getPreAddress();
                String savedPostAddress = this.getPostAddress();
                String savedHnr = this.getHnr();
                String savedStreet = this.getStreet();
                this.setPreAddress(null);
                this.setPostAddress(null);
                this.setStreet(null);
                LinkedList list = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(savedPostAddress, this.getDelimiters(), true));
                this.seperateStreetName(list);
                if (this.getStreet() != null && this.getStreet().trim().length() > 0 && (this.getPreAddress() == null || this.getPreAddress().trim().length() == 0)) {
                    this.insertStreet(savedStreet);
                } else {
                    this.setPreAddress(savedPreAddress);
                    this.setStreet(savedStreet);
                    this.setHnr(savedHnr);
                    this.setPostAddress(savedPostAddress);
                }
            }
        }
    }

    protected String getStreet() {
        if (this.strBuf != null && this.strBuf.length() > 0) {
            return this.strBuf.toString();
        }
        return null;
    }

    protected void setStreet(String street) {
        if (street == null) {
            this.strBuf = null;
            return;
        }
        this.strBuf = new StringBuffer(street.length());
        this.strBuf.append(street);
    }

    public static boolean isValidNumberFormat(String num, int len) {
        boolean bRc = true;
        if (num == null || num.trim().length() == 0) {
            return false;
        }
        if (num.trim().length() == len) {
            for (int i = 0; i < num.length(); ++i) {
                char ch = num.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                bRc = false;
                break;
            }
        } else {
            bRc = false;
        }
        return bRc;
    }

    private void removeJunk(LinkedList listOfTokens) {
        int i;
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            int n;
            String term = (String)listOfTokens.get(i);
            if (term.equalsIgnoreCase("Casella")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (ITA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("Postale")) {
                            ++n;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (ITA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("CP")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (ITA_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            }
            if (end > 0) break;
        }
        if (start >= 0 && end > 0 && start <= end) {
            for (i = start; i <= end; ++i) {
                listOfTokens.remove(start);
            }
        }
    }
}

