/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Enumeration;
import java.util.Properties;

public class ITA_ProvinceAbbreviations {
    private static Properties m_provinces = null;
    private static Properties m_abbrProvinces = null;

    public static String getProvinceForAbbreviation(String abbr) {
        String province = null;
        if (abbr != null) {
            province = m_abbrProvinces.getProperty(abbr.toUpperCase());
        }
        return province;
    }

    public static String getProvinceAbbreviation(String province) {
        String ret = null;
        if (province != null) {
            ret = m_provinces.getProperty(province.toUpperCase());
        }
        if (ret == null) {
            return null;
        }
        if (ret.length() > 2) {
            return ret.substring(0, 2);
        }
        return ret;
    }

    public static String removeDots(String str) {
        int len = (str = str == null ? "" : str.trim().toUpperCase()).length();
        if (len == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '.' || ch == ' ') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String getProperProvinceAbbr(String str) {
        String orgStr = str == null ? null : str.trim();
        String abbr = ITA_ProvinceAbbreviations.getProvinceAbbreviation(orgStr);
        if (abbr == null) {
            str = ITA_ProvinceAbbreviations.removeDots(orgStr);
            if ((str = ITA_ProvinceAbbreviations.getProvinceForAbbreviation(str)) != null) {
                abbr = ITA_ProvinceAbbreviations.getProvinceAbbreviation(str);
            }
        }
        return abbr;
    }

    public static boolean isAbbreviation(String prov) {
        if ((prov = ITA_ProvinceAbbreviations.removeDots(prov)) != null) {
            return m_abbrProvinces.containsKey(prov);
        }
        return false;
    }

    static {
        try {
            if (m_provinces == null) {
                m_provinces = null;
                m_abbrProvinces = new Properties();
                m_provinces = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/ITA/parser/ITA_ProvinceAbbreviations.properties");
                String province = null;
                String abbr = null;
                Enumeration<?> e = m_provinces.propertyNames();
                while (e.hasMoreElements()) {
                    abbr = (String)e.nextElement();
                    province = m_provinces.getProperty(abbr).trim();
                    if (province == null || province.length() <= 0) continue;
                    m_provinces.setProperty(province.toUpperCase(), abbr);
                    if (m_abbrProvinces.getProperty(abbr) != null) continue;
                    m_abbrProvinces.setProperty(abbr.toUpperCase(), province);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for ITA_Parser.");
        }
    }
}

