/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class RomanNumeral
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    public static SymTab[] syms = new SymTab[]{new SymTab('M', 1000L), new SymTab('D', 500L), new SymTab('C', 100L), new SymTab('L', 50L), new SymTab('X', 10L), new SymTab('V', 5L), new SymTab('I', 1L)};

    @Override
    public StringBuffer format(double n, StringBuffer a, FieldPosition p) {
        return null;
    }

    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        String s = text.substring(parsePosition.getIndex());
        long tot = 0L;
        long max = 0L;
        char[] ch = s.toUpperCase().toCharArray();
        for (int p = ch.length - 1; p >= 0; --p) {
            for (int i = 0; i < syms.length; ++i) {
                if (RomanNumeral.syms[i].symbol != ch[p]) continue;
                if (RomanNumeral.syms[i].value >= max) {
                    max = RomanNumeral.syms[i].value;
                    tot += max;
                    continue;
                }
                tot -= RomanNumeral.syms[i].value;
            }
        }
        parsePosition.setIndex(s.length());
        return new Long(tot);
    }

    public static long toLong(String s) {
        long tot = 0L;
        long max = 0L;
        char[] ch = s.toUpperCase().toCharArray();
        for (int p = ch.length - 1; p >= 0; --p) {
            for (int i = 0; i < syms.length; ++i) {
                if (RomanNumeral.syms[i].symbol != ch[p]) continue;
                if (RomanNumeral.syms[i].value >= max) {
                    max = RomanNumeral.syms[i].value;
                    tot += max;
                    continue;
                }
                tot -= RomanNumeral.syms[i].value;
            }
        }
        return tot;
    }

    @Override
    public StringBuffer format(long n, StringBuffer s, FieldPosition p) {
        while (n > 0L) {
            for (int i = 0; i < syms.length; ++i) {
                if (RomanNumeral.syms[i].value > n) continue;
                int shift = i + i % 2;
                if (i > 0 && shift < syms.length && RomanNumeral.syms[i - 1].value - RomanNumeral.syms[shift].value <= n) {
                    s.append(RomanNumeral.syms[shift].symbol);
                    s.append(RomanNumeral.syms[i - 1].symbol);
                    n = n - RomanNumeral.syms[i - 1].value + RomanNumeral.syms[shift].value;
                    i = -1;
                    continue;
                }
                s.append(RomanNumeral.syms[i].symbol);
                n -= RomanNumeral.syms[i].value;
                i = -1;
            }
        }
        return s;
    }

    public static String toRomanNumeral(long n) {
        String s = "";
        while (n > 0L) {
            for (int i = 0; i < syms.length; ++i) {
                if (RomanNumeral.syms[i].value > n) continue;
                int shift = i + i % 2;
                if (i > 0 && shift < syms.length && RomanNumeral.syms[i - 1].value - RomanNumeral.syms[shift].value <= n) {
                    s = s + RomanNumeral.syms[shift].symbol + RomanNumeral.syms[i - 1].symbol;
                    n = n - RomanNumeral.syms[i - 1].value + RomanNumeral.syms[shift].value;
                    i = -1;
                    continue;
                }
                s = s + RomanNumeral.syms[i].symbol;
                n -= RomanNumeral.syms[i].value;
                i = -1;
            }
        }
        return s;
    }

    public static class SymTab {
        char symbol;
        long value;

        public SymTab(char s, long v) {
            this.symbol = s;
            this.value = v;
        }
    }
}

