/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.browse;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_InternalBrowseAddress;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataManager;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.browse.EMEA_BrowseFilter;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CHE_BrowseFilter
extends EMEA_BrowseFilter {
    @Override
    public List filterAddresses(IConstraints constraints, Address pa, List candidates) throws MatcherException {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        this.removeDuplicateAddresses(candidates);
        return this.filterCandidates(constraints, pa, candidates);
    }

    private void removeDuplicateAddresses(List candidates) {
        HashSet<CHE_InternalBrowseAddress.StreetBasedIdentifier> set = new HashSet<CHE_InternalBrowseAddress.StreetBasedIdentifier>(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            CHE_InternalBrowseAddress cheBrowseAddress = (CHE_InternalBrowseAddress)((Object)iter.next());
            CHE_InternalBrowseAddress.StreetBasedIdentifier identifier = cheBrowseAddress.getStreetBasedIdentifier();
            if (set.contains(identifier)) {
                iter.remove();
                continue;
            }
            set.add(identifier);
        }
    }

    private List filterCandidates(IConstraints constraints, Address pa, List candidates) {
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        StringScorer scorer = ((CoreHandler)constraints.getHandler()).getScoringHelper().makeStringScorer();
        ArrayList<CHE_InternalBrowseAddress> filteredCandidates = new ArrayList<CHE_InternalBrowseAddress>(candidates.size());
        for (CHE_InternalBrowseAddress address : candidates) {
            CHE_InternalBrowseAddress filteredAddress = this.filterAddress(address, pa, thresholds, constraints, scorer);
            if (filteredAddress == null) continue;
            filteredCandidates.add(filteredAddress);
        }
        return filteredCandidates;
    }

    private CHE_InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        CHE_InternalBrowseAddress filteredAddress = (CHE_InternalBrowseAddress)constraints.getHandler().getBrowseHelper().makeBrowseAddress((Address)address);
        filteredAddress.setVendorCode(address.getVendorCode());
        int segmentCount = address.getSegmentCount();
        for (int index = 0; index < segmentCount; ++index) {
            int dictNum;
            Segment segment = address.getSegmentAt(index);
            Segment filteredSegment = this.filterSegment(segment, dictNum = filteredAddress.getDictionaryNumber(), inputAddress, thresholds, constraints, scorer);
            if (filteredSegment == null) continue;
            filteredAddress.addSegment(filteredSegment);
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    private Segment filterSegment(Segment segment, int dictNum, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        double postcode1Score;
        double score;
        double an3Score;
        IMatchPreferences constants = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, inputAddress);
        EMEA_GeoInfoRecord geoinfo = (EMEA_GeoInfoRecord)segment.getGeoInfoRecord();
        String an3 = inputAddress.getAreaName3();
        String an4 = inputAddress.getAreaName4();
        if (CHE_AddressUtils.isEmpty(an3) && CHE_AddressUtils.isEmpty(an4)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else if (geoinfo != null) {
            String an4FromGeoInfo;
            double an4Score;
            String shortNameFromGeoInfo = geoinfo.getAreaName3Short();
            if (CHE_AddressUtils.isEmpty(shortNameFromGeoInfo)) {
                an3Score = scorer.scoreString(an3, geoinfo.getAreaName3());
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName4());
                if (CHE_AddressUtils.isEmpty(an4)) {
                    if (an3Score == 1.0) {
                        an4Score = 1.0;
                    }
                } else if (an4Score == 1.0) {
                    an3Score = 1.0;
                }
            } else {
                an3Score = scorer.scoreString(an3, shortNameFromGeoInfo);
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName3());
            }
            if (geoinfo.getAltAreaName3() != null && (an3Score != 1.0 || an4Score != 1.0)) {
                int index;
                String[] tokens = geoinfo.getAltAreaName3().split("/");
                boolean shortIsSameAsFull = true;
                if (!CHE_AddressUtils.isEmpty(an3) && an3Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        String fullAlias = tokens[index].trim();
                        String shortAlias = CHE_ParsePostAddressRule.removeCommonWords(fullAlias);
                        if (shortAlias == null) {
                            shortAlias = fullAlias;
                        }
                        if (!(an3Score < (score = scorer.scoreString(an3, shortAlias)))) continue;
                        shortIsSameAsFull = shortAlias.length() == fullAlias.length();
                        an3Score = score;
                        if (an3Score == 1.0) break;
                    }
                }
                if (!CHE_AddressUtils.isEmpty(an4) && an4Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        score = scorer.scoreString(an4, tokens[index]);
                        double d = an4Score = an4Score < score ? score : an4Score;
                        if (an4Score == 1.0) break;
                    }
                }
                if (CHE_AddressUtils.isEmpty(an4)) {
                    if (an3Score > an4Score) {
                        if (constants.getExactMatchAreaName3()) {
                            if (shortIsSameAsFull) {
                                an4Score = an3Score;
                            }
                        } else {
                            an4Score = an3Score;
                        }
                    }
                } else if (an4Score > an3Score) {
                    an3Score = an4Score;
                }
            }
            if (an3Score != 1.0) {
                double[] scores;
                String locality = geoinfo.getAliasedLocality();
                if (!CHE_AddressUtils.isEmpty(locality) && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0]) {
                    an3Score = scores[0];
                    an4Score = scores[1];
                }
                if (an3Score != 1.0) {
                    String leftPostCode1 = segment.getLeftPostCode1();
                    String rightPostCode1 = segment.getRightPostCode1();
                    ArrayList geoRecords = null;
                    boolean isLeftRightPostCode1Same = true;
                    if (!CHE_AddressUtils.isEmpty(leftPostCode1)) {
                        geoRecords = CHE_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), leftPostCode1, dictNum);
                        isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                    }
                    if (!isLeftRightPostCode1Same && !CHE_AddressUtils.isEmpty(rightPostCode1)) {
                        ArrayList rightList = CHE_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), rightPostCode1, dictNum);
                        if (geoRecords != null && rightList != null) {
                            geoRecords.addAll(rightList);
                        } else {
                            geoRecords = rightList;
                        }
                    }
                    if (geoRecords != null) {
                        String bestArea = null;
                        for (int index = 0; index < geoRecords.size(); ++index) {
                            double[] scores2;
                            locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                            if (CHE_AddressUtils.isEmpty(locality) || !(an3Score < (scores2 = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                            an3Score = scores2[0];
                            an4Score = scores2[1];
                            bestArea = locality;
                            bestArea = locality;
                            if (an3Score == 1.0) break;
                        }
                        if (bestArea != null && bestArea.length() > 0) {
                            segment.setLeftAreaName4(bestArea);
                        }
                    }
                }
            }
            if (an3Score != 1.0 && !CHE_AddressUtils.isEmpty(an4FromGeoInfo = geoinfo.getAreaName4()) && !an4FromGeoInfo.equals(geoinfo.getAreaName3())) {
                String fullTownName;
                String string = fullTownName = CHE_AddressUtils.isEmpty(an4) ? an3 : an4;
                if (!CHE_AddressUtils.isEmpty(fullTownName)) {
                    double tempScore = scorer.scoreString(fullTownName, an4FromGeoInfo);
                    if (an3Score < tempScore) {
                        an3Score = tempScore;
                    }
                    if (an4Score < tempScore) {
                        an4Score = tempScore;
                    }
                }
            }
            if (an3Score != 1.0) {
                String altLangName = geoinfo.getAltLanguageNames();
                String candAltTownTemp = null;
                String tempAltLangName = null;
                double tempScore = 0.0;
                if (altLangName != null && altLangName.length() != 0) {
                    StringTokenizer tokens = new StringTokenizer(altLangName, "/");
                    while (tokens.hasMoreTokens()) {
                        tempAltLangName = tokens.nextToken().toUpperCase();
                        candAltTownTemp = CHE_AddressTerm.removeCommonWords(tempAltLangName, false);
                        if (tempAltLangName == null) continue;
                        tempScore = scorer.scoreString(an3, candAltTownTemp);
                        if (an3Score < tempScore) {
                            an3Score = tempScore;
                        }
                        if (an3Score != 1.0) continue;
                        break;
                    }
                }
            }
        } else if (CHE_AddressUtils.isEmpty(an3)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else {
            double[] scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getLeftAreaName3());
            an3Score = scores[0];
            double an4Score = scores[1];
            if (an3Score != 1.0 && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getRightAreaName3()))[0]) {
                an3Score = scores[0];
                an4Score = scores[1];
            }
            if (an3Score != 1.0) {
                String leftPostCode1 = segment.getLeftPostCode1();
                String rightPostCode1 = segment.getRightPostCode1();
                ArrayList geoRecords = null;
                boolean isLeftRightPostCode1Same = true;
                if (!CHE_AddressUtils.isEmpty(leftPostCode1)) {
                    geoRecords = CHE_DataManager.getGeoInfoAlias(segment.getLeftAreaName3(), leftPostCode1, dictNum);
                    isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                }
                if (!isLeftRightPostCode1Same && !CHE_AddressUtils.isEmpty(rightPostCode1)) {
                    ArrayList rightList = CHE_DataManager.getGeoInfoAlias(segment.getRightAreaName3(), rightPostCode1, dictNum);
                    if (geoRecords != null && rightList != null) {
                        geoRecords.addAll(rightList);
                    } else {
                        geoRecords = rightList;
                    }
                }
                if (geoRecords != null) {
                    for (int index = 0; index < geoRecords.size(); ++index) {
                        String locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                        if (CHE_AddressUtils.isEmpty(locality) || !(an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                        an3Score = scores[0];
                        an4Score = scores[1];
                    }
                }
            }
        }
        if (constants.getExactMatchAreaName3() ? an3Score != 1.0 : an3Score < thresholds.getAreaName3()) {
            return null;
        }
        String postcode1 = inputAddress.getPostCode1();
        if (CHE_AddressUtils.isEmpty(postcode1)) {
            postcode1Score = 1.0;
        } else {
            score = scorer.scoreString(postcode1, segment.getLeftPostCode1());
            postcode1Score = score;
            if (postcode1Score != 1.0) {
                score = scorer.scoreString(postcode1, segment.getRightPostCode1());
                double d = postcode1Score = postcode1Score < score ? score : postcode1Score;
            }
        }
        if (constants.getExactMatchPostalCode1() ? postcode1Score != 1.0 : postcode1Score < thresholds.getPostalCode1()) {
            return null;
        }
        return segment;
    }

    private double[] calculateAn3An4Scores(StringScorer scorer, String an3, String an4, String town) {
        double an3Score = 0.0;
        double an4Score = 0.0;
        if (!CHE_AddressUtils.isEmpty(town)) {
            String shortTown = CHE_ParsePostAddressRule.removeCommonWords(town);
            if (CHE_AddressUtils.isEmpty(shortTown)) {
                shortTown = town;
            }
            an3Score = scorer.scoreString(an3, shortTown);
            an4Score = shortTown.length() != town.length() ? scorer.scoreString(an4, town) : (CHE_AddressUtils.isEmpty(an4) ? 1.0 : 0.0);
        }
        return new double[]{an3Score, an4Score};
    }
}

