/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.EMEA.dp.EMEA_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.EMEA.dp.IEMEA_FlagDataSourceRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CHE_Geo2SacDataSourceRecordConvertorImpl
extends EMEA_Geo2SacDataSourceRecordConvertorImpl {
    protected CHE_GeoInfoFetcherImpl m_infoFetcher = null;

    public CHE_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex, boolean isAPDictioanry) {
        super(dataProperties, soundex);
        String geoInfoLoc = dataProperties.getProperty("geo2sac_geoinfoLoc");
        try {
            this.m_infoFetcher = new CHE_GeoInfoFetcherImpl(geoInfoLoc, null, null, isAPDictioanry);
        }
        catch (DataDictionaryIntializationException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    public CHE_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Map soundex, boolean isAPDictioanry) {
        super(dataProperties, null);
        String geoInfoLoc = dataProperties.getProperty("geo2sac_geoinfoLoc");
        try {
            this.m_infoFetcher = new CHE_GeoInfoFetcherImpl(geoInfoLoc, null, null, isAPDictioanry);
        }
        catch (DataDictionaryIntializationException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            String town = CHE_AddressTerm.cleanExtendedCharsInString(input.getAreaName3());
            String shortTown = CHE_AddressTerm.removeCommonWords(town, false);
            if (shortTown == null) {
                shortTown = town;
            }
            ArrayList<EMEA_GeoBase> baseHolder = new ArrayList<EMEA_GeoBase>(4);
            CHESwissSoundex swissSoundex = CHESwissSoundex.getSoundexInstance();
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("FRA").getSoundex(shortTown)));
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("ITA").getSoundex(shortTown)));
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("DEU").getSoundex(shortTown)));
            baseHolder.add(new EMEA_GeoBase(this.getStringKey(shortTown)));
            String firstName = this.getFirstName(shortTown);
            if (firstName != null && !firstName.equalsIgnoreCase(shortTown)) {
                baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(firstName)));
            }
            ArrayList altLangNames = (ArrayList)this.m_infoFetcher.getAltLangNames(town);
            int size = altLangNames.size();
            for (int i = 0; i < size; ++i) {
                String altLangName = CHE_AddressTerm.cleanExtendedCharsInString((String)altLangNames.get(i));
                StringTokenizer tokens = new StringTokenizer(altLangName, "/", false);
                while (tokens.hasMoreTokens()) {
                    String s = tokens.nextToken();
                    s = CHE_AddressTerm.cleanExtendedCharsInString(CHE_ParsePostAddressRule.removeCommonWords(s));
                    baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("FRA").getSoundex(s)));
                    baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("ITA").getSoundex(s)));
                    baseHolder.add(new EMEA_GeoBase((MiSoundexKey)swissSoundex.getLanguageSoundex("DEU").getSoundex(s)));
                }
            }
            short flag = (short)((IEMEA_FlagDataSourceRecord)input).getFlag();
            int length = baseHolder.size();
            for (int i = 0; i < length; ++i) {
                ((EMEA_GeoBase)baseHolder.get(i)).setFlag(flag);
            }
            IGeoBase[] bases = baseHolder.toArray(new EMEA_GeoBase[0]);
            return bases;
        }
        return null;
    }

    private MiSoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }

    protected ISoundexKey makeSoundexKey(String soundexSource) {
        String language = new CHE_PreParseHandler().preParse(soundexSource, null);
        CHESwissSoundex swissSoundex = CHESwissSoundex.getSoundexInstance();
        return swissSoundex.getLanguageSoundex(language).getSoundex(soundexSource);
    }

    protected List getSoundexKeyArray(String str, List baseHolder) {
        baseHolder.add(new EMEA_GeoBase((MiSoundexKey)CHESwissSoundex.getSoundexInstance().getLanguageSoundex("FRA").getSoundex(str)));
        baseHolder.add(new EMEA_GeoBase((MiSoundexKey)CHESwissSoundex.getSoundexInstance().getLanguageSoundex("ITA").getSoundex(str)));
        baseHolder.add(new EMEA_GeoBase((MiSoundexKey)CHESwissSoundex.getSoundexInstance().getLanguageSoundex("DEU").getSoundex(str)));
        return baseHolder;
    }
}

