/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.EMEA_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CHE_StreetDataSourceRecordConvertorImpl
extends EMEA_StreetDataSourceRecordConvertorImpl {
    public CHE_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    public CHE_StreetDataSourceRecordConvertorImpl(Map soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(null, dataProperties, generator, parser, parserConstraints);
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyString = alternateBrowseString.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = CHE_ScoringHelper.getFirstNormChar(keyString);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(CHE_AddressTerm.cleanExtendedCharsInString(keyBase));
            char c = CHE_ScoringHelper.getFirstNormChar(keyBase);
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    @Override
    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = CHE_InternalCandidateAddress.reconstructAddress(new InternalCandidateAddress(parsed));
        HashMap<String, String> additionalFMap = parsed.getAdditionalFields();
        if (additionalFMap == null) {
            additionalFMap = new HashMap<String, String>();
        }
        additionalFMap.put("original_street_name", original_street);
        parsed.setAdditionalFields(additionalFMap);
        boolean result = parsed_street.equalsIgnoreCase(original_street);
        return result;
    }

    protected MMJStreetRecord createAlternateStreetRecord(MMJStreetRecord standardRecord, IStreetDataSourceRecord input, Address parsed) throws DataCreationException, DataSourceException {
        if (parsed == null) {
            return null;
        }
        String original_street = input.getMainAddress();
        if (!this.canReassembleAddress(original_street, parsed)) {
            parsed.setGenericField4(original_street);
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setSac(standardRecord.getSac());
        record.setAddress(parsed);
        record.setKey(this.makeStreetSearchKey(parsed, record.getSac()));
        this.assignBrowseKeys(record);
        record.setSegment(standardRecord.getSegment());
        this.populateAlternateDataItems(record, input, record.getSac());
        return record;
    }

    @Override
    protected ArrayList getKeyBases(Address address) {
        ArrayList keyBases = super.getKeyBases(address);
        keyBases.add(CHE_AddressUtils.getFormattedStreetAddress(address, false).toUpperCase());
        return keyBases;
    }

    @Override
    protected String makeMainAddressString(String street, String houseNumber) {
        return street;
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        ArrayList<Address> list = new ArrayList<Address>();
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address addr = this.getParsedStreet(input, preParsed);
        if (addr != null) {
            String[] mainAddrTokens;
            String[] preAddrTokens;
            list.add(addr);
            String preAddr = addr.getPreAddress();
            String mainAddr = addr.getMainAddress();
            if (preAddr != null && mainAddr != null && (preAddrTokens = preAddr.split("-")).length == 2 && (mainAddrTokens = mainAddr.split("[ \\-]")).length == 1) {
                preParsed = this.makePreParsedAddress(input);
                addr = this.getParsedStreet(input, preParsed);
                if (addr != null) {
                    addr.setPreAddress(preAddrTokens[0]);
                    addr.setMainAddress(preAddrTokens[1] + mainAddr);
                    list.add(addr);
                }
                if ((addr = this.getParsedStreet(input, preParsed = this.makePreParsedAddress(input))) != null) {
                    addr.setPreAddress(null);
                    addr.setMainAddress(preAddrTokens[0] + preAddrTokens[1] + mainAddr);
                    list.add(addr);
                }
            }
        }
        return list;
    }

    protected ISoundexKey getStringKey(String inputString) {
        CHESwissSoundex swissSoundex = CHESwissSoundex.getSoundexInstance();
        this.m_soundex = swissSoundex.getLanguageSoundex(swissSoundex.getLanguage(inputString));
        return ((GenericSoundex)this.m_soundex).getStringKey(inputString);
    }

    protected ISoundexKey makeSoundexKey(String soundexSource) {
        return CHESwissSoundex.getSoundexInstance().getSoundex(soundexSource);
    }

    protected int[] getLeftSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasLeftSAC()) {
                String leftSac = String.valueOf(input.getLeftSAC());
                int value = this.NO_SAC;
                if (Integer.valueOf(leftSac) != this.NO_SAC) {
                    value = Integer.valueOf(leftSac);
                }
                return new int[]{value};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    private int[] getFinalSacs(int sacFromPost2Sac, int[] sacsFromGeo2Sac) {
        if (sacFromPost2Sac != this.NO_SAC) {
            for (int i = 0; i < sacsFromGeo2Sac.length; ++i) {
                if (sacFromPost2Sac != sacsFromGeo2Sac[i]) continue;
                return new int[]{sacFromPost2Sac};
            }
            if (sacsFromGeo2Sac[0] != this.NO_SAC) {
                return new int[]{sacFromPost2Sac, sacsFromGeo2Sac[0]};
            }
            return new int[]{sacFromPost2Sac};
        }
        if (sacsFromGeo2Sac[0] != this.NO_SAC) {
            return new int[]{sacsFromGeo2Sac[0]};
        }
        return new int[]{this.NO_SAC};
    }

    protected int[] getRightSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasRightSAC()) {
                String rightSac = String.valueOf(input.getRightSAC());
                int value = this.NO_SAC;
                if (Integer.valueOf(rightSac) != this.NO_SAC) {
                    value = Integer.valueOf(rightSac);
                }
                return new int[]{value};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    @Override
    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        if (convertLeft && !convertRight) {
            record.setRightAreaName1(record.getLeftAreaName1());
            record.setRightAreaName2(record.getLeftAreaName2());
            record.setRightAreaName3(record.getLeftAreaName3());
            record.setRightAreaName4(record.getLeftAreaName4());
        } else if (!convertLeft && convertRight) {
            record.setLeftAreaName1(record.getRightAreaName1());
            record.setLeftAreaName2(record.getRightAreaName2());
            record.setLeftAreaName3(record.getRightAreaName3());
            record.setLeftAreaName4(record.getRightAreaName4());
        }
        return record;
    }
}

