/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.ap;

import com.mapinfo.mapmarker.CHE.dp.CHE_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.CHE.dp.IAPRangeAttributeDataSourceRecord;
import com.mapinfo.mapmarker.CHE.dp.binary.ap.CHE_MMJAPRangeRecord;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.core.parser.IParser;
import java.util.Map;
import java.util.Properties;

public class CHE_APStreetDataSourceRecordConverter
extends CHE_StreetDataSourceRecordConvertorImpl {
    public CHE_APStreetDataSourceRecordConverter(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    public CHE_APStreetDataSourceRecordConverter(Map soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new CHE_MMJAPRangeRecord();
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        CHE_MMJAPRangeRecord rangeRecord = (CHE_MMJAPRangeRecord)super.convertRangeRecord(input, sac);
        IAPRangeAttributeDataSourceRecord rangeSource = (IAPRangeAttributeDataSourceRecord)input;
        if (rangeRecord != null) {
            if (rangeSource.hasPositionAccuracy()) {
                rangeRecord.setPositionAccuracy(rangeSource.getPositionAccuracy());
            }
            if (rangeSource.hasPointID()) {
                rangeRecord.setPoinID(rangeSource.getPointID());
            }
            this.modifyRangeFromnTo(rangeRecord);
        }
        return rangeRecord;
    }

    private void modifyRangeFromnTo(CHE_MMJAPRangeRecord rangeRecord) {
        ParsedNumber toNum;
        ParsedNumber fromNum = rangeRecord.getFromHouse();
        if (fromNum.hasNumberSeparator() && fromNum.hasAddressSuffix() && " ".equals(fromNum.getNumberSeparator())) {
            fromNum.setNumberSeparator(null);
        }
        if ((toNum = rangeRecord.getToHouse()).hasNumberSeparator() && toNum.hasAddressSuffix() && " ".equals(toNum.getNumberSeparator())) {
            toNum.setNumberSeparator(null);
        }
    }

    @Override
    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        return 0;
    }

    @Override
    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        int inputSAC = leftSac != this.NO_SAC ? leftSac : rightSac;
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsed = this.getParsedStreet(input, preParsed);
        if (parsed == null) {
            return null;
        }
        String original_street = input.getMainAddress();
        if (!this.canReassembleAddress(original_street, parsed)) {
            parsed.setGenericField4(original_street);
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setAddress(parsed);
        record.setSac(inputSAC);
        record.setKey(this.makeStreetSearchKey(parsed, inputSAC));
        if (record.getKey() == null) {
            DataCreationLogger.getLogger().logError("Could not generate a search key for address '" + input.getMainAddress() + "'");
            return null;
        }
        this.assignBrowseKeys(record);
        ISegmentDataSourceRecord inputSegment = input.getSegment();
        MMJSegmentRecord segment = this.convertSegmentRecord(inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        if (segment != null) {
            this.addRangesToSegment(segment, inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
            if (!segment.isPointHouseSegment()) {
                DataCreationLogger.getLogger().logInternalError("DEU_APStreetDataSourceRecordConvertorImpl::createStreetRecord() Invalid Segment() - Range is not valid.Hence record will not be added as Segment");
                return null;
            }
        } else {
            return null;
        }
        record.setSegment(segment);
        this.populateAlternateDataItems(record, input, inputSAC);
        return record;
    }
}

