/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.dp.CHE_DataConstructionParser;
import com.mapinfo.mapmarker.CHE.dp.CHE_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.CHE.dp.CHE_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.CHE.dp.CHE_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.CHE.dp.ap.CHE_APStreetDataSourceRecordConverter;
import com.mapinfo.mapmarker.CHE.dp.binary.CHEDataWriter;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataFileMasksProvider;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_StreetBuilder;
import com.mapinfo.mapmarker.CHE.dp.binary.ap.CHE_APStreetBuilder;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_PostInfoIndexFileConvertor;
import com.mapinfo.mapmarker.CHE.dp.intermediate.CHE_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CHE.dp.intermediate.ap.CHE_APIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_TabDataProvider;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public abstract class CHE_AbstractDataProvider
extends EMEA_TabDataProvider {
    static MiVersion m_version = new MiVersion(4, 0, 0);
    private static GeoInfoSoundexIndexer m_geoInfoSoundexIndexer = null;
    private CHESwissSoundex m_swissSoundex;
    private static final String m_frenchExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/FRAExtendedCharacters.properties";
    private static final String m_italianExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/ITAExtendedCharacters.properties";
    private static final String m_germanExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/DEUExtendedCharacters.properties";
    private static final String m_frenchSoundexFile = "com/mapinfo/mapmarker/CHE/parser/FRASoundex.properties";
    private static final String m_italianSoundexFile = "com/mapinfo/mapmarker/CHE/parser/ITASoundex.properties";
    private static final String m_germanSoundexFile = "com/mapinfo/mapmarker/CHE/parser/DEUSoundex.properties";
    private static MMJComplexDataFileMetadata m_streetMetadata;
    private static MMJComplexDataFileMetadata m_geoInfoMetadata;
    private static MMJComplexDataFileMetadata m_postInfoMetadata;
    protected boolean m_bAPStreetData;

    CHE_AbstractDataProvider() {
        this.m_dataWriter = new CHEDataWriter((IDataProvider)this);
    }

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        String apKey = processingProperties.getProperty("AP_PROCESSING", "");
        this.m_bAPStreetData = apKey != null ? apKey.equals("YES") : false;
        this.m_dataBuilder = this.m_bAPStreetData ? new CHE_APStreetBuilder(processingProperties, this.m_bAPStreetData) : new CHE_StreetBuilder(processingProperties, this.m_bAPStreetData);
        Constraints constraints = new Constraints();
        ExtendedCharacters frenchextendedCharacters = new ExtendedCharacters(m_frenchExtendedCharacterFile);
        ExtendedCharacters italianextendedCharacters = new ExtendedCharacters(m_italianExtendedCharacterFile);
        ExtendedCharacters germanextendedCharacters = new ExtendedCharacters(m_germanExtendedCharacterFile);
        GenericSoundex FRENCHSOUNDEX = new GenericSoundex(m_frenchSoundexFile, frenchextendedCharacters);
        GenericSoundex ITALIANSOUNDEX = new GenericSoundex(m_italianSoundexFile, italianextendedCharacters);
        GenericSoundex GERMANSOUNDEX = new GenericSoundex(m_germanSoundexFile, germanextendedCharacters);
        HashMap<String, GenericSoundex> soundexMap = new HashMap<String, GenericSoundex>();
        soundexMap.put("FRA", FRENCHSOUNDEX);
        soundexMap.put("DEU", GERMANSOUNDEX);
        soundexMap.put("ITA", ITALIANSOUNDEX);
        this.m_swissSoundex = CHESwissSoundex.getSoundexInstance();
        this.m_swissSoundex.setSoundexMap(soundexMap);
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geo2sac_operation = processingProperties.getProperty("geo2sac_flag");
        if (geo2sac_operation != null) {
            this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new CHE_Geo2SacDataSourceRecordConvertorImpl(processingProperties, this.m_swissSoundex.getSoundexMap(), this.m_bAPStreetData), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(false));
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new CHE_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String processStreets = (String)processingProperties.get("street_create");
        if (processStreets != null && processStreets.equals("YES")) {
            CHE_IntermediateStreetDataFileFormatHandler intermediateHandler;
            CHE_StreetDataSourceRecordConvertorImpl streetRecordConvertor;
            String intermediateHandlerPath = StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp");
            if (this.m_bAPStreetData) {
                streetRecordConvertor = new CHE_APStreetDataSourceRecordConverter(this.m_swissSoundex.getSoundexMap(), processingProperties, new CollationKeyGenerator(new Locale("CH", "CHE"), CHE_ScoringHelper.getCollationRules()), (IParser)new CHE_DataConstructionParser(this.m_swissSoundex.getSoundexMap(), new CHE_ParsePostAddressRule()), constraints);
                intermediateHandler = new CHE_APIntermediateStreetDataFileFormatHandler(intermediateHandlerPath);
            } else {
                streetRecordConvertor = new CHE_StreetDataSourceRecordConvertorImpl(this.m_swissSoundex.getSoundexMap(), processingProperties, new CollationKeyGenerator(new Locale("CH", "CHE"), CHE_ScoringHelper.getCollationRules()), (IParser)new CHE_DataConstructionParser(this.m_swissSoundex.getSoundexMap(), new CHE_ParsePostAddressRule()), constraints);
                intermediateHandler = new CHE_IntermediateStreetDataFileFormatHandler(intermediateHandlerPath);
            }
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetRecordConvertor, (IIntermediateDataHandler)intermediateHandler, (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new CHE_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        this.m_swissSoundex = CHESwissSoundex.getSoundexInstance();
        if (m_geoInfoSoundexIndexer == null) {
            m_geoInfoSoundexIndexer = new CHE_GeoInfoSoundexIndexer(this.m_swissSoundex.getSoundexMap());
        }
        return m_geoInfoSoundexIndexer;
    }

    @Override
    public void processStreets(boolean bCreateStatistics) throws DataCreationException {
        ((CHE_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.getGeoInfoForStreetsFileBaseName());
        super.processStreets(bCreateStatistics);
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (m_streetMetadata == null) {
            m_streetMetadata = new MMJComplexDataFileMetadata();
            DataFileMasks masks = this.getStreetDataFileMasks();
            m_streetMetadata.setDataFileMasks(masks);
            this.setMetaDataProperties(m_streetMetadata);
            if (this.m_bAPStreetData) {
                m_streetMetadata.setXPow10((byte)6);
                m_streetMetadata.setYPow10((byte)6);
            } else {
                m_streetMetadata.setXPow10((byte)5);
                m_streetMetadata.setYPow10((byte)5);
            }
            m_streetMetadata.setVendorCode(this.getVandorAndDataType());
        }
        return m_streetMetadata;
    }

    protected DataFileMasks getStreetDataFileMasks() {
        DataFileMasks masks = null;
        masks = this.m_bAPStreetData ? CHE_DataFileMasksProvider.getAPStreetMasks() : CHE_DataFileMasksProvider.buildStreetDataFileMasks();
        return masks;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (m_postInfoMetadata == null) {
            m_postInfoMetadata = new MMJComplexDataFileMetadata();
            m_postInfoMetadata.setDataFileMasks(CHE_DataFileMasksProvider.buildPostInfoDataFileMasks());
            this.setMetaDataProperties(m_postInfoMetadata);
        }
        m_postInfoMetadata.setVendorCode(this.getVandorAndDataType());
        return m_postInfoMetadata;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        if (m_geoInfoMetadata == null) {
            m_geoInfoMetadata = new MMJComplexDataFileMetadata();
            m_geoInfoMetadata.setDataFileMasks(CHE_DataFileMasksProvider.buildGeoInfoDataFileMasks());
            this.setMetaDataProperties(m_geoInfoMetadata);
        }
        m_geoInfoMetadata.setVendorCode(this.getVandorAndDataType());
        return m_geoInfoMetadata;
    }

    public IndexFileConvertor getPostInfoIndexFileConvertor(String tempIndex, String newIndex) {
        return new CHE_PostInfoIndexFileConvertor(tempIndex, newIndex);
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new CHE_MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    private void setMetaDataProperties(MMJComplexDataFileMetadata metadata) {
        metadata.setCountry("CHE");
        metadata.setXPow10((byte)5);
        metadata.setYPow10((byte)5);
        metadata.setVersion(m_version);
    }

    public boolean supportsReverseGeocode() {
        return true;
    }
}

