/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_AddressFetcher;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_MMJSac2FnData;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataDictionary;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_Geo2SacRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CHE_DataDictionary
extends EMEA_DataDictionary {
    private static final String NO_SAC2FN_FILE = "exception.no.sac2fn";
    private static final String SAC2FN_FILE_OPEN = "exception.open.sac2fn";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_GEOBASE_USE_PROVINCE_SEARCH = "KEY_GEOBASE_USE_PROVINCE_SEARCH";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_DEU_ALTERNATE_SOUNDEX_CODES = "KEY_DEU_ALTERNATE_SOUNDEX_CODES";
    public static final String KEY_GEOBASE_STRING_ONLY = "KEY_GEOBASE_STRING_ONLY";
    public static final short GEOBASE_AREA1_FLAG = 1;
    private static final String KEY_GEOBASE_USE_THIS_TOWN = "key_geobase_use_this_town";
    public static final String KEY_IGNORE_NO_SAC_ERROR = "KEY_IGNORE_NO_SAC_ERROR";
    public static final String KEY_STREETS_TO_REMOVE = "KEY_STREETS_TO_REMOVE";
    public static final String KEY_SAC_MUSTMATCH_GEO_AND_POSTAL = "KEY_SAC_MUSTMATCH_GEO_AND_POSTAL";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    private static Soundex m_soundex;
    private boolean m_isAPDictionary;
    private static final CollationKeyGenerator m_collationKeyGenerator;

    public CHE_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    @Override
    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        boolean bAreaName1;
        IGeoBase[] retbases = null;
        ISoundexKey sndxKey3 = null;
        ISoundexKey sndxKey1 = null;
        String areaName3 = pa.getAreaName3();
        String language = (String)((CHE_Handler)preferences.getHandler()).getPreParsedAddress().getAdditionalFields().get("highest_scoring_language");
        GenericSoundex languageSoundex = CHESwissSoundex.getSoundexInstance().getLanguageSoundex(language);
        boolean isGeographicCentroid = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID));
        boolean bStringKey = new Boolean(preferences.getCustomString(KEY_GEOBASE_STRING_ONLY));
        String strTownToUse = preferences.getCustomString(KEY_GEOBASE_USE_THIS_TOWN);
        sndxKey3 = isGeographicCentroid ? languageSoundex.getSoundex(areaName3) : (bStringKey ? (strTownToUse == null || strTownToUse.trim().length() == 0 ? this.getSoundexString(languageSoundex, areaName3) : this.getSoundexString(languageSoundex, strTownToUse)) : (strTownToUse == null || strTownToUse.trim().length() == 0 ? languageSoundex.getSoundex(areaName3) : languageSoundex.getSoundex(strTownToUse)));
        String province = pa.getAreaName2();
        if (province != null) {
            sndxKey1 = languageSoundex.getSoundex(province);
        }
        if (isGeographicCentroid) {
            IGeoBase[] bases = null;
            if (sndxKey3 != null && sndxKey1 != null) {
                bases = new IGeoBase[]{new MiSoundexGeoBase((MiSoundexKey)sndxKey1), new MiSoundexGeoBase((MiSoundexKey)sndxKey3)};
            } else if (sndxKey3 != null || sndxKey1 != null) {
                bases = new IGeoBase[]{sndxKey3 != null ? new MiSoundexGeoBase((MiSoundexKey)sndxKey3) : new MiSoundexGeoBase((MiSoundexKey)sndxKey1)};
            }
            return bases;
        }
        if (bStringKey) {
            sndxKey3 = this.getSoundexString(languageSoundex, areaName3);
            if (province != null) {
                sndxKey1 = this.getSoundexString(languageSoundex, province);
            }
        }
        Vector<EMEA_GeoBase> bases = new Vector<EMEA_GeoBase>(3);
        if (sndxKey1 != null && (bAreaName1 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA1)).booleanValue())) {
            bases.add(new EMEA_GeoBase((MiSoundexKey)sndxKey1, 1));
        }
        if (sndxKey3 != null) {
            boolean bAreaName3 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA3));
            boolean bAreaName4 = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4));
            if (bAreaName3) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)sndxKey3, 3));
            }
            if (bAreaName4) {
                bases.add(new EMEA_GeoBase((MiSoundexKey)sndxKey3, 4));
            }
        }
        if (bases.size() > 0) {
            retbases = new IGeoBase[bases.size()];
            for (int i = 0; i < bases.size(); ++i) {
                retbases[i] = (EMEA_GeoBase)bases.get(i);
            }
        }
        return retbases;
    }

    @Override
    protected IPostalBase makePostalBase(String zipCode) {
        StandardPostalBase postalBase = null;
        if (zipCode != null && zipCode.length() < 5) {
            postalBase = new StandardPostalBase(zipCode.substring(0, zipCode.length()));
        }
        return postalBase;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new EMEA_Geo2SacRecord();
    }

    protected IAddressFetcher initAddressFetcher() {
        return new CHE_AddressFetcher(this.getDataManagerSettings(), null, this.m_isAPDictionary);
    }

    protected MMJSac2FnData initSac2FnData() throws DataDictionaryIntializationException {
        try {
            CHE_MMJSac2FnData data = new CHE_MMJSac2FnData(super.getDictionaryPath());
            this.m_isAPDictionary = data.isAPDictionary();
            this.setIsUserDictionary(data.forUserDictionary());
            return data;
        }
        catch (FileNotFoundException FNFEx) {
            throw new DataDictionaryIntializationException(NO_SAC2FN_FILE, (Throwable)FNFEx);
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(SAC2FN_FILE_OPEN, (Throwable)IOEx);
        }
    }

    public boolean isAPDictionary() {
        return this.m_isAPDictionary;
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        switch (i) {
            case 0: {
                IGeoBase[] bases;
                boolean bStringKey = new Boolean(preferences.getCustomString(KEY_GEOBASE_STRING_ONLY));
                if (bStringKey) {
                    preferences.removeCustomObject((Object)KEY_GEOBASE_STRING_ONLY);
                    bases = this.getGeoBases(pa, preferences);
                    preferences.setCustomString(KEY_GEOBASE_STRING_ONLY, "true");
                    if (bases != null && bases.length > 0) {
                        return bases;
                    }
                }
            }
            case 1: {
                StringTokenizer st;
                String town = pa.getAreaName3();
                if (town != null && (town.indexOf(" ") != -1 || town.indexOf("-") != -1) && (st = new StringTokenizer(town, "- ", false)).hasMoreTokens()) {
                    town = st.nextToken();
                    preferences.setCustomObject((Object)KEY_GEOBASE_USE_THIS_TOWN, (Object)town);
                    IGeoBase[] bases = this.getGeoBases(pa, preferences);
                    preferences.removeCustomObject((Object)KEY_GEOBASE_USE_THIS_TOWN);
                    if (bases != null && bases.length > 0) {
                        return bases;
                    }
                }
            }
            case 2: {
                IGeoBase[] bases;
                boolean bSearchProvince = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA1));
                if (!(bSearchProvince || pa.getAreaName1() == null && pa.getAreaName2() == null)) {
                    preferences.setCustomString(KEY_GEOBASE_FOR_AREA1, "true");
                    bases = this.getGeoBases(pa, preferences);
                    preferences.removeCustomObject((Object)KEY_GEOBASE_FOR_AREA1);
                    if (bases != null && bases.length > 0) {
                        return bases;
                    }
                }
            }
            case 3: {
                boolean bStringLocality = new Boolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4));
                if (bStringLocality) break;
                preferences.setCustomString(KEY_GEOBASE_FOR_AREA4, "true");
                IGeoBase[] bases = this.getGeoBases(pa, preferences);
                preferences.removeCustomObject((Object)KEY_GEOBASE_FOR_AREA4);
                if (bases == null || bases.length <= 0) break;
                return bases;
            }
        }
        return null;
    }

    @Override
    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new CHE_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null, this.m_isAPDictionary);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        CHE_PostInfoFetcherImpl postInfoFetcher = null;
        if (!this.isUserDictionary()) {
            postInfoFetcher = new CHE_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null, this.m_isAPDictionary);
        }
        return postInfoFetcher;
    }

    @Override
    protected Soundex getSoundex() {
        return m_soundex;
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddrItem = addr.getMainAddress();
        if (CHE_AddressUtils.isEmpty(mainAddrItem)) {
            return null;
        }
        if (CHE_AddressTerm.isCommonWord(addr.getPreAddress())) {
            HashMap<String, String> mapa = addr.getAdditionalFields();
            if (mapa == null) {
                mapa = new HashMap<String, String>();
            }
            mapa.put("pre_addr_common", addr.getPreAddress());
            addr.setPreAddress(null);
            addr.setAdditionalFields(mapa);
        }
        String browseStrKey = CHE_AddressTerm.cleanExtendedCharsInString(CHE_AddressUtils.getFormattedStreetAddress(addr, false));
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        if (CHE_AddressUtils.isEmpty(addr.getPlaceName())) {
            return null;
        }
        String browseStrKey = addr.getPlaceName().trim();
        if (CHE_AddressUtils.isEmpty(browseStrKey)) {
            return null;
        }
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = CHE_ScoringHelper.getFirstNormChar(CHE_AddressTerm.cleanExtendedCharsInString(browseStrKey));
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        String origStr = addr.getMainAddress();
        String lang = ((CHE_Handler)constraints.getHandler()).getCountryCode();
        ISoundexKey origKey = CHESwissSoundex.getSoundexInstance().getLanguageSoundex(lang).getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)KEY_DEU_ALTERNATE_SOUNDEX_CODES);
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        ArrayList alternates = new ArrayList();
        alternates.add(origKey);
        GenericSoundex soundex = CHESwissSoundex.getSoundexInstance().getLanguageSoundex(lang);
        alternates = (ArrayList)soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }

    @Override
    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        CHE_DictionaryGeographyInfo info = new CHE_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        String[] streetDataFileNames = this.getStreetDataFileNames();
        if (streetDataFileNames != null && streetDataFileNames.length > 0) {
            info.setHasStreets(true);
            info.setHasCentroids(true);
        }
        if (this.isUserDictionary()) {
            info.setIsUserDictionary(true);
        } else {
            info.setIsUserDictionary(false);
        }
        if (this.m_isAPDictionary) {
            info.setIsAPDictionanry(true);
        } else {
            info.setIsAPDictionanry(false);
        }
        return info;
    }

    private ISoundexKey getSoundexString(GenericSoundex soundex, String str) {
        return soundex.getStringKey(str);
    }

    @Override
    protected MapMarkerIndexKey[] getAlternateSearchBases(byte alternateType, Address addr, IConstraints constraints) {
        MapMarkerIndexKey[] keys = null;
        String countryLanguage = ((CHE_Handler)constraints.getHandler()).getCountryCode();
        CHESwissSoundex soundex = CHESwissSoundex.getSoundexInstance();
        if (this.isUserDictionary()) {
            switch (alternateType) {
                case 0: {
                    ISoundexKey origKey;
                    String placeName = addr.getPlaceName();
                    if (placeName == null || placeName.length() == 0 || (origKey = soundex.getLanguageSoundex(countryLanguage).getSoundex(placeName)) == null) break;
                    MapMarkerStreetMultiLevelIndexKey key = new MapMarkerStreetMultiLevelIndexKey(-1, (MiSoundexKey)origKey);
                    keys = new MapMarkerIndexKey[]{key};
                }
            }
        }
        return keys;
    }

    static {
        m_collationKeyGenerator = new CollationKeyGenerator(new Locale("CH", "CHE"), CHE_ScoringHelper.getCollationRules());
    }
}

