/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.CHE_InternalPostalCandidate;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_PostInfoIndex;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_PostInfoIndexValue;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CHE_PostInfoFetcherImpl
extends EMEA_PostInfoFetcherImpl {
    private boolean m_isAPCandidate;

    public CHE_PostInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages, boolean isAPCandiate) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
        this.m_isAPCandidate = isAPCandiate;
    }

    protected ICandidate getPostInfoCandidateType() {
        return new CHE_InternalPostalCandidate(this.m_isAPCandidate);
    }

    protected IMapMarkerIndex getPostInfoIndexType() {
        return new CHE_PostInfoIndex();
    }

    @Override
    public List getPostInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        if (this.getPostInfoIndex() == null) {
            return null;
        }
        ArrayList<ICandidate> candidates = null;
        MapMarkerIndexKey[] keys = this.makePostInfoKeys(addr, constraints);
        if (keys != null) {
            int keyCount = keys.length;
            for (int i = 0; i < keyCount; ++i) {
                CHE_PostInfoIndexValue value = (CHE_PostInfoIndexValue)this.getPostInfoIndex().search(keys[i]);
                if (value == null) continue;
                GenericDataItem item = null;
                try {
                    short valueCount = value.getValueCount();
                    for (short valueOffset = 0; valueOffset < valueCount; valueOffset = (short)(valueOffset + 1)) {
                        item = (GenericDataItem)this.getPostInfoDataAccess().getRecord(value.getOffsetAt(valueOffset));
                        ICandidate candidate = this.makePostalCandidate(item);
                        if (candidate == null) continue;
                        if (candidates == null) {
                            candidates = new ArrayList<ICandidate>();
                        }
                        candidates.add(candidate);
                    }
                    continue;
                }
                catch (DataAccessException dataAccessException) {
                    // empty catch block
                }
            }
        }
        return candidates;
    }
}

