/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.ud.tab;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.dp.CHE_DataConstructionParser;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_StreetBuilder;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_TabDataProvider;
import com.mapinfo.mapmarker.CHE.dp.binary.ap.CHE_APStreetBuilder;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.CHE.dp.intermediate.CHE_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CHE.dp.intermediate.ap.CHE_APIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CHE.dp.tab.CHE_APTabStreetDataHandler;
import com.mapinfo.mapmarker.CHE.dp.ud.CHE_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.CHE.dp.ud.tab.CHE_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.EMEA.dp.tab.EMEA_TabStreetDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.generic.soundex.ExtendedCharacters;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class CHE_TabUDDataProvider
extends AbstractUDDataProvider {
    private static GeoInfoSoundexIndexer m_GeoInfoSoundexIndexer = null;
    private CHE_TabDataProvider m_tabDataProvider = new CHE_TabDataProvider();
    private String m_geoInfoPathAndBaseName;
    private CHE_UDStreetDataSourceRecordConvertor m_CHEStreetRecordConverter = null;
    private static final String m_frenchExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/FRAExtendedCharacters.properties";
    private static final String m_italianExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/ITAExtendedCharacters.properties";
    private static final String m_germanExtendedCharacterFile = "com/mapinfo/mapmarker/CHE/parser/DEUExtendedCharacters.properties";
    private static final String m_frenchSoundexFile = "com/mapinfo/mapmarker/CHE/parser/FRASoundex.properties";
    private static final String m_italianSoundexFile = "com/mapinfo/mapmarker/CHE/parser/ITASoundex.properties";
    private static final String m_germanSoundexFile = "com/mapinfo/mapmarker/CHE/parser/DEUSoundex.properties";
    private CHESwissSoundex m_swissSoundex;
    private boolean m_APStreetData;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    @Override
    public MMJComplexDataFileMetadata getGeoInfoMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getGeoInfoMetadata();
        metadata.setDataFileMasks(this.getGeoInfoDataFileMasks());
        metadata.setVendorCode(10);
        return metadata;
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        this.m_swissSoundex = CHESwissSoundex.getSoundexInstance();
        if (m_GeoInfoSoundexIndexer == null) {
            m_GeoInfoSoundexIndexer = new CHE_GeoInfoSoundexIndexer(this.m_swissSoundex.getSoundexMap());
            ((CHE_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
        }
        return m_GeoInfoSoundexIndexer;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_APStreetData = this.identifyDicationary(processingProperties);
        this.m_dataBuilder = new CHE_StreetBuilder(processingProperties, this.m_APStreetData);
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_postInfoDataHandler = null;
        this.m_geoInfoDataHandler = new CHE_UDGeoInfoDataHandler();
        Constraints constraints = new Constraints();
        ExtendedCharacters frenchextendedCharacters = new ExtendedCharacters(m_frenchExtendedCharacterFile);
        ExtendedCharacters italianextendedCharacters = new ExtendedCharacters(m_italianExtendedCharacterFile);
        ExtendedCharacters germanextendedCharacters = new ExtendedCharacters(m_germanExtendedCharacterFile);
        GenericSoundex FRENCHSOUNDEX = new GenericSoundex(m_frenchSoundexFile, frenchextendedCharacters);
        GenericSoundex ITALIANSOUNDEX = new GenericSoundex(m_italianSoundexFile, italianextendedCharacters);
        GenericSoundex GERMANSOUNDEX = new GenericSoundex(m_germanSoundexFile, germanextendedCharacters);
        HashMap<String, GenericSoundex> soundexMap = new HashMap<String, GenericSoundex>();
        soundexMap.put("FRA", FRENCHSOUNDEX);
        soundexMap.put("DEU", GERMANSOUNDEX);
        soundexMap.put("ITA", ITALIANSOUNDEX);
        this.m_swissSoundex = CHESwissSoundex.getSoundexInstance();
        this.m_swissSoundex.setSoundexMap(soundexMap);
        this.m_CHEStreetRecordConverter = new CHE_UDStreetDataSourceRecordConvertor(processingProperties, (UDPost2SacDataHandler)this.m_post2sacDataHandler, (UDGeo2SacDataHandler)this.m_geo2sacDataHandler, this.m_swissSoundex.getSoundexMap(), new CollationKeyGenerator(new Locale("ch", "CHE"), CHE_ScoringHelper.getCollationRules()), (IParser)new CHE_DataConstructionParser(this.m_swissSoundex.getSoundexMap(), new CHE_ParsePostAddressRule()), constraints, (IUDNonStreetDataHandler)((CHE_UDGeoInfoDataHandler)this.m_geoInfoDataHandler), this.m_APStreetData);
        String tempStreetFileFullName = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"street.tmp");
        if (!this.m_APStreetData) {
            this.m_streetDataHandler = new EMEA_TabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_CHEStreetRecordConverter, (IIntermediateDataHandler)new CHE_IntermediateStreetDataFileFormatHandler(tempStreetFileFullName), new CHE_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        } else {
            this.m_dataBuilder = new CHE_APStreetBuilder(processingProperties, this.m_APStreetData);
            this.m_streetDataHandler = new CHE_APTabStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)this.m_CHEStreetRecordConverter, (IIntermediateDataHandler)new CHE_APIntermediateStreetDataFileFormatHandler(tempStreetFileFullName), new CHE_MMJStreetRecordComparator(), new MMJSegmentComparer(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        String geoUDFilePath = processingProperties.getProperty("geoInfo_outputFilePath");
        this.m_geoInfoPathAndBaseName = geoUDFilePath + File.separator + "geoinfo";
    }

    public void processStreets(boolean createStatistics) throws DataCreationException {
        try {
            super.processStreets(createStatistics);
        }
        finally {
            if (this.m_CHEStreetRecordConverter != null) {
                this.m_CHEStreetRecordConverter.close();
                this.m_CHEStreetRecordConverter = null;
            }
        }
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
        ((EMEA_StreetBuilder)this.m_dataBuilder).setGeoInfoBaseName(this.m_geoInfoPathAndBaseName);
    }

    @Override
    public void createOtherFiles() throws DataCreationException {
        super.copyOtherFiles();
    }

    private void convertGeoInfoIndexFile() throws DataCreationException {
        this.processGeoInfo(false);
        IndexFileConvertor geoInfoStandardConvertor = this.getExactMatchGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tdx", this.m_geoInfoPathAndBaseName + ".jdx");
        if (geoInfoStandardConvertor != null) {
            try {
                DataCreationLogger.getLogger().logStatus("Creating geoInfo exact index file.");
                geoInfoStandardConvertor.convert();
                DataCreationLogger.getLogger().logStatus("Finished creating geoInfo exact index file.");
            }
            catch (DataCreationException e) {
                throw new DataCreationException(400, (Throwable)e);
            }
        }
        this.deleteFile(this.m_geoInfoPathAndBaseName + ".tdx");
        GeoInfoSoundexIndexer indexer = this.getGeoInfoSoundexIndexer();
        if (indexer != null) {
            DataCreationLogger.getLogger().logStatus("Creating temporary geoInfo soundex index file.");
            indexer.processGeoInfoFile(this.m_geoInfoPathAndBaseName);
            DataCreationLogger.getLogger().logStatus("Finished creating temporary geoInfo soundex index file.");
            IndexFileConvertor geoInfoSoundexConvertor = this.getSoundexGeoInfoIndexConvertor(this.m_geoInfoPathAndBaseName + ".tsx", this.m_geoInfoPathAndBaseName + ".sdx");
            if (geoInfoSoundexConvertor != null) {
                try {
                    DataCreationLogger.getLogger().logStatus("Creating geoInfo soundex index file.");
                    geoInfoSoundexConvertor.convert();
                    this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
                    DataCreationLogger.getLogger().logStatus("Finished creating soundex geoInfo index file.");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(400, (Throwable)e);
                }
            } else {
                this.deleteFile(this.m_geoInfoPathAndBaseName + ".tsx");
            }
        }
    }

    public DataFileMasks getPostInfoDataFileMasks() {
        return null;
    }

    public DataFileMasks getGeoInfoDataFileMasks() {
        return new DataFileMasks();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() throws DataCreationException {
        MMJComplexDataFileMetadata metadata = this.m_tabDataProvider.getStreetMetadata();
        metadata.setVendorCode(10);
        return metadata;
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new CHE_MiStringIndexFileConvertor(tempIndex, newIndex);
    }

    public boolean isAPDataProvider() {
        return this.m_APStreetData;
    }

    private boolean identifyDicationary(Properties processingsProperties) {
        boolean isAP = false;
        String hasLefStartthsnum = processingsProperties.getProperty("street_toLeft");
        String hasRightStarthsnum = processingsProperties.getProperty("street_toRight");
        String hasLeftEndhsnum = processingsProperties.getProperty("street_fromLeft");
        String hasRightEndhsnum = processingsProperties.getProperty("street_fromRight");
        if (hasLefStartthsnum == null || hasRightStarthsnum == null || hasLeftEndhsnum == null || hasRightEndhsnum == null) {
            isAP = true;
        }
        return isAP;
    }
}

