/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

public class CHE_AddressTerm {
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String COUNTRY_CODES_KEY = "country_codes";
    private static final String GERMAN_EXTENDED_CHARS_KEY = "german_extended_chars";
    private static final String FRENCH_EXTENDED_CHARS_KEY = "french_extended_chars";
    private static final String ITALIAN_EXTENDED_CHARS_KEY = "italian_extended_chars";
    private static final String SCORING_RULE_KEY = "scoring_rule_";
    private static final String COMMON_TERMS_KEY = "common_words_";
    private static final String VOWELS_KEY = "vowels";
    private static StringBuffer m_punctuationList;
    private static List m_cntryCodeList;
    private static List m_ordinalCharList;
    private static char[] m_validPunctuationChars;
    private static List m_ita_Comman_Word;
    private static List m_deu_Comman_Word;
    private static List m_fra_Comman_Word;
    private static List m_deu_Extended_Char;
    private static List m_fra_Extended_Char;
    private static List m_ita_Extended_Char;
    private static Map m_extended_CharMap;
    private static final String m_specialCharacter = "~";
    private static ArrayList m_Vowels;
    private static HashMap m_stateAbbreviationMap;
    private static List m_scoringRuleList;
    private static final Pattern CHE_SPECIALCHARHANDLING;
    private static final Pattern CHE_SPACESPECIALCHARHANDLING;
    public static ArrayList m_commonTermList;

    private static void loadCommonWords(String commonWords, String countryKey) {
        if (countryKey.equalsIgnoreCase("ITA")) {
            m_ita_Comman_Word = new ArrayList();
            CHE_AddressTerm.loadList(m_ita_Comman_Word, commonWords);
        } else if (countryKey.equalsIgnoreCase("FRA")) {
            m_fra_Comman_Word = new ArrayList();
            CHE_AddressTerm.loadList(m_fra_Comman_Word, commonWords);
        } else if (countryKey.equalsIgnoreCase("DEU")) {
            m_deu_Comman_Word = new ArrayList();
            CHE_AddressTerm.loadList(m_deu_Comman_Word, commonWords);
        }
    }

    private static void loadList(List listtoBeLoaded, String values) {
        String commonString = null;
        StringTokenizer tokens = new StringTokenizer(values, ",");
        while (tokens.hasMoreElements()) {
            commonString = tokens.nextToken().trim();
            if (commonString.length() <= 0) continue;
            listtoBeLoaded.add(commonString);
        }
    }

    public static boolean isCommonItalianWord(String word) {
        return CHE_AddressTerm.isWordinList(m_ita_Comman_Word, word);
    }

    public static boolean isCommonFrenchWord(String word) {
        return CHE_AddressTerm.isWordinList(m_fra_Comman_Word, word);
    }

    public static boolean isCommonGermanWord(String word) {
        return CHE_AddressTerm.isWordinList(m_deu_Comman_Word, word);
    }

    private static Properties loadpropertyfile(String propertyfile) {
        Properties properties = null;
        try {
            properties = FileUtilities.loadProperties((String)propertyfile);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load " + propertyfile);
        }
        return properties;
    }

    private static void loadproperties(Properties properties, int propertyToLoad) {
        String key = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            switch (propertyToLoad) {
                case 0: {
                    CHE_AddressTerm.loadCommonWords(properties.getProperty(key), key);
                    break;
                }
                case 1: {
                    CHE_AddressTerm.loadAddressTerm(properties.getProperty(key), key);
                    break;
                }
                case 2: {
                    CHE_AddressTerm.loadStateAbbreviation(properties);
                }
            }
        }
    }

    private static void loadStateAbbreviation(Properties properties) {
        if (m_stateAbbreviationMap == null) {
            m_stateAbbreviationMap = new HashMap();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            if (key == null || value == null) continue;
            m_stateAbbreviationMap.put(key.toUpperCase(), value.trim().toUpperCase());
        }
    }

    private static void loadExtendedChars(String propertyFile) {
        try {
            Properties propertiesFile = FileUtilities.loadProperties((String)propertyFile);
            if (propertiesFile != null) {
                for (String string : propertiesFile.keySet()) {
                    String extendedCharacters = propertiesFile.getProperty(string);
                    CHE_AddressTerm.fillExtendedCharsMap(string, extendedCharacters);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load the property file " + propertyFile);
        }
    }

    private static void fillExtendedCharsMap(String normalCharacter, String value) {
        if (m_extended_CharMap == null) {
            m_extended_CharMap = new HashMap();
        }
        String[] extendedCharactersArray = value.split(",");
        for (int i = 0; i < extendedCharactersArray.length; ++i) {
            m_extended_CharMap.put(extendedCharactersArray[i], normalCharacter);
        }
    }

    public String getNormalReplacementCharacter(char c) {
        String normChar = (String)m_extended_CharMap.get(String.valueOf(c));
        if (normChar == null) {
            return String.valueOf(c);
        }
        return normChar;
    }

    public static String cleanExtendedCharsInString(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer cleanedStr = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String normChar = (String)m_extended_CharMap.get(String.valueOf(c));
            if (normChar == null) {
                cleanedStr.append(c);
                continue;
            }
            cleanedStr.append(normChar);
        }
        return cleanedStr.toString();
    }

    private static void loadAddressTerm(String properties, String key) {
        if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
            CHE_AddressTerm.loadPunctuations(properties);
        } else if (key.startsWith(COUNTRY_CODES_KEY)) {
            CHE_AddressTerm.loadCountryCodes(properties);
        } else if (key.startsWith(GERMAN_EXTENDED_CHARS_KEY)) {
            CHE_AddressTerm.loadExtendedChars(properties, 0);
        } else if (key.startsWith(FRENCH_EXTENDED_CHARS_KEY)) {
            CHE_AddressTerm.loadExtendedChars(properties, 1);
        } else if (key.startsWith(ITALIAN_EXTENDED_CHARS_KEY)) {
            CHE_AddressTerm.loadExtendedChars(properties, 2);
        } else if (key.startsWith(SCORING_RULE_KEY)) {
            if (m_scoringRuleList == null) {
                m_scoringRuleList = new ArrayList();
            }
            CHE_AddressTerm.loadScoringRules(m_scoringRuleList, properties);
        } else if (key.startsWith(COMMON_TERMS_KEY)) {
            if (m_commonTermList == null) {
                m_commonTermList = new ArrayList();
            }
            CHE_AddressTerm.loadCommonTerms(properties);
        } else if (key.startsWith(VOWELS_KEY)) {
            CHE_AddressTerm.loadVowels(properties);
        }
    }

    private static void loadExtendedChars(String value, int countryCode) {
        if (value != null) {
            switch (countryCode) {
                case 0: {
                    if (m_deu_Extended_Char != null) break;
                    m_deu_Extended_Char = new ArrayList();
                    CHE_AddressTerm.loadExtendedCharacters(m_deu_Extended_Char, value);
                    break;
                }
                case 1: {
                    if (m_fra_Extended_Char != null) break;
                    m_fra_Extended_Char = new ArrayList();
                    CHE_AddressTerm.loadExtendedCharacters(m_fra_Extended_Char, value);
                    break;
                }
                case 2: {
                    if (m_ita_Extended_Char != null) break;
                    m_ita_Extended_Char = new ArrayList();
                    CHE_AddressTerm.loadExtendedCharacters(m_ita_Extended_Char, value);
                }
            }
        }
    }

    private static void loadExtendedCharacters(List listtoBeLoaded, String values) {
        char[] characters = values.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i] == ',') continue;
            listtoBeLoaded.add(new Character(characters[i]));
        }
    }

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (m_punctuationList == null) {
                m_punctuationList = new StringBuffer(raw.length());
            }
            m_punctuationList.append(raw);
        }
    }

    private static void loadCountryCodes(String raw) {
        if (m_cntryCodeList == null) {
            m_cntryCodeList = new ArrayList(5);
        }
        if (raw != null && raw.trim().length() > 0) {
            CHE_AddressTerm.loadList(m_cntryCodeList, raw);
        }
    }

    public static boolean isPunctuation(String term) {
        boolean result = false;
        if (m_punctuationList != null && term != null && m_punctuationList.toString().indexOf(term) > -1) {
            result = true;
        }
        return result;
    }

    public static boolean isExtendedCharacter(char ch, String countryCode) {
        if (countryCode == null) {
            return false;
        }
        boolean result = false;
        if (countryCode.equals("DEU")) {
            if (m_deu_Extended_Char.contains(new Character(ch))) {
                result = true;
            }
        } else if (countryCode.equals("FRA")) {
            if (m_fra_Extended_Char.contains(new Character(ch))) {
                result = true;
            }
        } else if (countryCode.equals("ITA") && m_ita_Extended_Char.contains(new Character(ch))) {
            result = true;
        }
        return result;
    }

    public static boolean isExtendedCharacter(char ch) {
        boolean result = false;
        if (m_deu_Extended_Char.contains(new Character(ch))) {
            result = true;
        } else if (m_fra_Extended_Char.contains(new Character(ch))) {
            result = true;
        } else if (m_ita_Extended_Char.contains(new Character(ch))) {
            result = true;
        }
        return result;
    }

    public static boolean containsGermanExtendedCharacter(String inputString) {
        if (inputString == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < inputString.length() && !(result = CHE_AddressTerm.isExtendedCharacter(inputString.charAt(i), "DEU")); ++i) {
        }
        return result;
    }

    public static boolean containsFrenchExtendedCharacter(String inputString) {
        if (inputString == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < inputString.length() && !(result = CHE_AddressTerm.isExtendedCharacter(inputString.charAt(i), "FRA")); ++i) {
        }
        return result;
    }

    public static boolean containsItalianExtendedCharacter(String inputString) {
        if (inputString == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < inputString.length() && !(result = CHE_AddressTerm.isExtendedCharacter(inputString.charAt(i), "ITA")); ++i) {
        }
        return result;
    }

    public static boolean isCommonWord(String mayBeCommonWord) {
        boolean result = false;
        if (mayBeCommonWord != null && mayBeCommonWord.length() != 0) {
            if (CHE_AddressTerm.isCommonGermanWord(mayBeCommonWord)) {
                result = true;
            } else if (CHE_AddressTerm.isCommonFrenchWord(mayBeCommonWord)) {
                result = true;
            } else if (CHE_AddressTerm.isCommonItalianWord(mayBeCommonWord)) {
                result = true;
            }
        }
        return result;
    }

    public static String[] getLanguagesOfCommonWords(String mayBeCommonWord) {
        String[] languagesArray = new String[3];
        Vector<String> languagesVector = new Vector<String>(3);
        if (CHE_AddressTerm.isCommonGermanWord(mayBeCommonWord)) {
            languagesVector.add("DEU");
        }
        if (CHE_AddressTerm.isCommonFrenchWord(mayBeCommonWord)) {
            languagesVector.add("FRA");
        }
        if (CHE_AddressTerm.isCommonItalianWord(mayBeCommonWord)) {
            languagesVector.add("ITA");
        }
        languagesVector.toArray(languagesArray);
        return languagesArray;
    }

    public static String getOrdinalsAsString() {
        String characterString = null;
        if (m_ordinalCharList != null) {
            characterString = m_ordinalCharList.toString();
        }
        return characterString;
    }

    public static String getPunctuationsAsString() {
        String characterString = null;
        if (m_punctuationList != null) {
            characterString = m_punctuationList.toString();
        }
        return characterString;
    }

    public static boolean isOrdinal(String maBeOrdinalTerm) {
        boolean result = false;
        if (m_ordinalCharList != null && maBeOrdinalTerm != null && (m_ordinalCharList.contains(maBeOrdinalTerm) || m_ordinalCharList.contains(maBeOrdinalTerm.toUpperCase()))) {
            result = true;
        }
        return result;
    }

    public static String removeCommonWords(String inputString, boolean removePunctuation) {
        if (inputString == null || inputString.trim().length() == 0) {
            return null;
        }
        StringBuffer outTown = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inputString, CHE_AddressTerm.getPunctuationsAsString(), true);
        char lastPunctuation = '\u0000';
        boolean hadProperWord = false;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.length() == 1) {
                if (!CHE_AddressTerm.isPunctuation(temp.charAt(0))) continue;
                if (!removePunctuation) {
                    if (lastPunctuation != temp.charAt(0)) {
                        outTown.append(temp);
                    }
                    lastPunctuation = temp.charAt(0);
                    continue;
                }
                if (hadProperWord) {
                    outTown.append(" ");
                }
                hadProperWord = false;
                continue;
            }
            if (CHE_AddressTerm.isCommonWord(temp)) continue;
            outTown.append(temp);
            lastPunctuation = '\u0000';
            hadProperWord = true;
        }
        String shortTown = outTown.toString().trim();
        if (shortTown.length() > 0) {
            while (shortTown.length() > 0 && CHE_AddressTerm.isPunctuation(shortTown.substring(0, 1))) {
                shortTown = shortTown.substring(1);
            }
        }
        if (shortTown.length() == 0) {
            return null;
        }
        return shortTown;
    }

    public static boolean isWordinList(List list, String word) {
        boolean iswordPresent = false;
        if (list == null || word == null) {
            return false;
        }
        int numberOfTypes = list.size();
        String type = null;
        for (int i = 0; i < numberOfTypes; ++i) {
            type = (String)list.get(i);
            if (word == null || !word.equalsIgnoreCase(type)) continue;
            iswordPresent = true;
            break;
        }
        return iswordPresent;
    }

    public static boolean isCountryCode(String counntryString) {
        return CHE_AddressTerm.isWordinList(m_cntryCodeList, counntryString);
    }

    public static boolean isPunctuation(char ch) {
        return m_punctuationList != null && m_punctuationList.toString().indexOf(ch) != -1;
    }

    public static String getValidTerm(String inTerm) {
        return CHE_AddressTerm.getValidTerm(inTerm, false);
    }

    public static String getValidTerm(String inTerm, boolean canHaveNumeric) {
        if (inTerm == null || inTerm.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(inTerm.length());
        char lastChar = '\u0000';
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.charAt(i);
            if (ch == '_') {
                ch = '-';
            }
            if (ch == ',') {
                ch = ' ';
            }
            if (CHE_AddressTerm.isValidPunctuationCharacter(ch) && buf.length() > 0) {
                if (lastChar != ch) {
                    buf.append(ch);
                }
            } else if (ch == '\'') {
                buf.append(ch);
            } else if (ch == '/') {
                buf.append(ch);
            } else if (Character.isLetter(ch)) {
                buf.append(ch);
            } else if (CHE_AddressTerm.isCommonword(ch)) {
                buf.append(ch);
            } else if (canHaveNumeric && CHE_AddressTerm.isDigit(ch)) {
                buf.append(ch);
            }
            lastChar = ch;
        }
        if (buf.length() > 0) {
            return buf.toString().trim();
        }
        return null;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static boolean isValidPunctuationCharacter(char ch) {
        for (int i = 0; i < m_validPunctuationChars.length; ++i) {
            if (ch != m_validPunctuationChars[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isCommonword(char term) {
        boolean result = false;
        if (CHE_AddressTerm.isCommonItalianWord(String.valueOf(term))) {
            result = true;
        } else if (CHE_AddressTerm.isCommonFrenchWord(String.valueOf(term))) {
            result = true;
        } else if (CHE_AddressTerm.isCommonGermanWord(String.valueOf(term))) {
            result = true;
        }
        return result;
    }

    public static String getDelimiters() {
        String delimiters = null;
        StringBuffer buf = new StringBuffer(20);
        if (CHE_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(CHE_AddressTerm.getPunctuationsAsString());
        }
        if (CHE_AddressTerm.getOrdinalsAsString() != null) {
            buf.append(CHE_AddressTerm.getOrdinalsAsString());
        }
        if (buf.length() > 0) {
            delimiters = buf.toString();
        }
        return delimiters;
    }

    public static String getStateAbbreviation(String fullNameForAbbr) {
        String fullName = null;
        if (fullNameForAbbr != null && fullNameForAbbr.length() != 0) {
            fullName = (String)m_stateAbbreviationMap.get(fullNameForAbbr.toUpperCase());
        }
        return fullName;
    }

    public static boolean isStateAbbreviatedValue(String maybeStateName) {
        boolean result = false;
        if (maybeStateName != null && maybeStateName.length() != 0) {
            result = m_stateAbbreviationMap.containsValue(maybeStateName.trim().toUpperCase());
        }
        return result;
    }

    public static boolean isStateAbbreviation(String mayBeStateAbbreviation) {
        boolean result = false;
        if (mayBeStateAbbreviation != null && mayBeStateAbbreviation.length() != 0) {
            result = m_stateAbbreviationMap.containsKey(mayBeStateAbbreviation.toUpperCase());
        }
        return result;
    }

    public static boolean isAlpha(char ch) {
        char c = Character.toUpperCase(ch);
        return c >= 'A' && c <= 'Z';
    }

    public static String replacePunctuationWithSpace(String stringToEvaluate) {
        if (stringToEvaluate == null) {
            return null;
        }
        return stringToEvaluate.replaceAll("\\p{Punct}", " ");
    }

    public static String replaceMultipleSpace(String stringToEvaluate) {
        if (stringToEvaluate == null) {
            return null;
        }
        int spaceIndex = stringToEvaluate.indexOf("  ");
        while (spaceIndex != -1) {
            String str1 = stringToEvaluate.substring(0, spaceIndex);
            String str2 = stringToEvaluate.substring(stringToEvaluate.indexOf("  "), stringToEvaluate.length()).trim();
            stringToEvaluate = str1 + " " + str2;
            spaceIndex = stringToEvaluate.indexOf("  ");
        }
        return stringToEvaluate;
    }

    public static String replaceSpaceWithSpecialCharacter(String stringToEvaluate) {
        if (stringToEvaluate != null && stringToEvaluate.length() > 0) {
            return CHE_SPACESPECIALCHARHANDLING.matcher(stringToEvaluate.toUpperCase()).replaceAll(m_specialCharacter).trim();
        }
        return stringToEvaluate;
    }

    public static String replaceSpaceWithHyphen(String stringToEvaluate) {
        if (stringToEvaluate != null && stringToEvaluate.length() > 0) {
            return CHE_SPACESPECIALCHARHANDLING.matcher(stringToEvaluate.toUpperCase()).replaceAll("-").trim();
        }
        return stringToEvaluate;
    }

    public static String replaceSpecialCharacterWithSpace(String streetAddress) {
        String result = null;
        if (streetAddress != null) {
            result = CHE_SPECIALCHARHANDLING.matcher(streetAddress.toUpperCase()).replaceAll(" ").trim();
        }
        return result;
    }

    private static void loadScoringRules(List listtoBeLoaded, String values) {
        listtoBeLoaded.add(values);
    }

    public static String getScoringRules() {
        if (m_scoringRuleList != null && m_scoringRuleList.size() > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < m_scoringRuleList.size(); ++i) {
                buff.append((String)m_scoringRuleList.get(i));
                buff.append(" ");
            }
            return buff.toString();
        }
        return "";
    }

    public static String getVowelsAsString() {
        if (m_Vowels == null) {
            return null;
        }
        return m_Vowels.toString();
    }

    private static void loadVowels(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (m_Vowels == null) {
                m_Vowels = new ArrayList(10);
            }
            String vowel = null;
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                vowel = st.nextToken().trim();
                if (vowel.length() <= 0) continue;
                m_Vowels.add(vowel.toLowerCase());
            }
        }
    }

    public static String removeVowels(String inTerm) {
        if (inTerm == null) {
            return null;
        }
        String vowels = CHE_AddressTerm.getVowelsAsString();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.toLowerCase().charAt(i);
            if (vowels.indexOf(ch) == -1) {
                buf.append(ch);
            }
            if (ch != ' ') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    private static void loadCommonTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (m_commonTermList == null) {
                m_commonTermList = new ArrayList(10);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String commonWord = st.nextToken().trim();
                if (commonWord.length() <= 0) continue;
                m_commonTermList.add(commonWord.toUpperCase());
            }
        }
    }

    static {
        m_validPunctuationChars = new char[]{'-', '\'', ',', ' ', '.'};
        m_Vowels = null;
        CHE_SPECIALCHARHANDLING = Pattern.compile(m_specialCharacter);
        CHE_SPACESPECIALCHARHANDLING = Pattern.compile(" ");
        m_commonTermList = null;
        Properties properties = null;
        try {
            properties = CHE_AddressTerm.loadpropertyfile("com/mapinfo/mapmarker/CHE/parser/CHE_CommonWords.properties");
            CHE_AddressTerm.loadproperties(properties, 0);
            properties = CHE_AddressTerm.loadpropertyfile("com/mapinfo/mapmarker/CHE/parser/CHE_StateAbbreviations.properties");
            CHE_AddressTerm.loadproperties(properties, 2);
            CHE_AddressTerm.loadExtendedChars("com/mapinfo/mapmarker/CHE/parser/ITAExtendedCharacters.properties");
            CHE_AddressTerm.loadExtendedChars("com/mapinfo/mapmarker/CHE/parser/FRAExtendedCharacters.properties");
            CHE_AddressTerm.loadExtendedChars("com/mapinfo/mapmarker/CHE/parser/DEUExtendedCharacters.properties");
            properties = CHE_AddressTerm.loadpropertyfile("com/mapinfo/mapmarker/CHE/parser/CHE_AddressTerm.properties");
            CHE_AddressTerm.loadproperties(properties, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

