/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.parser;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class CHE_ParsePostAddressRule
implements IParseRule {
    public static final int POSTCODE_INVALID = 0;
    public static final int POSTCODE_PARTIAL = 1;
    public static final int POSTCODE_POST4 = 2;
    public static final int POSTCODE_POST4_PARTIAL = 3;
    public static final int POSTCODE_FULL = 4;
    public static final String CANTON_CODE = "canton_code";
    private static ArrayList multiWordAreaNames = null;
    private static final String CHE_MULTI_WORD_AREA_NAME_PROPERTIES = "com/mapinfo/mapmarker/CHE/parser/CHE_MultiWordAreaNames.properties";

    public void parse(Address unrefinedAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        LinkedList listOfTokens = null;
        StringTokenizer tokens = null;
        String mayRequreAN3 = null;
        String postCodeUnparsed = parsedAddress.getPostCode1();
        if (postCodeUnparsed != null) {
            parsedAddress.setPostCode1(CHE_PreParseHandler.removePostBoxKeywords(postCodeUnparsed));
        }
        String postAddressData = parsedAddress.getPostAddress();
        String areaName3 = parsedAddress.getAreaName3();
        boolean hasAreaName3 = false;
        if (areaName3 != null && areaName3.length() > 0) {
            hasAreaName3 = true;
        }
        if (postAddressData != null && postAddressData.trim().length() > 0) {
            postAddressData = CHE_PreParseHandler.removePostBoxKeywords(postAddressData);
            postAddressData = CHE_AddressTerm.cleanExtendedCharsInString(postAddressData);
            postAddressData = CHE_AddressTerm.replaceMultipleSpace(postAddressData);
            parsedAddress.setPostAddress(postAddressData);
            postAddressData = CHE_ParsePostAddressRule.removeCommonWords(postAddressData);
            if (postAddressData != null) {
                tokens = new StringTokenizer(postAddressData, CHE_AddressTerm.getPunctuationsAsString(), true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            }
        } else if (areaName3 != null && areaName3.length() > 0) {
            String str = areaName3 = CHE_PreParseHandler.removePostBoxKeywords(areaName3);
            if ((areaName3 = CHE_ParsePostAddressRule.removeCommonWords(areaName3)) == null) {
                areaName3 = str;
            }
            parsedAddress.setAreaName3(areaName3);
            mayRequreAN3 = areaName3;
            areaName3 = CHE_ParsePostAddressRule.removeCommonWords(areaName3);
            if (areaName3 == null) {
                hasAreaName3 = false;
            }
            if (areaName3 != null) {
                StringTokenizer token = new StringTokenizer(areaName3, CHE_AddressTerm.getPunctuationsAsString(), true);
                LinkedList list = StringUtilities.tokensToList((StringTokenizer)token);
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < list.size(); ++i) {
                    buff.append((String)list.get(i));
                }
                this.removeStateAbbreviation(list, parsedAddress, false);
                this.seperateNumberFromTown(list, parsedAddress);
                String st = null;
                if (list.size() == 0) {
                    int index = str.indexOf(buff.toString());
                    if (index > 0) {
                        st = str.substring(0, index);
                    } else if (index == 0) {
                        st = str.substring(buff.toString().length());
                    }
                }
                this.seperateTown(list, parsedAddress);
                if (parsedAddress.getAreaName3() == null) {
                    parsedAddress.setAreaName3(st);
                } else if (CHE_AddressTerm.isStateAbbreviation(parsedAddress.getAreaName3()) || StringUtilities.isNumeric((String)parsedAddress.getAreaName3())) {
                    parsedAddress.setAreaName3(st);
                }
            }
            if (parsedAddress.getAreaName3() == null) {
                parsedAddress.setAreaName3(mayRequreAN3);
            }
        }
        if (listOfTokens != null) {
            listOfTokens = this.removeCountry(listOfTokens);
            this.seperateCantonCode(listOfTokens, parsedAddress);
            this.seperateSortCode(listOfTokens, parsedAddress);
            this.seperatePostcode(listOfTokens, parsedAddress);
            String town = parsedAddress.getAreaName3();
            if (!hasAreaName3) {
                if (town != null && town.length() > 0) {
                    town = CHE_ParsePostAddressRule.removeCommonWords(town);
                    parsedAddress.setAreaName3(town);
                    tokens = new StringTokenizer(town, CHE_AddressTerm.getPunctuationsAsString(), true);
                    LinkedList listOfToken = StringUtilities.tokensToList((StringTokenizer)tokens);
                    this.seperateNumberFromTown(listOfToken, parsedAddress);
                    this.seperateTown(listOfToken, parsedAddress);
                } else {
                    this.removeStateAbbreviation(listOfTokens, parsedAddress, true);
                    this.seperateNumberFromTown(listOfTokens, parsedAddress);
                    String maybeusedAn3 = parsedAddress.getAreaName3();
                    this.seperateTown(listOfTokens, parsedAddress);
                    if (parsedAddress.getAreaName3() == null) {
                        parsedAddress.setAreaName3(maybeusedAn3);
                    }
                }
            }
            if (listOfTokens != null) {
                this.normaliseTerms(listOfTokens);
                StringBuffer postAddressBuff = new StringBuffer();
                for (int i = 0; i < listOfTokens.size(); ++i) {
                    postAddressBuff.append(listOfTokens.get(i));
                }
                String postAdd = postAddressBuff.toString();
                String string = postAdd = postAdd == null ? "" : postAdd.trim();
                if (postAdd.length() > 0) {
                    parsedAddress.setPostAddress(postAdd);
                } else {
                    parsedAddress.setPostAddress(null);
                }
            }
        }
        if (postCodeUnparsed != null && postCodeUnparsed.trim().length() > 0) {
            postCodeUnparsed = CHE_PreParseHandler.removePostBoxKeywords(postCodeUnparsed.trim());
            tokens = new StringTokenizer(postCodeUnparsed, CHE_AddressTerm.getPunctuationsAsString(), true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            this.seperateCantonCode(listOfTokens, parsedAddress);
            this.seperatePostcode(listOfTokens, parsedAddress);
        }
        if (parsedAddress.getAreaName1() == null && parsedAddress.getPostAddress() != null) {
            if (parsedAddress.getPostAddress() != null && parsedAddress.getAreaName3() == null) {
                parsedAddress.setAreaName3(parsedAddress.getPostAddress());
            }
            if (!parsedAddress.getPostAddress().trim().equalsIgnoreCase(parsedAddress.getAreaName3().trim())) {
                parsedAddress.setGenericField1(parsedAddress.getPostAddress());
            }
        }
        parsedAddress.setAreaName4(null);
        parsedAddress.setPostAddress(null);
    }

    private void seperatePostcode(LinkedList listOfTokens, Address parsedAddress) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        int len = listOfTokens.size();
        boolean partPostcode = false;
        StringBuffer postBuf = new StringBuffer();
        int type = 0;
        for (int i = 0; i < len; ++i) {
            String temp = (String)listOfTokens.get(i);
            if (StringUtilities.isNumeric((String)temp)) {
                if (postBuf.length() < 4 && partPostcode) {
                    if (temp.length() > 4 - postBuf.length()) {
                        listOfTokens.set(i, temp.substring(4 - postBuf.length()));
                        postBuf.append(temp.substring(0, 4 - postBuf.length()));
                    } else {
                        postBuf.append(temp.substring(0));
                        listOfTokens.remove(i);
                        --len;
                    }
                    partPostcode = true;
                    continue;
                }
                if (temp.length() > 4) {
                    postBuf.append(temp.substring(0, 4));
                    listOfTokens.remove(i);
                    --len;
                    partPostcode = false;
                    continue;
                }
                postBuf.append(temp);
                listOfTokens.remove(i);
                --len;
                partPostcode = true;
                continue;
            }
            if (StringUtilities.hasNumeric((String)temp)) {
                type = this.checkPostcode(temp);
                if (type == 4) {
                    postBuf.delete(0, postBuf.length());
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    continue;
                }
                if (partPostcode) {
                    type = this.checkPostcode(postBuf.toString() + temp);
                    if (type != 4) continue;
                    postBuf.delete(0, postBuf.length());
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    break;
                }
                if (temp.length() == 2) {
                    type = this.checkPostcode(postBuf.toString() + temp);
                    if (type != 4) continue;
                    postBuf.delete(0, postBuf.length());
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    break;
                }
                if (temp.equals(" ") || temp.equals("-")) continue;
                partPostcode = false;
                continue;
            }
            if (!partPostcode || temp.length() != 2 || (type = this.checkPostcode(postBuf.toString() + temp)) <= 2) continue;
            postBuf.append(temp);
            listOfTokens.remove(i);
            --len;
            break;
        }
        if (parsedAddress.getPostCode1() == null || !StringUtilities.isNumeric((String)parsedAddress.getPostCode1())) {
            parsedAddress.setPostCode1(this.getPost4(postBuf.toString()));
        }
    }

    public static String removeCommonWords(String inTown) {
        if (inTown == null || inTown.trim().length() == 0) {
            return null;
        }
        StringBuffer outTown = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inTown, CHE_AddressTerm.getPunctuationsAsString(), true);
        char lastPunctuation = '\u0000';
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.length() == 1) {
                if (!CHE_AddressTerm.isPunctuation(temp.charAt(0))) continue;
                if (lastPunctuation != temp.charAt(0)) {
                    outTown.append(temp);
                }
                lastPunctuation = temp.charAt(0);
                continue;
            }
            if (CHE_AddressTerm.isCommonWord(temp)) continue;
            outTown.append(temp);
            lastPunctuation = '\u0000';
        }
        String shortTown = outTown.toString().trim();
        if (shortTown.length() > 0) {
            while (shortTown.length() > 0 && CHE_AddressTerm.isPunctuation(shortTown.substring(0, 1))) {
                shortTown = shortTown.substring(1);
            }
        }
        if (shortTown.length() == 0) {
            return null;
        }
        return shortTown;
    }

    private int checkPostcode(String postcode) {
        int len = (postcode = postcode == null ? "" : postcode.trim()).length();
        if (len == 0 || postcode.startsWith("0")) {
            return 0;
        }
        String noSpacesPostCode = "";
        StringTokenizer st = new StringTokenizer(postcode, " -");
        while (st.hasMoreTokens()) {
            noSpacesPostCode = noSpacesPostCode + st.nextToken();
        }
        postcode = noSpacesPostCode;
        len = postcode.length();
        String digits = "";
        String letters = "";
        for (int i = 0; i < len; ++i) {
            char ch = postcode.charAt(i);
            if (CHE_ParsePostAddressRule.isDigit(ch)) {
                if (!letters.equals("")) break;
                digits = digits + ch;
                continue;
            }
            if (!Character.isLetter(ch)) break;
            letters = letters + ch;
        }
        int type = 0;
        if (digits.length() == 4) {
            type = 2;
        } else if (digits.length() > 0) {
            type = 1;
        }
        if (letters.length() == 2) {
            if (type == 2) {
                type = 4;
            } else if (type == 1) {
                type = 3;
            }
        }
        return type;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getPost4(String postcode) {
        int len;
        int pos = 0;
        if (postcode != null && (len = postcode.length()) > 0) {
            for (int i = 0; i < 4 && i < len && CHE_ParsePostAddressRule.isDigit(postcode.charAt(i)); ++i) {
                ++pos;
            }
        }
        if (pos > 0) {
            return postcode.substring(0, pos);
        }
        return null;
    }

    private void seperateCantonCode(LinkedList listOfTokens, Address pa) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        String cantonCode = null;
        String term = (String)listOfTokens.get(0);
        if (term != null) {
            term = term.trim();
        }
        if (StringUtilities.isNumeric((String)term)) {
            return;
        }
        if (term.length() >= 2 && CHE_AddressTerm.isAlpha(term.charAt(0)) && CHE_AddressTerm.isAlpha(term.charAt(1))) {
            if (term.length() == 2) {
                for (int i = 1; i < listOfTokens.size(); ++i) {
                    String followingTerm = (String)listOfTokens.get(i);
                    if (followingTerm.length() == 1 && CHE_AddressTerm.getPunctuationsAsString().indexOf(followingTerm.charAt(0)) > -1) continue;
                    if (StringUtilities.isNumeric((String)followingTerm)) {
                        cantonCode = term;
                        term = null;
                        continue;
                    }
                    term = null;
                    break;
                }
            } else if (!CHE_AddressTerm.isAlpha(term.charAt(2))) {
                cantonCode = term;
                term = term.substring(2);
            }
        }
        if (cantonCode != null) {
            HashMap<String, String> addFields = pa.getAdditionalFields();
            if (addFields == null) {
                addFields = new HashMap<String, String>(5);
            }
            addFields.put(CANTON_CODE, cantonCode);
            if (term == null) {
                listOfTokens.removeFirst();
            } else {
                listOfTokens.set(0, term);
            }
        }
    }

    private void seperateSortCode(LinkedList listOfTokens, Address pa) {
        String temp = null;
        if (listOfTokens != null) {
            while (listOfTokens.size() > 0) {
                temp = (String)listOfTokens.getLast();
                if (temp.equalsIgnoreCase(" ")) {
                    listOfTokens.removeLast();
                    continue;
                }
                if (!StringUtilities.isNumeric((String)temp) || temp.length() >= 3) break;
                pa.setPostCode2(temp);
                listOfTokens.removeLast();
                break;
            }
        }
    }

    private String removeCountryStart(String term) {
        if (term == null || term.length() == 0) {
            return null;
        }
        int lastLetterIndex = term.length();
        String section = null;
        for (int i = lastLetterIndex; i > 0; --i) {
            section = term.substring(0, i);
            if (!CHE_AddressTerm.isCountryCode(section)) continue;
            String endSection = term.substring(section.length());
            return endSection;
        }
        return term;
    }

    private LinkedList removeCountry(LinkedList listOfTokens) {
        boolean countryCodeFound = false;
        StringBuffer buff = new StringBuffer();
        String temp = null;
        for (int n = 0; n < listOfTokens.size(); ++n) {
            temp = (String)listOfTokens.get(n);
            if (CHE_AddressTerm.isCountryCode(temp)) {
                countryCodeFound = true;
                continue;
            }
            countryCodeFound = false;
            if (temp.equals("-") && countryCodeFound) continue;
            String newTemp = this.removeCountryStart(temp);
            if (!temp.equalsIgnoreCase(newTemp) && newTemp.length() == 4 && StringUtilities.isNumeric((String)newTemp.substring(0, 4))) {
                temp = newTemp;
                buff.append(temp);
                continue;
            }
            buff.append(temp);
        }
        String newPostAddress = buff.toString().trim();
        if (newPostAddress == null || newPostAddress.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(buff.toString().trim(), CHE_AddressTerm.getPunctuationsAsString(), true);
        return StringUtilities.tokensToList((StringTokenizer)tokens);
    }

    private void normaliseTerms(LinkedList list) {
        if (list != null) {
            String term = null;
            while (list.size() > 0 && (term = (String)list.getFirst()).length() == 1 && CHE_AddressTerm.getPunctuationsAsString().indexOf(term) > -1) {
                list.removeFirst();
            }
        }
    }

    private void seperateTown(LinkedList listOfTokens, Address parsedAddress) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        Iterator iter = listOfTokens.iterator();
        if (parsedAddress.getAreaName1() == null) {
            this.clearAllAreaNames(parsedAddress);
        }
        String term = null;
        StringBuffer origTownBuff = new StringBuffer();
        while (iter.hasNext()) {
            term = iter.next().toString();
            if (term.equals("(") || term.equals(")")) continue;
            if (CHE_AddressTerm.isStateAbbreviation(term)) {
                parsedAddress.setAreaName1(CHE_AddressTerm.getStateAbbreviation(term));
                iter.remove();
                continue;
            }
            if (term.equals(" ") || term.equals("-") || term.equals("'") || term.equals("/")) {
                origTownBuff.append(term);
                iter.remove();
                continue;
            }
            if (StringUtilities.isNumeric((String)term)) {
                iter.remove();
                continue;
            }
            if (CHE_AddressTerm.isPunctuation(term)) {
                origTownBuff.append(" ");
                iter.remove();
                continue;
            }
            if (CHE_AddressTerm.isCommonWord(term)) {
                iter.remove();
                continue;
            }
            origTownBuff.append(term);
            String shortTown = CHE_AddressTerm.getValidTerm(origTownBuff.toString().trim());
            if (shortTown != null) {
                shortTown = this.formatAreaName(shortTown);
            }
            if (CHE_ParsePostAddressRule.isMultiWordAreaName(CHE_AddressTerm.replacePunctuationWithSpace(CHE_AddressTerm.removeVowels(CHE_AddressTerm.cleanExtendedCharsInString(shortTown))))) {
                if (parsedAddress.getAreaName1() == null) {
                    this.clearAllAreaNames(parsedAddress);
                }
                parsedAddress.setAreaName3(shortTown);
                continue;
            }
            this.addStringToAreaNames(term, parsedAddress);
        }
    }

    private void seperateNumberFromTown(LinkedList listOfTokens, Address parsedAddress) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        StringBuffer townBuf = new StringBuffer();
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String maybeNumeric = listOfTokens.get(i).toString();
            if (StringUtilities.isNumeric((String)maybeNumeric)) {
                if (maybeNumeric.length() == 4 && parsedAddress.getPostCode1() == null) {
                    parsedAddress.setPostCode1(maybeNumeric);
                }
                listOfTokens.remove(i);
            }
            if (StringUtilities.isNumeric((String)maybeNumeric) || maybeNumeric.equals(",")) continue;
            townBuf.append(maybeNumeric);
        }
        if (townBuf.toString().length() > 0) {
            parsedAddress.setAreaName3(townBuf.toString());
        }
    }

    private void addStringToAreaNames(String s, Address pa) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (pa.getAreaName3() == null || pa.getAreaName3().length() == 0) {
            if (!StringUtilities.hasNumeric((String)s)) {
                pa.setAreaName3(s);
            }
        } else if (pa.getAreaName1() == null || pa.getAreaName1().length() == 0) {
            pa.setAreaName1(s);
        }
    }

    public void clearAllAreaNames(Address parsedAddress) {
        parsedAddress.setAreaName1(null);
        parsedAddress.setAreaName3(null);
    }

    private static void loadMultiWordAreaNames() {
        try {
            Properties properties = FileUtilities.loadProperties((String)CHE_MULTI_WORD_AREA_NAME_PROPERTIES);
            String key = null;
            multiWordAreaNames = new ArrayList();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                multiWordAreaNames.add(CHE_AddressTerm.replacePunctuationWithSpace(CHE_AddressTerm.removeVowels(CHE_AddressTerm.replaceSpecialCharacterWithSpace(CHE_AddressTerm.cleanExtendedCharsInString(key))).toUpperCase()));
            }
        }
        catch (FileNotFoundException fx) {
            System.err.println("Could not find com/mapinfo/mapmarker/CHE/parser/CHE_MultiWordAreaNames.properties");
            System.exit(1);
        }
        catch (IOException iox) {
            System.err.println("Could not read com/mapinfo/mapmarker/CHE/parser/CHE_MultiWordAreaNames.properties");
            System.exit(1);
        }
    }

    public static boolean isMultiWordAreaName(String word) {
        boolean result = false;
        String temp = CHE_AddressTerm.cleanExtendedCharsInString(word);
        if (temp != null) {
            String newWord = temp;
            result = multiWordAreaNames.contains(newWord.toUpperCase());
            if (!result && (newWord = CHE_AddressTerm.replaceSpaceWithSpecialCharacter(temp)) != null) {
                result = multiWordAreaNames.contains(newWord.toUpperCase());
            }
            if (!result) {
                newWord = temp;
                newWord = CHE_AddressTerm.replaceSpaceWithHyphen(temp);
                if (newWord != null) {
                    result = multiWordAreaNames.contains(newWord.toUpperCase());
                }
            }
        }
        return result;
    }

    public void removeStateAbbreviation(LinkedList listOfTokens, Address parsedAddress, boolean flag) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = listOfTokens.iterator();
        String mayBeStateAbbreviaton = null;
        while (iter.hasNext()) {
            mayBeStateAbbreviaton = (String)iter.next();
            if (CHE_AddressTerm.isStateAbbreviation(mayBeStateAbbreviaton)) {
                if (flag && parsedAddress.getAreaName1() == null) {
                    parsedAddress.setAreaName1(CHE_AddressTerm.getStateAbbreviation(mayBeStateAbbreviaton));
                }
                iter.remove();
                continue;
            }
            buffer.append(mayBeStateAbbreviaton);
        }
    }

    protected String formatAreaName(String shortTown) {
        shortTown = shortTown.replaceAll(" - ", "-");
        shortTown = shortTown.replaceAll("- ", "-");
        shortTown = shortTown.replaceAll(" -", "-");
        shortTown = shortTown.replaceAll("--", "-");
        shortTown = shortTown.replaceAll(" / ", "/");
        shortTown = shortTown.replaceAll("/ ", "/");
        shortTown = shortTown.replaceAll(" /", "/");
        return shortTown;
    }

    static {
        CHE_ParsePostAddressRule.loadMultiWordAreaNames();
    }
}

