/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.parser;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CHE_ThoroughFareTypes {
    private static List m_ita_ThoroughFare;
    private static List m_deu_ThoroughFare;
    private static List m_fra_ThoroughFare;

    private static void loadThoroughFareTypes(String throughfaretypes, String countryKey) {
        if (countryKey.equalsIgnoreCase("ITA")) {
            m_ita_ThoroughFare = new ArrayList();
            CHE_ThoroughFareTypes.loadList(m_ita_ThoroughFare, throughfaretypes);
        } else if (countryKey.equalsIgnoreCase("FRA")) {
            m_fra_ThoroughFare = new ArrayList();
            CHE_ThoroughFareTypes.loadList(m_fra_ThoroughFare, throughfaretypes);
        } else if (countryKey.equalsIgnoreCase("DEU")) {
            m_deu_ThoroughFare = new ArrayList();
            CHE_ThoroughFareTypes.loadList(m_deu_ThoroughFare, throughfaretypes);
        }
    }

    private static void loadList(List listtoBeLoaded, String throughfaretypes) {
        String throughfaretypesString = null;
        StringTokenizer tokens = new StringTokenizer(throughfaretypes, ",");
        while (tokens.hasMoreElements()) {
            throughfaretypesString = tokens.nextToken().trim();
            if (throughfaretypesString.length() <= 0) continue;
            listtoBeLoaded.add(throughfaretypesString);
        }
    }

    public static boolean isItalianThoroughFareType(String word) {
        return CHE_AddressTerm.isWordinList(m_ita_ThoroughFare, word);
    }

    public static boolean isFrenchThoroughFareType(String word) {
        return CHE_AddressTerm.isWordinList(m_fra_ThoroughFare, word);
    }

    public static boolean isGermanThoroughFareType(String word) {
        return CHE_AddressTerm.isWordinList(m_deu_ThoroughFare, word);
    }

    public static boolean isThoroughfareType(String mayBeStreetType) {
        boolean result = false;
        if (mayBeStreetType != null || mayBeStreetType.length() != 0) {
            if (CHE_ThoroughFareTypes.isGermanThoroughFareType(mayBeStreetType)) {
                result = true;
            } else if (CHE_ThoroughFareTypes.isFrenchThoroughFareType(mayBeStreetType)) {
                result = true;
            } else if (CHE_ThoroughFareTypes.isItalianThoroughFareType(mayBeStreetType)) {
                result = true;
            }
        }
        return result;
    }

    public static String[] getLanguagesOfThoroughfareType(String mayBeStreetType) {
        String[] languagesArray = new String[3];
        Vector<String> languagesVector = new Vector<String>(3);
        if (CHE_ThoroughFareTypes.isItalianThoroughFareType(mayBeStreetType)) {
            languagesVector.add("ITA");
        }
        if (CHE_ThoroughFareTypes.isFrenchThoroughFareType(mayBeStreetType)) {
            languagesVector.add("FRA");
        }
        if (CHE_ThoroughFareTypes.isGermanThoroughFareType(mayBeStreetType)) {
            languagesVector.add("DEU");
        }
        languagesVector.toArray(languagesArray);
        return languagesArray;
    }

    static {
        Properties properties = null;
        try {
            properties = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/parser/CHE_ThoroughfareTypes.properties");
            String key = null;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                CHE_ThoroughFareTypes.loadThoroughFareTypes(properties.getProperty(key), key);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load com/mapinfo/mapmarker/CHE/parser/CHE_ThoroughfareTypes.properties");
        }
    }
}

